/*
 * Decompiled with CFR 0.152.
 */
package com.helger.base.numeric;

import com.helger.annotation.CheckReturnValue;
import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.Immutable;
import com.helger.base.CGlobal;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.equals.EqualsHelper;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@Immutable
public final class BigHelper {
    private static final BigHelper INSTANCE = new BigHelper();

    private BigHelper() {
    }

    public static @NonNull BigDecimal getDividedBigDecimal(long l, long l2) {
        return BigHelper.toBigDecimal(l).divide(BigHelper.toBigDecimal(l2));
    }

    public static @NonNull BigDecimal getDividedBigDecimal(long l, long l2, @Nonnegative int n, @NonNull RoundingMode roundingMode) {
        return BigHelper.toBigDecimal(l).divide(BigHelper.toBigDecimal(l2), n, roundingMode);
    }

    public static @NonNull BigDecimal getMaxBigDecimal(@NonNull BigDecimal bigDecimal, BigDecimal ... bigDecimalArray) {
        BigDecimal bigDecimal2 = bigDecimal;
        for (BigDecimal bigDecimal3 : bigDecimalArray) {
            if (bigDecimal3.compareTo(bigDecimal2) <= 0) continue;
            bigDecimal2 = bigDecimal3;
        }
        return bigDecimal2;
    }

    public static @NonNull BigInteger getMaxBigInteger(@NonNull BigInteger bigInteger, BigInteger ... bigIntegerArray) {
        BigInteger bigInteger2 = bigInteger;
        for (BigInteger bigInteger3 : bigIntegerArray) {
            if (bigInteger3.compareTo(bigInteger2) <= 0) continue;
            bigInteger2 = bigInteger3;
        }
        return bigInteger2;
    }

    public static @NonNull BigDecimal getMinBigDecimal(@NonNull BigDecimal bigDecimal, BigDecimal ... bigDecimalArray) {
        BigDecimal bigDecimal2 = bigDecimal;
        for (BigDecimal bigDecimal3 : bigDecimalArray) {
            if (bigDecimal3.compareTo(bigDecimal2) >= 0) continue;
            bigDecimal2 = bigDecimal3;
        }
        return bigDecimal2;
    }

    public static @NonNull BigInteger getMinBigInteger(@NonNull BigInteger bigInteger, BigInteger ... bigIntegerArray) {
        BigInteger bigInteger2 = bigInteger;
        for (BigInteger bigInteger3 : bigIntegerArray) {
            if (bigInteger3.compareTo(bigInteger2) >= 0) continue;
            bigInteger2 = bigInteger3;
        }
        return bigInteger2;
    }

    public static @NonNull BigDecimal abs(@NonNull BigDecimal bigDecimal) {
        return bigDecimal.abs();
    }

    public static @NonNull BigInteger abs(@NonNull BigInteger bigInteger) {
        return bigInteger.abs();
    }

    public static boolean equalValues(@Nullable BigDecimal bigDecimal3, @Nullable BigDecimal bigDecimal4) {
        return EqualsHelper.equalsCustom(bigDecimal3, bigDecimal4, (bigDecimal, bigDecimal2) -> bigDecimal.compareTo((BigDecimal)bigDecimal2) == 0);
    }

    public static boolean isEQ0(@NonNull BigDecimal bigDecimal) {
        return BigHelper.equalValues(bigDecimal, BigDecimal.ZERO);
    }

    public static boolean isNE0(@NonNull BigDecimal bigDecimal) {
        return !BigHelper.equalValues(bigDecimal, BigDecimal.ZERO);
    }

    public static boolean isLT0(@NonNull BigDecimal bigDecimal) {
        return bigDecimal.compareTo(BigDecimal.ZERO) < 0;
    }

    public static boolean isLE0(@NonNull BigDecimal bigDecimal) {
        return bigDecimal.compareTo(BigDecimal.ZERO) <= 0;
    }

    public static boolean isGT0(@NonNull BigDecimal bigDecimal) {
        return bigDecimal.compareTo(BigDecimal.ZERO) > 0;
    }

    public static boolean isGE0(@NonNull BigDecimal bigDecimal) {
        return bigDecimal.compareTo(BigDecimal.ZERO) >= 0;
    }

    public static boolean isEQ1(@NonNull BigDecimal bigDecimal) {
        return BigHelper.equalValues(bigDecimal, BigDecimal.ONE);
    }

    public static boolean isNE1(@NonNull BigDecimal bigDecimal) {
        return !BigHelper.equalValues(bigDecimal, BigDecimal.ONE);
    }

    public static boolean isLT1(@NonNull BigDecimal bigDecimal) {
        return bigDecimal.compareTo(BigDecimal.ONE) < 0;
    }

    public static boolean isLE1(@NonNull BigDecimal bigDecimal) {
        return bigDecimal.compareTo(BigDecimal.ONE) <= 0;
    }

    public static boolean isGT1(@NonNull BigDecimal bigDecimal) {
        return bigDecimal.compareTo(BigDecimal.ONE) > 0;
    }

    public static boolean isGE1(@NonNull BigDecimal bigDecimal) {
        return bigDecimal.compareTo(BigDecimal.ONE) >= 0;
    }

    public static boolean isEQ10(@NonNull BigDecimal bigDecimal) {
        return BigHelper.equalValues(bigDecimal, BigDecimal.TEN);
    }

    public static boolean isNE10(@NonNull BigDecimal bigDecimal) {
        return !BigHelper.equalValues(bigDecimal, BigDecimal.TEN);
    }

    public static boolean isLT10(@NonNull BigDecimal bigDecimal) {
        return bigDecimal.compareTo(BigDecimal.TEN) < 0;
    }

    public static boolean isLE10(@NonNull BigDecimal bigDecimal) {
        return bigDecimal.compareTo(BigDecimal.TEN) <= 0;
    }

    public static boolean isGT10(@NonNull BigDecimal bigDecimal) {
        return bigDecimal.compareTo(BigDecimal.TEN) > 0;
    }

    public static boolean isGE10(@NonNull BigDecimal bigDecimal) {
        return bigDecimal.compareTo(BigDecimal.TEN) >= 0;
    }

    public static boolean isEQ100(@NonNull BigDecimal bigDecimal) {
        return BigHelper.equalValues(bigDecimal, CGlobal.BIGDEC_100);
    }

    public static boolean isNE100(@NonNull BigDecimal bigDecimal) {
        return !BigHelper.equalValues(bigDecimal, CGlobal.BIGDEC_100);
    }

    public static boolean isLT100(@NonNull BigDecimal bigDecimal) {
        return bigDecimal.compareTo(CGlobal.BIGDEC_100) < 0;
    }

    public static boolean isLE100(@NonNull BigDecimal bigDecimal) {
        return bigDecimal.compareTo(CGlobal.BIGDEC_100) <= 0;
    }

    public static boolean isGT100(@NonNull BigDecimal bigDecimal) {
        return bigDecimal.compareTo(CGlobal.BIGDEC_100) > 0;
    }

    public static boolean isGE100(@NonNull BigDecimal bigDecimal) {
        return bigDecimal.compareTo(CGlobal.BIGDEC_100) >= 0;
    }

    public static boolean isEQ0(@NonNull BigInteger bigInteger) {
        return bigInteger.equals(BigInteger.ZERO);
    }

    public static boolean isNE0(@NonNull BigInteger bigInteger) {
        return !bigInteger.equals(BigInteger.ZERO);
    }

    public static boolean isLT0(@NonNull BigInteger bigInteger) {
        return bigInteger.compareTo(BigInteger.ZERO) < 0;
    }

    public static boolean isLE0(@NonNull BigInteger bigInteger) {
        return bigInteger.compareTo(BigInteger.ZERO) <= 0;
    }

    public static boolean isGT0(@NonNull BigInteger bigInteger) {
        return bigInteger.compareTo(BigInteger.ZERO) > 0;
    }

    public static boolean isGE0(@NonNull BigInteger bigInteger) {
        return bigInteger.compareTo(BigInteger.ZERO) >= 0;
    }

    public static boolean isEQ1(@NonNull BigInteger bigInteger) {
        return bigInteger.equals(BigInteger.ONE);
    }

    public static boolean isNE1(@NonNull BigInteger bigInteger) {
        return !bigInteger.equals(BigInteger.ONE);
    }

    public static boolean isLT1(@NonNull BigInteger bigInteger) {
        return bigInteger.compareTo(BigInteger.ONE) < 0;
    }

    public static boolean isLE1(@NonNull BigInteger bigInteger) {
        return bigInteger.compareTo(BigInteger.ONE) <= 0;
    }

    public static boolean isGT1(@NonNull BigInteger bigInteger) {
        return bigInteger.compareTo(BigInteger.ONE) > 0;
    }

    public static boolean isGE1(@NonNull BigInteger bigInteger) {
        return bigInteger.compareTo(BigInteger.ONE) >= 0;
    }

    public static boolean isEQ10(@NonNull BigInteger bigInteger) {
        return bigInteger.equals(BigInteger.TEN);
    }

    public static boolean isNE10(@NonNull BigInteger bigInteger) {
        return !bigInteger.equals(BigInteger.TEN);
    }

    public static boolean isLT10(@NonNull BigInteger bigInteger) {
        return bigInteger.compareTo(BigInteger.TEN) < 0;
    }

    public static boolean isLE10(@NonNull BigInteger bigInteger) {
        return bigInteger.compareTo(BigInteger.TEN) <= 0;
    }

    public static boolean isGT10(@NonNull BigInteger bigInteger) {
        return bigInteger.compareTo(BigInteger.TEN) > 0;
    }

    public static boolean isGE10(@NonNull BigInteger bigInteger) {
        return bigInteger.compareTo(BigInteger.TEN) >= 0;
    }

    public static boolean isEQ100(@NonNull BigInteger bigInteger) {
        return bigInteger.equals(CGlobal.BIGINT_100);
    }

    public static boolean isNE100(@NonNull BigInteger bigInteger) {
        return !bigInteger.equals(CGlobal.BIGINT_100);
    }

    public static boolean isLT100(@NonNull BigInteger bigInteger) {
        return bigInteger.compareTo(CGlobal.BIGINT_100) < 0;
    }

    public static boolean isLE100(@NonNull BigInteger bigInteger) {
        return bigInteger.compareTo(CGlobal.BIGINT_100) <= 0;
    }

    public static boolean isGT100(@NonNull BigInteger bigInteger) {
        return bigInteger.compareTo(CGlobal.BIGINT_100) > 0;
    }

    public static boolean isGE100(@NonNull BigInteger bigInteger) {
        return bigInteger.compareTo(CGlobal.BIGINT_100) >= 0;
    }

    @CheckReturnValue
    public static @Nullable BigDecimal getWithoutTrailingZeroes(@Nullable String string) {
        if (string == null) {
            return null;
        }
        return BigHelper.getWithoutTrailingZeroes(new BigDecimal(string));
    }

    @CheckReturnValue
    public static @Nullable BigDecimal getWithoutTrailingZeroes(@Nullable BigDecimal bigDecimal) {
        if (bigDecimal == null) {
            return null;
        }
        if (BigDecimal.ZERO.compareTo(bigDecimal) == 0) {
            return BigDecimal.ZERO;
        }
        BigDecimal bigDecimal2 = bigDecimal.stripTrailingZeros();
        return bigDecimal2.scale() >= 0 ? bigDecimal2 : bigDecimal2.setScale(0);
    }

    @Nonnegative
    public static int getFractionDigits(@NonNull BigDecimal bigDecimal) {
        return BigHelper.getWithoutTrailingZeroes(bigDecimal).scale();
    }

    public static @NonNull BigDecimal addPercent(@NonNull BigDecimal bigDecimal, @NonNull BigDecimal bigDecimal2) {
        return bigDecimal.multiply(CGlobal.BIGDEC_100.add(bigDecimal2)).divide(CGlobal.BIGDEC_100);
    }

    public static @NonNull BigDecimal addPercent(@NonNull BigDecimal bigDecimal, @NonNull BigDecimal bigDecimal2, @Nonnegative int n, @NonNull RoundingMode roundingMode) {
        return bigDecimal.multiply(CGlobal.BIGDEC_100.add(bigDecimal2)).divide(CGlobal.BIGDEC_100, n, roundingMode);
    }

    public static @NonNull BigDecimal subtractPercent(@NonNull BigDecimal bigDecimal, @NonNull BigDecimal bigDecimal2) {
        return bigDecimal.multiply(CGlobal.BIGDEC_100.subtract(bigDecimal2)).divide(CGlobal.BIGDEC_100);
    }

    public static @NonNull BigDecimal subtractPercent(@NonNull BigDecimal bigDecimal, @NonNull BigDecimal bigDecimal2, @Nonnegative int n, @NonNull RoundingMode roundingMode) {
        return bigDecimal.multiply(CGlobal.BIGDEC_100.subtract(bigDecimal2)).divide(CGlobal.BIGDEC_100, n, roundingMode);
    }

    public static @NonNull BigDecimal getPercentValue(@NonNull BigDecimal bigDecimal, @NonNull BigDecimal bigDecimal2) {
        return bigDecimal.multiply(bigDecimal2).divide(CGlobal.BIGDEC_100);
    }

    public static @NonNull BigDecimal getPercentValue(@NonNull BigDecimal bigDecimal, @NonNull BigDecimal bigDecimal2, @Nonnegative int n, @NonNull RoundingMode roundingMode) {
        return bigDecimal.multiply(bigDecimal2).divide(CGlobal.BIGDEC_100, n, roundingMode);
    }

    public static @NonNull BigDecimal toBigDecimal(int n) {
        return BigDecimal.valueOf(n);
    }

    public static @NonNull BigDecimal toBigDecimal(long l) {
        return BigDecimal.valueOf(l);
    }

    public static @NonNull BigDecimal toBigDecimal(float f) {
        return BigDecimal.valueOf(f);
    }

    public static @NonNull BigDecimal toBigDecimal(double d) {
        return BigDecimal.valueOf(d);
    }

    public static @NonNull BigDecimal toBigDecimal(@NonNull Number number) {
        ValueEnforcer.notNull(number, "Number");
        return new BigDecimal(number.toString());
    }

    public static @NonNull BigDecimal toBigDecimal(@NonNull String string) {
        ValueEnforcer.notNull(string, "Number");
        return new BigDecimal(string);
    }

    public static @NonNull BigInteger toBigInteger(int n) {
        return BigInteger.valueOf(n);
    }

    public static @NonNull BigInteger toBigInteger(long l) {
        return BigInteger.valueOf(l);
    }

    public static @NonNull BigInteger toBigInteger(@NonNull Number number) {
        ValueEnforcer.notNull(number, "Number");
        return new BigInteger(number.toString(), 10);
    }

    public static @NonNull BigInteger toBigInteger(@NonNull String string) {
        ValueEnforcer.notNull(string, "Number");
        return new BigInteger(string, 10);
    }
}

