/*
 * Decompiled with CFR 0.152.
 */
package com.helger.base.concurrent;

import com.helger.base.functional.IThrowingSupplier;
import com.helger.base.iface.IThrowingRunnable;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.BooleanSupplier;
import java.util.function.DoubleSupplier;
import java.util.function.IntSupplier;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import org.jspecify.annotations.NonNull;

public class SimpleReadWriteLock
extends ReentrantReadWriteLock {
    public SimpleReadWriteLock() {
    }

    public SimpleReadWriteLock(boolean bl) {
        super(bl);
    }

    public <T> T readLockedGet(@NonNull Supplier<? extends T> supplier) {
        this.readLock().lock();
        try {
            T t = supplier.get();
            return t;
        }
        finally {
            this.readLock().unlock();
        }
    }

    public void readLocked(@NonNull Runnable runnable) {
        this.readLock().lock();
        try {
            runnable.run();
        }
        finally {
            this.readLock().unlock();
        }
    }

    public <EXTYPE extends Exception> void readLockedThrowing(@NonNull IThrowingRunnable<EXTYPE> iThrowingRunnable) throws EXTYPE {
        this.readLock().lock();
        try {
            iThrowingRunnable.run();
        }
        finally {
            this.readLock().unlock();
        }
    }

    public <T, EXTYPE extends Exception> T readLockedGetThrowing(@NonNull IThrowingSupplier<? extends T, EXTYPE> iThrowingSupplier) throws EXTYPE {
        this.readLock().lock();
        try {
            T t = iThrowingSupplier.get();
            return t;
        }
        finally {
            this.readLock().unlock();
        }
    }

    public boolean readLockedBoolean(@NonNull BooleanSupplier booleanSupplier) {
        this.readLock().lock();
        try {
            boolean bl = booleanSupplier.getAsBoolean();
            return bl;
        }
        finally {
            this.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double readLockedDouble(@NonNull DoubleSupplier doubleSupplier) {
        this.readLock().lock();
        try {
            double d = doubleSupplier.getAsDouble();
            return d;
        }
        finally {
            this.readLock().unlock();
        }
    }

    public int readLockedInt(@NonNull IntSupplier intSupplier) {
        this.readLock().lock();
        try {
            int n = intSupplier.getAsInt();
            return n;
        }
        finally {
            this.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long readLockedLong(@NonNull LongSupplier longSupplier) {
        this.readLock().lock();
        try {
            long l = longSupplier.getAsLong();
            return l;
        }
        finally {
            this.readLock().unlock();
        }
    }

    public void writeLocked(@NonNull Runnable runnable) {
        this.writeLock().lock();
        try {
            runnable.run();
        }
        finally {
            this.writeLock().unlock();
        }
    }

    public <EXTYPE extends Exception> void writeLockedThrowing(@NonNull IThrowingRunnable<EXTYPE> iThrowingRunnable) throws EXTYPE {
        this.writeLock().lock();
        try {
            iThrowingRunnable.run();
        }
        finally {
            this.writeLock().unlock();
        }
    }

    public <T> T writeLockedGet(@NonNull Supplier<? extends T> supplier) {
        this.writeLock().lock();
        try {
            T t = supplier.get();
            return t;
        }
        finally {
            this.writeLock().unlock();
        }
    }

    public <T, EXTYPE extends Exception> T writeLockedGetThrowing(@NonNull IThrowingSupplier<? extends T, EXTYPE> iThrowingSupplier) throws EXTYPE {
        this.writeLock().lock();
        try {
            T t = iThrowingSupplier.get();
            return t;
        }
        finally {
            this.writeLock().unlock();
        }
    }

    public boolean writeLockedBoolean(@NonNull BooleanSupplier booleanSupplier) {
        this.writeLock().lock();
        try {
            boolean bl = booleanSupplier.getAsBoolean();
            return bl;
        }
        finally {
            this.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double writeLockedDouble(@NonNull DoubleSupplier doubleSupplier) {
        this.writeLock().lock();
        try {
            double d = doubleSupplier.getAsDouble();
            return d;
        }
        finally {
            this.writeLock().unlock();
        }
    }

    public int writeLockedInt(@NonNull IntSupplier intSupplier) {
        this.writeLock().lock();
        try {
            int n = intSupplier.getAsInt();
            return n;
        }
        finally {
            this.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long writeLockedLong(@NonNull LongSupplier longSupplier) {
        this.writeLock().lock();
        try {
            long l = longSupplier.getAsLong();
            return l;
        }
        finally {
            this.writeLock().unlock();
        }
    }
}

