/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.ControlFlowAnalysis;
import com.google.javascript.jscomp.ControlFlowGraph;
import com.google.javascript.jscomp.FunctionNames;
import com.google.javascript.jscomp.Instrumentation;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.JSModule;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.RhinoErrorReporter;
import com.google.javascript.jscomp.graph.DiGraph;
import com.google.javascript.rhino.Node;
import com.google.protobuf.Message;
import com.google.protobuf.TextFormat;
import java.io.IOException;
import java.util.List;

class InstrumentFunctions
implements CompilerPass {
    private final AbstractCompiler compiler;
    private final FunctionNames functionNames;
    private final String templateFilename;
    private final String appNameStr;
    private final String initCodeSource;
    private final String definedFunctionName;
    private final String reportFunctionName;
    private final String reportFunctionExitName;
    private final String appNameSetter;
    private final List<String> declarationsToRemove;

    InstrumentFunctions(AbstractCompiler abstractCompiler, FunctionNames functionNames, String string, String string2, Readable readable) {
        this.compiler = abstractCompiler;
        this.functionNames = functionNames;
        this.templateFilename = string;
        this.appNameStr = string2;
        Instrumentation.Builder builder = Instrumentation.newBuilder();
        try {
            TextFormat.merge((Readable)readable, (Message.Builder)builder);
        }
        catch (IOException iOException) {
            abstractCompiler.report(JSError.make(RhinoErrorReporter.PARSE_ERROR, "Error reading instrumentation template protobuf at " + string));
            this.initCodeSource = "";
            this.definedFunctionName = "";
            this.reportFunctionName = "";
            this.reportFunctionExitName = "";
            this.appNameSetter = "";
            this.declarationsToRemove = Lists.newArrayList();
            return;
        }
        Instrumentation instrumentation = builder.build();
        StringBuilder stringBuilder = new StringBuilder();
        for (String string3 : instrumentation.getInitList()) {
            stringBuilder.append(string3).append("\n");
        }
        this.initCodeSource = stringBuilder.toString();
        this.definedFunctionName = instrumentation.getReportDefined();
        this.reportFunctionName = instrumentation.getReportCall();
        this.reportFunctionExitName = instrumentation.getReportExit();
        this.appNameSetter = instrumentation.getAppNameSetter();
        this.declarationsToRemove = ImmutableList.copyOf(instrumentation.getDeclarationToRemoveList());
    }

    @Override
    public void process(Node node, Node node2) {
        Node node3;
        Node node4 = null;
        if (!this.initCodeSource.isEmpty()) {
            node3 = this.compiler.parseSyntheticCode(this.templateFilename + ":init", this.initCodeSource);
            if (node3 != null && node3.getFirstChild() != null) {
                node4 = node3.removeChildren();
            } else {
                return;
            }
        }
        NodeTraversal.traverse(this.compiler, node2, new RemoveCallback(this.declarationsToRemove));
        NodeTraversal.traverse(this.compiler, node2, new InstrumentCallback());
        if (!this.appNameSetter.isEmpty()) {
            node3 = new Node(37, Node.newString(38, this.appNameSetter), Node.newString(this.appNameStr));
            Node node5 = new Node(130, node3);
            Node node6 = this.compiler.getNodeForCodeInsertion(null);
            node6.addChildrenToFront(node5);
            this.compiler.reportCodeChange();
        }
        if (node4 != null) {
            node3 = this.compiler.getNodeForCodeInsertion(null);
            node3.addChildrenToFront(node4);
            this.compiler.reportCodeChange();
        }
    }

    private class InstrumentCallback
    extends NodeTraversal.AbstractPostOrderCallback {
        private InstrumentCallback() {
        }

        @Override
        public void visit(NodeTraversal nodeTraversal, Node node, Node node2) {
            Node node3;
            Node node4;
            Node node5;
            if (node.getType() != 105) {
                return;
            }
            int n = InstrumentFunctions.this.functionNames.getFunctionId(node);
            if (n < 0) {
                return;
            }
            if (!InstrumentFunctions.this.reportFunctionName.isEmpty()) {
                node5 = node.getFirstChild().getNext().getNext();
                node4 = new Node(37, Node.newString(38, InstrumentFunctions.this.reportFunctionName), Node.newNumber(n));
                node3 = new Node(130, node4);
                node5.addChildToFront(node3);
                InstrumentFunctions.this.compiler.reportCodeChange();
            }
            if (!InstrumentFunctions.this.reportFunctionExitName.isEmpty()) {
                node5 = node.getFirstChild().getNext().getNext();
                new InstrumentReturns(n).process(node5);
            }
            if (!InstrumentFunctions.this.definedFunctionName.isEmpty()) {
                node5 = new Node(37, Node.newString(38, InstrumentFunctions.this.definedFunctionName), Node.newNumber(n));
                node4 = NodeUtil.newExpr(node5);
                node3 = null;
                if (NodeUtil.isFunctionDeclaration(node)) {
                    JSModule jSModule = nodeTraversal.getModule();
                    node3 = InstrumentFunctions.this.compiler.getNodeForCodeInsertion(jSModule);
                    node3.addChildToFront(node4);
                } else {
                    Node node6 = node;
                    for (Node node7 : node.getAncestors()) {
                        int n2 = node7.getType();
                        if (n2 == 125 || n2 == 132) {
                            node3 = node7;
                            break;
                        }
                        node6 = node7;
                    }
                    node3.addChildBefore(node4, node6);
                }
                InstrumentFunctions.this.compiler.reportCodeChange();
            }
        }
    }

    private class InstrumentReturns
    implements NodeTraversal.Callback {
        private final int functionId;

        InstrumentReturns(int n) {
            this.functionId = n;
        }

        void process(Node node) {
            NodeTraversal.traverse(InstrumentFunctions.this.compiler, node, this);
            if (!this.allPathsReturn(node)) {
                Node node2 = this.newReportFunctionExitNode();
                Node node3 = new Node(130, node2);
                node.addChildToBack(node3);
                InstrumentFunctions.this.compiler.reportCodeChange();
            }
        }

        @Override
        public boolean shouldTraverse(NodeTraversal nodeTraversal, Node node, Node node2) {
            return node.getType() != 105;
        }

        @Override
        public void visit(NodeTraversal nodeTraversal, Node node, Node node2) {
            if (node.getType() != 4) {
                return;
            }
            Node node3 = this.newReportFunctionExitNode();
            Node node4 = node.removeFirstChild();
            if (node4 != null) {
                node3.addChildToBack(node4);
            }
            node.addChildToFront(node3);
            InstrumentFunctions.this.compiler.reportCodeChange();
        }

        private Node newReportFunctionExitNode() {
            return new Node(37, Node.newString(38, InstrumentFunctions.this.reportFunctionExitName), Node.newNumber(this.functionId));
        }

        private boolean allPathsReturn(Node node) {
            ControlFlowAnalysis controlFlowAnalysis = new ControlFlowAnalysis(InstrumentFunctions.this.compiler, false, false);
            controlFlowAnalysis.process(null, node);
            ControlFlowGraph<Node> controlFlowGraph = controlFlowAnalysis.getCfg();
            Node node2 = (Node)controlFlowGraph.getImplicitReturn().getValue();
            for (DiGraph.DiGraphNode diGraphNode : controlFlowGraph.getDirectedPredNodes(node2)) {
                Node node3 = (Node)diGraphNode.getValue();
                if (node3.getType() == 4) continue;
                return false;
            }
            return true;
        }
    }

    private static class RemoveCallback
    extends NodeTraversal.AbstractPostOrderCallback {
        private final List<String> removable;

        RemoveCallback(List<String> list) {
            this.removable = list;
        }

        @Override
        public void visit(NodeTraversal nodeTraversal, Node node, Node node2) {
            if (NodeUtil.isVarDeclaration(node) && this.removable.contains(node.getString())) {
                node2.removeChild(node);
                if (!node2.hasChildren()) {
                    node2.getParent().removeChild(node2);
                }
            }
        }
    }
}

