/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino.jstype;

import com.google.javascript.rhino.jstype.BooleanLiteralSet;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.TernaryValue;
import com.google.javascript.rhino.jstype.ValueType;
import com.google.javascript.rhino.jstype.Visitor;

public class VoidType
extends ValueType {
    private static final long serialVersionUID = 1L;

    VoidType(JSTypeRegistry jSTypeRegistry) {
        super(jSTypeRegistry);
    }

    @Override
    public JSType restrictByNotNullOrUndefined() {
        return this.registry.getNativeType(JSTypeNative.NO_TYPE);
    }

    @Override
    public TernaryValue testForEquality(JSType jSType) {
        if (TernaryValue.UNKNOWN.equals((Object)super.testForEquality(jSType))) {
            return TernaryValue.UNKNOWN;
        }
        if (jSType.isSubtype(this) || jSType.isSubtype(this.getNativeType(JSTypeNative.NULL_TYPE))) {
            return TernaryValue.TRUE;
        }
        return TernaryValue.FALSE;
    }

    @Override
    public boolean matchesNumberContext() {
        return false;
    }

    @Override
    public boolean matchesObjectContext() {
        return false;
    }

    @Override
    public boolean matchesStringContext() {
        return true;
    }

    @Override
    public boolean isVoidType() {
        return true;
    }

    public String toString() {
        return "undefined";
    }

    @Override
    public BooleanLiteralSet getPossibleToBooleanOutcomes() {
        return BooleanLiteralSet.FALSE;
    }

    @Override
    public <T> T visit(Visitor<T> visitor) {
        return visitor.caseVoidType();
    }
}

