/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino.jstype;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.jstype.BooleanLiteralSet;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.TernaryValue;
import com.google.javascript.rhino.jstype.Visitor;
import java.util.Set;
import java.util.TreeSet;

public abstract class ObjectType
extends JSType {
    private boolean visited;
    private JSDocInfo docInfo = null;
    private boolean unknown = true;

    ObjectType(JSTypeRegistry jSTypeRegistry) {
        super(jSTypeRegistry);
    }

    public JSType getParameterType() {
        return null;
    }

    public JSType getIndexType() {
        return null;
    }

    @Override
    public JSDocInfo getJSDocInfo() {
        if (this.docInfo != null) {
            return this.docInfo;
        }
        if (this.getImplicitPrototype() != null) {
            return this.getImplicitPrototype().getJSDocInfo();
        }
        return super.getJSDocInfo();
    }

    public void setJSDocInfo(JSDocInfo jSDocInfo) {
        this.docInfo = jSDocInfo;
    }

    final boolean detectImplicitPrototypeCycle() {
        ObjectType objectType;
        this.visited = true;
        for (objectType = this.getImplicitPrototype(); objectType != null; objectType = objectType.getImplicitPrototype()) {
            if (objectType.visited) {
                return true;
            }
            objectType.visited = true;
        }
        objectType = this;
        do {
            objectType.visited = false;
        } while ((objectType = objectType.getImplicitPrototype()) != null);
        return false;
    }

    public abstract String getReferenceName();

    public String getNormalizedReferenceName() {
        int n;
        String string = this.getReferenceName();
        if (string != null && (n = string.indexOf("(")) != -1) {
            return string.substring(0, n);
        }
        return string;
    }

    public static String createDelegateSuffix(String string) {
        return "(" + string + ")";
    }

    public boolean hasReferenceName() {
        return false;
    }

    @Override
    public TernaryValue testForEquality(JSType jSType) {
        TernaryValue ternaryValue = super.testForEquality(jSType);
        if (ternaryValue != null) {
            return ternaryValue;
        }
        if (jSType.isSubtype(this.getNativeType(JSTypeNative.OBJECT_NUMBER_STRING_BOOLEAN))) {
            return TernaryValue.UNKNOWN;
        }
        return TernaryValue.FALSE;
    }

    public abstract FunctionType getConstructor();

    public abstract ObjectType getImplicitPrototype();

    public final boolean defineDeclaredProperty(String string, JSType jSType, boolean bl) {
        this.registry.registerPropertyOnType(string, this);
        return this.defineProperty(string, jSType, false, bl);
    }

    public final boolean defineInferredProperty(String string, JSType jSType, boolean bl) {
        this.registry.registerPropertyOnType(string, this);
        if (this.hasProperty(string)) {
            JSType jSType2 = this.getPropertyType(string);
            jSType = jSType2 == null ? jSType : jSType2.getLeastSupertype(jSType);
        }
        return this.defineProperty(string, jSType, true, bl);
    }

    abstract boolean defineProperty(String var1, JSType var2, boolean var3, boolean var4);

    public JSDocInfo getOwnPropertyJSDocInfo(String string) {
        return null;
    }

    public void setPropertyJSDocInfo(String string, JSDocInfo jSDocInfo, boolean bl) {
    }

    @Override
    public JSType findPropertyType(String string) {
        return this.hasProperty(string) ? this.getPropertyType(string) : null;
    }

    public abstract JSType getPropertyType(String var1);

    public abstract boolean hasProperty(String var1);

    public boolean hasOwnProperty(String string) {
        return this.hasProperty(string);
    }

    public Set<String> getOwnPropertyNames() {
        return ImmutableSet.of();
    }

    public abstract boolean isPropertyTypeInferred(String var1);

    public abstract boolean isPropertyTypeDeclared(String var1);

    boolean hasOwnDeclaredProperty(String string) {
        return this.hasOwnProperty(string) && this.isPropertyTypeDeclared(string);
    }

    public boolean isPropertyInExterns(String string) {
        return false;
    }

    public abstract int getPropertiesCount();

    public Set<String> getPropertyNames() {
        TreeSet treeSet = Sets.newTreeSet();
        this.collectPropertyNames(treeSet);
        return treeSet;
    }

    abstract void collectPropertyNames(Set<String> var1);

    @Override
    public <T> T visit(Visitor<T> visitor) {
        return visitor.caseObjectType(this);
    }

    final boolean isImplicitPrototype(ObjectType objectType) {
        for (ObjectType objectType2 = this; objectType2 != null; objectType2 = objectType2.getImplicitPrototype()) {
            if (!objectType2.isEquivalentTo(objectType)) continue;
            return true;
        }
        return false;
    }

    @Override
    public BooleanLiteralSet getPossibleToBooleanOutcomes() {
        return BooleanLiteralSet.TRUE;
    }

    @Override
    public boolean isUnknownType() {
        if (this.unknown) {
            ObjectType objectType = this.getImplicitPrototype();
            this.unknown = objectType == null || objectType.isNativeObjectType() ? false : objectType.isUnknownType();
        }
        return this.unknown;
    }

    @Override
    public boolean isObject() {
        return true;
    }

    public boolean hasCachedValues() {
        return !this.unknown;
    }

    public boolean isNativeObjectType() {
        return false;
    }

    public static ObjectType cast(JSType jSType) {
        return jSType == null ? null : jSType.toObjectType();
    }

    public Iterable<ObjectType> getCtorImplementedInterfaces() {
        return ImmutableSet.of();
    }
}

