/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino;

import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Kit;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.ObjToIntMap;
import com.google.javascript.rhino.Parser;
import com.google.javascript.rhino.ScriptRuntime;
import com.google.javascript.rhino.Token;
import java.io.IOException;
import java.io.Reader;

public class TokenStream {
    private static final int EOF_CHAR = -1;
    private boolean dirtyLine;
    String regExpFlags;
    private int pushbackToken;
    private int tokenno;
    private String string = "";
    private double number;
    private char[] stringBuffer = new char[128];
    private int stringBufferTop;
    private ObjToIntMap allStrings = new ObjToIntMap(50);
    private final int[] ungetBuffer = new int[3];
    private int ungetCursor;
    private boolean hitEOF = false;
    private int lineStart = 0;
    private int lineno;
    private int charno = -1;
    private int lineEndChar = -1;
    private String sourceString;
    private Reader sourceReader;
    private char[] sourceBuffer;
    private int sourceEnd;
    private int sourceCursor;
    private boolean xmlIsAttribute;
    private boolean xmlIsTagContent;
    private int xmlOpenTagsCount;
    private Parser parser;

    public TokenStream(Parser parser, Reader reader, String string, int n) {
        this.parser = parser;
        this.lineno = n;
        if (reader != null) {
            if (string != null) {
                Kit.codeBug();
            }
            this.sourceReader = reader;
            this.sourceBuffer = new char[512];
            this.sourceEnd = 0;
        } else {
            if (string == null) {
                Kit.codeBug();
            }
            this.sourceString = string;
            this.sourceEnd = string.length();
        }
        this.sourceCursor = 0;
    }

    String tokenToString(int n) {
        String string = Token.name(n);
        switch (n) {
            case 38: 
            case 40: 
            case 47: {
                return string + " `" + this.string + "'";
            }
            case 39: {
                return "NUMBER " + this.number;
            }
        }
        return string;
    }

    public static boolean isKeyword(String string) {
        return 0 != TokenStream.stringToKeyword(string);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static int stringToKeyword(String string) {
        String string2 = string;
        int n = 0;
        String string3 = null;
        block0 : switch (string2.length()) {
            case 2: {
                char c = string2.charAt(1);
                if (c == 'f') {
                    if (string2.charAt(0) != 'i') break;
                    return 108;
                }
                if (c == 'n') {
                    if (string2.charAt(0) != 'i') break;
                    return 51;
                }
                if (c != 'o' || string2.charAt(0) != 'd') break;
                return 114;
            }
            case 3: {
                switch (string2.charAt(0)) {
                    case 'f': {
                        if (string2.charAt(2) != 'r' || string2.charAt(1) != 'o') break;
                        return 115;
                    }
                    case 'i': {
                        if (string2.charAt(2) != 't' || string2.charAt(1) != 'n') break;
                        return 123;
                    }
                    case 'n': {
                        if (string2.charAt(2) != 'w' || string2.charAt(1) != 'e') break;
                        return 30;
                    }
                    case 't': {
                        if (string2.charAt(2) != 'y' || string2.charAt(1) != 'r') break;
                        return 77;
                    }
                    case 'v': {
                        if (string2.charAt(2) != 'r' || string2.charAt(1) != 'a') break;
                        return 118;
                    }
                }
                break;
            }
            case 4: {
                switch (string2.charAt(0)) {
                    case 'b': {
                        string3 = "byte";
                        n = 123;
                        break;
                    }
                    case 'c': {
                        char c = string2.charAt(3);
                        if (c == 'e') {
                            if (string2.charAt(2) != 's' || string2.charAt(1) != 'a') break;
                            return 111;
                        }
                        if (c != 'r' || string2.charAt(2) != 'a' || string2.charAt(1) != 'h') break;
                        return 123;
                    }
                    case 'e': {
                        char c = string2.charAt(3);
                        if (c == 'e') {
                            if (string2.charAt(2) != 's' || string2.charAt(1) != 'l') break;
                            return 109;
                        }
                        if (c != 'm' || string2.charAt(2) != 'u' || string2.charAt(1) != 'n') break;
                        return 123;
                    }
                    case 'g': {
                        string3 = "goto";
                        n = 123;
                        break;
                    }
                    case 'l': {
                        string3 = "long";
                        n = 123;
                        break;
                    }
                    case 'n': {
                        string3 = "null";
                        n = 41;
                        break;
                    }
                    case 't': {
                        char c = string2.charAt(3);
                        if (c == 'e') {
                            if (string2.charAt(2) != 'u' || string2.charAt(1) != 'r') break;
                            return 44;
                        }
                        if (c != 's' || string2.charAt(2) != 'i' || string2.charAt(1) != 'h') break;
                        return 42;
                    }
                    case 'v': {
                        string3 = "void";
                        n = 122;
                        break;
                    }
                    case 'w': {
                        string3 = "with";
                        n = 119;
                        break;
                    }
                }
                break;
            }
            case 5: {
                switch (string2.charAt(2)) {
                    case 'a': {
                        string3 = "class";
                        n = 123;
                        break;
                    }
                    case 'e': {
                        string3 = "break";
                        n = 116;
                        break;
                    }
                    case 'i': {
                        string3 = "while";
                        n = 113;
                        break;
                    }
                    case 'l': {
                        string3 = "false";
                        n = 43;
                        break;
                    }
                    case 'n': {
                        char c = string2.charAt(0);
                        if (c == 'c') {
                            string3 = "const";
                            n = 149;
                            break;
                        }
                        if (c != 'f') break;
                        string3 = "final";
                        n = 123;
                        break;
                    }
                    case 'o': {
                        char c = string2.charAt(0);
                        if (c == 'f') {
                            string3 = "float";
                            n = 123;
                            break;
                        }
                        if (c != 's') break;
                        string3 = "short";
                        n = 123;
                        break;
                    }
                    case 'p': {
                        string3 = "super";
                        n = 123;
                        break;
                    }
                    case 'r': {
                        string3 = "throw";
                        n = 49;
                        break;
                    }
                    case 't': {
                        string3 = "catch";
                        n = 120;
                        break;
                    }
                }
                break;
            }
            case 6: {
                switch (string2.charAt(1)) {
                    case 'a': {
                        string3 = "native";
                        n = 123;
                        break;
                    }
                    case 'e': {
                        char c = string2.charAt(0);
                        if (c == 'd') {
                            string3 = "delete";
                            n = 31;
                            break;
                        }
                        if (c != 'r') break;
                        string3 = "return";
                        n = 4;
                        break;
                    }
                    case 'h': {
                        string3 = "throws";
                        n = 123;
                        break;
                    }
                    case 'm': {
                        string3 = "import";
                        n = 107;
                        break;
                    }
                    case 'o': {
                        string3 = "double";
                        n = 123;
                        break;
                    }
                    case 't': {
                        string3 = "static";
                        n = 123;
                        break;
                    }
                    case 'u': {
                        string3 = "public";
                        n = 123;
                        break;
                    }
                    case 'w': {
                        string3 = "switch";
                        n = 110;
                        break;
                    }
                    case 'x': {
                        string3 = "export";
                        n = 106;
                        break;
                    }
                    case 'y': {
                        string3 = "typeof";
                        n = 32;
                        break;
                    }
                }
                break;
            }
            case 7: {
                switch (string2.charAt(1)) {
                    case 'a': {
                        string3 = "package";
                        n = 123;
                        break block0;
                    }
                    case 'e': {
                        string3 = "default";
                        n = 112;
                        break block0;
                    }
                    case 'i': {
                        string3 = "finally";
                        n = 121;
                        break block0;
                    }
                    case 'o': {
                        string3 = "boolean";
                        n = 123;
                        break block0;
                    }
                    case 'r': {
                        string3 = "private";
                        n = 123;
                        break block0;
                    }
                    case 'x': {
                        string3 = "extends";
                        n = 123;
                        break block0;
                    }
                }
                break;
            }
            case 8: {
                switch (string2.charAt(0)) {
                    case 'a': {
                        string3 = "abstract";
                        n = 123;
                        break block0;
                    }
                    case 'c': {
                        string3 = "continue";
                        n = 117;
                        break block0;
                    }
                    case 'd': {
                        string3 = "debugger";
                        n = 152;
                        break block0;
                    }
                    case 'f': {
                        string3 = "function";
                        n = 105;
                        break block0;
                    }
                    case 'v': {
                        string3 = "volatile";
                        n = 123;
                        break block0;
                    }
                }
                break;
            }
            case 9: {
                char c = string2.charAt(0);
                if (c == 'i') {
                    string3 = "interface";
                    n = 123;
                    break;
                }
                if (c == 'p') {
                    string3 = "protected";
                    n = 123;
                    break;
                }
                if (c != 't') break;
                string3 = "transient";
                n = 123;
                break;
            }
            case 10: {
                char c = string2.charAt(1);
                if (c == 'm') {
                    string3 = "implements";
                    n = 123;
                    break;
                }
                if (c != 'n') break;
                string3 = "instanceof";
                n = 52;
                break;
            }
            case 12: {
                string3 = "synchronized";
                n = 123;
            }
        }
        if (string3 != null && string3 != string2 && !string3.equals(string2)) {
            return 0;
        }
        if (n != 0) return n & 0xFF;
        return 0;
    }

    public static boolean isJSIdentifier(String string) {
        int n = string.length();
        if (n == 0 || !Character.isJavaIdentifierStart(string.charAt(0))) {
            return false;
        }
        for (int i = 1; i < n; ++i) {
            char c = string.charAt(i);
            if (Character.isJavaIdentifierPart(c)) continue;
            return c == '\\' && i + 5 >= n && string.charAt(i + 1) == 'u' && 0 <= Kit.xDigitToInt(string.charAt(i + 2), 0) && 0 <= Kit.xDigitToInt(string.charAt(i + 3), 0) && 0 <= Kit.xDigitToInt(string.charAt(i + 4), 0) && 0 <= Kit.xDigitToInt(string.charAt(i + 5), 0);
        }
        return true;
    }

    protected final int getLineno() {
        return this.lineno;
    }

    protected final int getCharno() {
        return this.charno;
    }

    final String getString() {
        return this.string;
    }

    final double getNumber() {
        return this.number;
    }

    final boolean eof() {
        return this.hitEOF;
    }

    public final int getToken() throws IOException {
        ++this.tokenno;
        if (this.pushbackToken != 0) {
            int n = this.pushbackToken;
            this.pushbackToken = 0;
            return n;
        }
        block39: while (true) {
            boolean bl;
            this.charno = -1;
            int n = this.getChar();
            if (n == -1) {
                return 0;
            }
            if (n == 10) {
                this.dirtyLine = false;
                return 1;
            }
            if (TokenStream.isJSSpace(n)) continue;
            if (n != 45) {
                this.dirtyLine = true;
            }
            if (n == 64) {
                return 143;
            }
            boolean bl2 = false;
            if (n == 92) {
                n = this.getChar();
                if (n == 117) {
                    bl = true;
                    bl2 = true;
                    this.stringBufferTop = 0;
                } else {
                    bl = false;
                    this.ungetChar(n);
                    n = 92;
                }
            } else {
                bl = Character.isJavaIdentifierStart((char)n);
                if (bl) {
                    this.stringBufferTop = 0;
                    this.addToString(n);
                }
            }
            if (bl) {
                int n2;
                boolean bl3 = bl2;
                while (true) {
                    if (bl2) {
                        int n3 = 0;
                        for (n2 = 0; n2 != 4 && (n3 = Kit.xDigitToInt(n = this.getChar(), n3)) >= 0; ++n2) {
                        }
                        if (n3 < 0) {
                            this.parser.addError("msg.invalid.escape");
                            return -1;
                        }
                        this.addToString(n3);
                        bl2 = false;
                        continue;
                    }
                    n = this.getChar();
                    if (n == 92) {
                        n = this.getChar();
                        if (n == 117) {
                            bl2 = true;
                            bl3 = true;
                            continue;
                        }
                        this.parser.addError("msg.illegal.character");
                        return -1;
                    }
                    if (n == -1 || !Character.isJavaIdentifierPart((char)n)) break;
                    this.addToString(n);
                }
                this.ungetChar(n);
                String string = this.getStringFromBuffer();
                if (!bl3 && (n2 = TokenStream.stringToKeyword(string)) != 0) {
                    if (n2 != 123) {
                        return n2;
                    }
                    if (!this.parser.compilerEnv.isReservedKeywordAsIdentifier()) {
                        return n2;
                    }
                    this.parser.addWarning("msg.reserved.keyword", string);
                }
                this.string = (String)this.allStrings.intern(string);
                return 38;
            }
            if (TokenStream.isDigit(n) || n == 46 && TokenStream.isDigit(this.peekChar())) {
                double d;
                this.stringBufferTop = 0;
                int n4 = 10;
                if (n == 48) {
                    n = this.getChar();
                    if (n == 120 || n == 88) {
                        n4 = 16;
                        n = this.getChar();
                    } else if (TokenStream.isDigit(n)) {
                        n4 = 8;
                    } else {
                        this.addToString(48);
                    }
                }
                if (n4 == 16) {
                    while (0 <= Kit.xDigitToInt(n, 0)) {
                        this.addToString(n);
                        n = this.getChar();
                    }
                } else {
                    while (48 <= n && n <= 57) {
                        if (n4 == 8 && n >= 56) {
                            this.parser.addWarning("msg.bad.octal.literal", n == 56 ? "8" : "9");
                            n4 = 10;
                        }
                        this.addToString(n);
                        n = this.getChar();
                    }
                }
                boolean bl4 = true;
                if (n4 == 10 && (n == 46 || n == 101 || n == 69)) {
                    bl4 = false;
                    if (n == 46) {
                        do {
                            this.addToString(n);
                        } while (TokenStream.isDigit(n = this.getChar()));
                    }
                    if (n == 101 || n == 69) {
                        this.addToString(n);
                        n = this.getChar();
                        if (n == 43 || n == 45) {
                            this.addToString(n);
                            n = this.getChar();
                        }
                        if (!TokenStream.isDigit(n)) {
                            this.parser.addError("msg.missing.exponent");
                            return -1;
                        }
                        do {
                            this.addToString(n);
                        } while (TokenStream.isDigit(n = this.getChar()));
                    }
                }
                this.ungetChar(n);
                String string = this.getStringFromBuffer();
                if (n4 == 10 && !bl4) {
                    try {
                        d = Double.valueOf(string);
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.parser.addError("msg.caught.nfe");
                        return -1;
                    }
                } else {
                    d = ScriptRuntime.stringToNumber(string, 0, n4);
                }
                this.number = d;
                return 39;
            }
            if (n == 34 || n == 39) {
                int n5 = n;
                this.stringBufferTop = 0;
                n = this.getChar();
                block46: while (n != n5) {
                    if (n == 10 || n == -1) {
                        this.ungetChar(n);
                        this.parser.addError("msg.unterminated.string.lit");
                        return -1;
                    }
                    if (n == 92) {
                        n = this.getChar();
                        switch (n) {
                            case 98: {
                                n = 8;
                                break;
                            }
                            case 102: {
                                n = 12;
                                break;
                            }
                            case 110: {
                                n = 10;
                                break;
                            }
                            case 114: {
                                n = 13;
                                break;
                            }
                            case 116: {
                                n = 9;
                                break;
                            }
                            case 118: {
                                n = 11;
                                break;
                            }
                            case 117: {
                                int n6;
                                int n7 = this.stringBufferTop;
                                this.addToString(117);
                                int n8 = 0;
                                for (n6 = 0; n6 != 4; ++n6) {
                                    n = this.getChar();
                                    n8 = Kit.xDigitToInt(n, n8);
                                    if (n8 < 0) continue block46;
                                    this.addToString(n);
                                }
                                this.stringBufferTop = n7;
                                n = n8;
                                break;
                            }
                            case 120: {
                                n = this.getChar();
                                int n8 = Kit.xDigitToInt(n, 0);
                                if (n8 < 0) {
                                    this.addToString(120);
                                    continue block46;
                                }
                                int n6 = n;
                                n = this.getChar();
                                n8 = Kit.xDigitToInt(n, n8);
                                if (n8 < 0) {
                                    this.addToString(120);
                                    this.addToString(n6);
                                    continue block46;
                                }
                                n = n8;
                                break;
                            }
                            case 10: {
                                n = this.getChar();
                                continue block46;
                            }
                            default: {
                                if (48 > n || n >= 56) break;
                                int n6 = n - 48;
                                n = this.getChar();
                                if (48 <= n && n < 56) {
                                    n6 = 8 * n6 + n - 48;
                                    n = this.getChar();
                                    if (48 <= n && n < 56 && n6 <= 31) {
                                        n6 = 8 * n6 + n - 48;
                                        n = this.getChar();
                                    }
                                }
                                this.ungetChar(n);
                                n = n6;
                            }
                        }
                    }
                    this.addToString(n);
                    n = this.getChar();
                }
                String string = this.getStringFromBuffer();
                this.string = (String)this.allStrings.intern(string);
                return 40;
            }
            switch (n) {
                case 59: {
                    return 78;
                }
                case 91: {
                    return 79;
                }
                case 93: {
                    return 80;
                }
                case 123: {
                    return 81;
                }
                case 125: {
                    return 82;
                }
                case 40: {
                    return 83;
                }
                case 41: {
                    return 84;
                }
                case 44: {
                    return 85;
                }
                case 63: {
                    return 98;
                }
                case 58: {
                    if (this.matchChar(58)) {
                        return 140;
                    }
                    return 99;
                }
                case 46: {
                    if (this.matchChar(46)) {
                        return 139;
                    }
                    if (this.matchChar(40)) {
                        return 142;
                    }
                    return 104;
                }
                case 124: {
                    if (this.matchChar(124)) {
                        return 100;
                    }
                    if (this.matchChar(61)) {
                        return 87;
                    }
                    return 9;
                }
                case 94: {
                    if (this.matchChar(61)) {
                        return 88;
                    }
                    return 10;
                }
                case 38: {
                    if (this.matchChar(38)) {
                        return 101;
                    }
                    if (this.matchChar(61)) {
                        return 89;
                    }
                    return 11;
                }
                case 61: {
                    if (this.matchChar(61)) {
                        if (this.matchChar(61)) {
                            return 45;
                        }
                        return 12;
                    }
                    return 86;
                }
                case 33: {
                    if (this.matchChar(61)) {
                        if (this.matchChar(61)) {
                            return 46;
                        }
                        return 13;
                    }
                    return 26;
                }
                case 60: {
                    if (this.matchChar(33)) {
                        if (this.matchChar(45)) {
                            if (this.matchChar(45)) {
                                this.skipLine();
                                continue block39;
                            }
                            this.ungetChar(45);
                        }
                        this.ungetChar(33);
                    }
                    if (this.matchChar(60)) {
                        if (this.matchChar(61)) {
                            return 90;
                        }
                        return 18;
                    }
                    if (this.matchChar(61)) {
                        return 15;
                    }
                    return 14;
                }
                case 62: {
                    if (this.matchChar(62)) {
                        if (this.matchChar(62)) {
                            if (this.matchChar(61)) {
                                return 92;
                            }
                            return 20;
                        }
                        if (this.matchChar(61)) {
                            return 91;
                        }
                        return 19;
                    }
                    if (this.matchChar(61)) {
                        return 17;
                    }
                    return 16;
                }
                case 42: {
                    if (this.matchChar(61)) {
                        return 95;
                    }
                    return 23;
                }
                case 47: {
                    if (this.matchChar(47)) {
                        this.skipLine();
                        continue block39;
                    }
                    if (this.matchChar(42)) {
                        while (!((n = this.getChar()) == -1 || n == 42 && this.matchChar(47))) {
                        }
                        if (n != -1) continue block39;
                        this.parser.addError("msg.unterminated.comment");
                        return -1;
                    }
                    if (this.matchChar(61)) {
                        return 96;
                    }
                    return 24;
                }
                case 37: {
                    if (this.matchChar(61)) {
                        return 97;
                    }
                    return 25;
                }
                case 126: {
                    return 27;
                }
                case 43: {
                    if (this.matchChar(61)) {
                        return 93;
                    }
                    if (this.matchChar(43)) {
                        return 102;
                    }
                    return 21;
                }
                case 45: {
                    if (this.matchChar(61)) {
                        n = 94;
                    } else if (this.matchChar(45)) {
                        if (!this.dirtyLine && this.matchChar(62)) {
                            this.skipLine();
                            continue block39;
                        }
                        n = 103;
                    } else {
                        n = 22;
                    }
                    this.dirtyLine = true;
                    return n;
                }
            }
            break;
        }
        this.parser.addError("msg.illegal.character");
        return -1;
    }

    final int getJSDocToken() throws IOException {
        int n;
        this.stringBufferTop = 0;
        do {
            this.charno = -1;
            n = this.getChar();
            if (n == -1) {
                return 0;
            }
            if (n != 10) continue;
            return 1;
        } while (TokenStream.isJSSpace(n));
        switch (n) {
            case 64: {
                while (TokenStream.isAlpha(n = this.getChar())) {
                    this.addToString(n);
                }
                this.ungetChar(n);
                this.string = this.getStringFromBuffer();
                this.stringBufferTop = 0;
                return 300;
            }
            case 42: {
                if (this.matchChar(47)) {
                    return 303;
                }
                return 302;
            }
            case 44: {
                return 85;
            }
            case 62: {
                return 16;
            }
            case 40: {
                return 83;
            }
            case 41: {
                return 84;
            }
            case 123: {
                return 81;
            }
            case 125: {
                return 82;
            }
            case 91: {
                return 79;
            }
            case 93: {
                return 80;
            }
            case 63: {
                return 304;
            }
            case 33: {
                return 306;
            }
            case 58: {
                return 99;
            }
            case 61: {
                return 307;
            }
            case 124: {
                this.matchChar(124);
                return 301;
            }
            case 46: {
                n = this.getChar();
                if (n == 60) {
                    return 14;
                }
                if (n == 46) {
                    n = this.getChar();
                    if (n == 46) {
                        return 305;
                    }
                    this.addToString(46);
                }
                this.ungetBuffer[this.ungetCursor++] = n;
                n = 46;
            }
        }
        int n2 = n;
        this.addToString(n);
        int n3 = this.getChar();
        if (!this.isJSDocString(n3)) {
            this.ungetChar(n3);
            this.string = this.getStringFromBuffer();
            this.stringBufferTop = 0;
            return 40;
        }
        while (true) {
            n2 = n3;
            n3 = this.getChar();
            if (n2 == 46 && n3 == 60) {
                this.ungetChar(n3);
                this.ungetChar(n2);
                this.string = this.getStringFromBuffer();
                this.stringBufferTop = 0;
                return 40;
            }
            if (!this.isJSDocString(n3)) break;
            this.addToString(n2);
        }
        this.ungetChar(n3);
        this.addToString(n2);
        this.string = this.getStringFromBuffer();
        this.stringBufferTop = 0;
        return 40;
    }

    String getRemainingJSDocLine() throws IOException {
        block4: while (true) {
            int n = this.getChar();
            switch (n) {
                case 42: {
                    if (this.peekChar() != 47) {
                        this.addToString(n);
                        continue block4;
                    }
                }
                case -1: 
                case 10: {
                    this.ungetChar(n);
                    this.string = this.getStringFromBuffer();
                    this.stringBufferTop = 0;
                    return this.string;
                }
            }
            this.addToString(n);
        }
    }

    private boolean isJSDocString(int n) {
        switch (n) {
            case -1: 
            case 10: 
            case 33: 
            case 40: 
            case 41: 
            case 42: 
            case 44: 
            case 58: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 91: 
            case 93: 
            case 123: 
            case 124: 
            case 125: {
                return false;
            }
        }
        return !TokenStream.isJSSpace(n);
    }

    private static boolean isAlpha(int n) {
        if (n <= 90) {
            return 65 <= n;
        }
        return 97 <= n && n <= 122;
    }

    static boolean isDigit(int n) {
        return 48 <= n && n <= 57;
    }

    static boolean isJSSpace(int n) {
        if (n <= 127) {
            return n == 32 || n == 9 || n == 12 || n == 11;
        }
        return n == 160 || Character.getType((char)n) == 12;
    }

    private static boolean isJSFormatChar(int n) {
        return n > 127 && Character.getType((char)n) == 16;
    }

    JSDocInfo getAndResetJSDocInfo() {
        return null;
    }

    JSDocInfo getFileOverviewJSDocInfo() {
        return null;
    }

    boolean isPopulated() {
        return false;
    }

    void readRegExp(int n) throws IOException {
        int n2;
        this.stringBufferTop = 0;
        if (n == 96) {
            this.addToString(61);
        } else if (n != 24) {
            Kit.codeBug();
        }
        boolean bl = false;
        while ((n2 = this.getChar()) != 47 || bl) {
            if (n2 == 10 || n2 == -1) {
                this.ungetChar(n2);
                throw this.parser.reportError("msg.unterminated.re.lit");
            }
            if (n2 == 92) {
                this.addToString(n2);
                n2 = this.getChar();
            } else if (n2 == 91) {
                bl = true;
            } else if (n2 == 93) {
                bl = false;
            }
            this.addToString(n2);
        }
        int n3 = this.stringBufferTop;
        while (true) {
            if (this.matchChar(103)) {
                this.addToString(103);
                continue;
            }
            if (this.matchChar(105)) {
                this.addToString(105);
                continue;
            }
            if (!this.matchChar(109)) break;
            this.addToString(109);
        }
        if (TokenStream.isAlpha(this.peekChar())) {
            throw this.parser.reportError("msg.invalid.re.flag");
        }
        this.string = new String(this.stringBuffer, 0, n3);
        this.regExpFlags = new String(this.stringBuffer, n3, this.stringBufferTop - n3);
    }

    boolean isXMLAttribute() {
        return this.xmlIsAttribute;
    }

    int getFirstXMLToken() throws IOException {
        this.xmlOpenTagsCount = 0;
        this.xmlIsAttribute = false;
        this.xmlIsTagContent = false;
        this.ungetChar(60);
        return this.getNextXMLToken();
    }

    int getNextXMLToken() throws IOException {
        this.stringBufferTop = 0;
        int n = this.getChar();
        while (n != -1) {
            if (this.xmlIsTagContent) {
                switch (n) {
                    case 62: {
                        this.addToString(n);
                        this.xmlIsTagContent = false;
                        this.xmlIsAttribute = false;
                        break;
                    }
                    case 47: {
                        this.addToString(n);
                        if (this.peekChar() != 62) break;
                        n = this.getChar();
                        this.addToString(n);
                        this.xmlIsTagContent = false;
                        --this.xmlOpenTagsCount;
                        break;
                    }
                    case 123: {
                        this.ungetChar(n);
                        this.string = this.getStringFromBuffer();
                        return 141;
                    }
                    case 34: 
                    case 39: {
                        this.addToString(n);
                        if (this.readQuotedString(n)) break;
                        return -1;
                    }
                    case 61: {
                        this.addToString(n);
                        this.xmlIsAttribute = true;
                        break;
                    }
                    case 9: 
                    case 10: 
                    case 13: 
                    case 32: {
                        this.addToString(n);
                        break;
                    }
                    default: {
                        this.addToString(n);
                        this.xmlIsAttribute = false;
                    }
                }
                if (!this.xmlIsTagContent && this.xmlOpenTagsCount == 0) {
                    this.string = this.getStringFromBuffer();
                    return 144;
                }
            } else {
                block8 : switch (n) {
                    case 60: {
                        this.addToString(n);
                        n = this.peekChar();
                        switch (n) {
                            case 33: {
                                n = this.getChar();
                                this.addToString(n);
                                n = this.peekChar();
                                switch (n) {
                                    case 45: {
                                        n = this.getChar();
                                        this.addToString(n);
                                        n = this.getChar();
                                        if (n == 45) {
                                            this.addToString(n);
                                            if (this.readXmlComment()) break block8;
                                            return -1;
                                        }
                                        this.stringBufferTop = 0;
                                        this.string = null;
                                        this.parser.addError("msg.XML.bad.form");
                                        return -1;
                                    }
                                    case 91: {
                                        n = this.getChar();
                                        this.addToString(n);
                                        if (this.getChar() == 67 && this.getChar() == 68 && this.getChar() == 65 && this.getChar() == 84 && this.getChar() == 65 && this.getChar() == 91) {
                                            this.addToString(67);
                                            this.addToString(68);
                                            this.addToString(65);
                                            this.addToString(84);
                                            this.addToString(65);
                                            this.addToString(91);
                                            if (this.readCDATA()) break block8;
                                            return -1;
                                        }
                                        this.stringBufferTop = 0;
                                        this.string = null;
                                        this.parser.addError("msg.XML.bad.form");
                                        return -1;
                                    }
                                    default: {
                                        if (this.readEntity()) break block8;
                                        return -1;
                                    }
                                }
                            }
                            case 63: {
                                n = this.getChar();
                                this.addToString(n);
                                if (this.readPI()) break block8;
                                return -1;
                            }
                            case 47: {
                                n = this.getChar();
                                this.addToString(n);
                                if (this.xmlOpenTagsCount == 0) {
                                    this.stringBufferTop = 0;
                                    this.string = null;
                                    this.parser.addError("msg.XML.bad.form");
                                    return -1;
                                }
                                this.xmlIsTagContent = true;
                                --this.xmlOpenTagsCount;
                                break;
                            }
                            default: {
                                this.xmlIsTagContent = true;
                                ++this.xmlOpenTagsCount;
                                break;
                            }
                        }
                        break;
                    }
                    case 123: {
                        this.ungetChar(n);
                        this.string = this.getStringFromBuffer();
                        return 141;
                    }
                    default: {
                        this.addToString(n);
                    }
                }
            }
            n = this.getChar();
        }
        this.stringBufferTop = 0;
        this.string = null;
        this.parser.addError("msg.XML.bad.form");
        return -1;
    }

    private boolean readQuotedString(int n) throws IOException {
        int n2 = this.getChar();
        while (n2 != -1) {
            this.addToString(n2);
            if (n2 == n) {
                return true;
            }
            n2 = this.getChar();
        }
        this.stringBufferTop = 0;
        this.string = null;
        this.parser.addError("msg.XML.bad.form");
        return false;
    }

    private boolean readXmlComment() throws IOException {
        int n = this.getChar();
        while (n != -1) {
            this.addToString(n);
            if (n == 45 && this.peekChar() == 45) {
                n = this.getChar();
                this.addToString(n);
                if (this.peekChar() != 62) continue;
                n = this.getChar();
                this.addToString(n);
                return true;
            }
            n = this.getChar();
        }
        this.stringBufferTop = 0;
        this.string = null;
        this.parser.addError("msg.XML.bad.form");
        return false;
    }

    private boolean readCDATA() throws IOException {
        int n = this.getChar();
        while (n != -1) {
            this.addToString(n);
            if (n == 93 && this.peekChar() == 93) {
                n = this.getChar();
                this.addToString(n);
                if (this.peekChar() != 62) continue;
                n = this.getChar();
                this.addToString(n);
                return true;
            }
            n = this.getChar();
        }
        this.stringBufferTop = 0;
        this.string = null;
        this.parser.addError("msg.XML.bad.form");
        return false;
    }

    private boolean readEntity() throws IOException {
        int n = 1;
        int n2 = this.getChar();
        while (n2 != -1) {
            this.addToString(n2);
            switch (n2) {
                case 60: {
                    ++n;
                    break;
                }
                case 62: {
                    if (--n != 0) break;
                    return true;
                }
            }
            n2 = this.getChar();
        }
        this.stringBufferTop = 0;
        this.string = null;
        this.parser.addError("msg.XML.bad.form");
        return false;
    }

    private boolean readPI() throws IOException {
        int n = this.getChar();
        while (n != -1) {
            this.addToString(n);
            if (n == 63 && this.peekChar() == 62) {
                n = this.getChar();
                this.addToString(n);
                return true;
            }
            n = this.getChar();
        }
        this.stringBufferTop = 0;
        this.string = null;
        this.parser.addError("msg.XML.bad.form");
        return false;
    }

    private String getStringFromBuffer() {
        return new String(this.stringBuffer, 0, this.stringBufferTop);
    }

    private void addToString(int n) {
        int n2 = this.stringBufferTop;
        if (n2 == this.stringBuffer.length) {
            char[] cArray = new char[this.stringBuffer.length * 2];
            System.arraycopy(this.stringBuffer, 0, cArray, 0, n2);
            this.stringBuffer = cArray;
        }
        this.stringBuffer[n2] = (char)n;
        this.stringBufferTop = n2 + 1;
    }

    public int getTokenno() {
        return this.tokenno;
    }

    protected void ungetChar(int n) {
        if (this.ungetCursor != 0 && this.ungetBuffer[this.ungetCursor - 1] == 10) {
            Kit.codeBug();
        }
        this.ungetBuffer[this.ungetCursor++] = n;
    }

    private boolean matchChar(int n) throws IOException {
        int n2 = this.getChar();
        if (n2 == n) {
            return true;
        }
        this.ungetChar(n2);
        return false;
    }

    private int peekChar() throws IOException {
        int n = this.getChar();
        this.ungetChar(n);
        return n;
    }

    protected int getChar() throws IOException {
        int n;
        block15: {
            if (this.ungetCursor != 0) {
                --this.ungetCursor;
                if (this.charno == -1) {
                    this.charno = this.getOffset();
                }
                return this.ungetBuffer[this.ungetCursor];
            }
            while (true) {
                if (this.sourceString != null) {
                    if (this.sourceCursor == this.sourceEnd) {
                        this.hitEOF = true;
                        if (this.charno == -1) {
                            this.charno = this.getOffset();
                        }
                        return -1;
                    }
                    n = this.sourceString.charAt(this.sourceCursor++);
                } else {
                    if (this.sourceCursor == this.sourceEnd && !this.fillSourceBuffer()) {
                        this.hitEOF = true;
                        if (this.charno == -1) {
                            this.charno = this.getOffset();
                        }
                        return -1;
                    }
                    n = this.sourceBuffer[this.sourceCursor++];
                }
                if (this.lineEndChar >= 0) {
                    if (this.lineEndChar == 13 && n == 10) {
                        this.lineEndChar = 10;
                        continue;
                    }
                    this.lineEndChar = -1;
                    this.lineStart = this.sourceCursor - 1;
                    ++this.lineno;
                }
                if (n <= 127) {
                    if (n == 10 || n == 13) {
                        this.lineEndChar = n;
                        n = 10;
                    }
                    break block15;
                }
                if (!TokenStream.isJSFormatChar(n)) break;
            }
            if (ScriptRuntime.isJSLineTerminator(n)) {
                this.lineEndChar = n;
                n = 10;
            }
        }
        if (this.charno == -1) {
            this.charno = this.getOffset();
        }
        return n;
    }

    private void skipLine() throws IOException {
        int n;
        while ((n = this.getChar()) != -1 && n != 10) {
        }
        this.ungetChar(n);
    }

    final int getOffset() {
        return this.sourceCursor - this.lineStart - this.ungetCursor - 1;
    }

    final String getLine() {
        if (this.sourceString != null) {
            int n;
            if (this.lineEndChar >= 0) {
                --n;
            } else {
                char c;
                for (n = this.sourceCursor; n != this.sourceEnd && !ScriptRuntime.isJSLineTerminator(c = this.sourceString.charAt(n)); ++n) {
                }
            }
            return this.sourceString.substring(this.lineStart, n);
        }
        int n = this.sourceCursor - this.lineStart;
        if (this.lineEndChar >= 0) {
            --n;
        } else {
            while (true) {
                char c;
                int n2;
                if ((n2 = this.lineStart + n) == this.sourceEnd) {
                    try {
                        if (!this.fillSourceBuffer()) {
                        }
                    }
                    catch (IOException iOException) {}
                    break;
                    n2 = this.lineStart + n;
                }
                if (ScriptRuntime.isJSLineTerminator(c = this.sourceBuffer[n2])) break;
                ++n;
            }
        }
        return new String(this.sourceBuffer, this.lineStart, n);
    }

    private boolean fillSourceBuffer() throws IOException {
        int n;
        if (this.sourceString != null) {
            Kit.codeBug();
        }
        if (this.sourceEnd == this.sourceBuffer.length) {
            if (this.lineStart != 0) {
                System.arraycopy(this.sourceBuffer, this.lineStart, this.sourceBuffer, 0, this.sourceEnd - this.lineStart);
                this.sourceEnd -= this.lineStart;
                this.sourceCursor -= this.lineStart;
                this.lineStart = 0;
            } else {
                char[] cArray = new char[this.sourceBuffer.length * 2];
                System.arraycopy(this.sourceBuffer, 0, cArray, 0, this.sourceEnd);
                this.sourceBuffer = cArray;
            }
        }
        if ((n = this.sourceReader.read(this.sourceBuffer, this.sourceEnd, this.sourceBuffer.length - this.sourceEnd)) < 0) {
            return false;
        }
        this.sourceEnd += n;
        return true;
    }

    public void setFileLevelJsDocBuilder(Node.FileLevelJsDocBuilder fileLevelJsDocBuilder) {
    }
}

