/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.graph;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import com.google.javascript.jscomp.graph.UnionFind;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

public class StandardUnionFind<E>
implements Serializable,
UnionFind<E> {
    private static final long serialVersionUID = -1L;
    private final Map<E, Node<E>> elmap = Maps.newLinkedHashMap();

    public StandardUnionFind() {
    }

    public StandardUnionFind(UnionFind<E> unionFind) {
        for (E e : unionFind.elements()) {
            this.union(e, unionFind.find(e));
        }
    }

    @Override
    public void add(E e) {
        this.union(e, e);
    }

    @Override
    public E union(E e, E e2) {
        Node<E> node;
        Node<E> node2 = this.findRootOrCreateNode(e);
        if (node2 == (node = this.findRootOrCreateNode(e2))) {
            return node2.element;
        }
        if (node2.rank > node.rank) {
            node.parent = node2;
            node2.size += node.size;
            return node2.element;
        }
        node2.parent = node;
        if (node2.rank == node.rank) {
            ++node.rank;
        }
        node.size += node2.size;
        return node.element;
    }

    @Override
    public E find(E e) {
        Preconditions.checkArgument((boolean)this.elmap.containsKey(e), (String)"Element does not exist: %s", (Object[])new Object[]{e});
        return this.findRoot(this.elmap.get(e)).element;
    }

    @Override
    public boolean areEquivalent(E e, E e2) {
        E e3;
        E e4 = this.find(e);
        return e4 == (e3 = this.find(e2));
    }

    @Override
    public Set<E> elements() {
        return Collections.unmodifiableSet(this.elmap.keySet());
    }

    @Override
    public Collection<Set<E>> allEquivalenceClasses() {
        HashMap hashMap = Maps.newHashMap();
        for (Node<E> node : this.elmap.values()) {
            ImmutableSet.Builder builder3 = this.findRoot(node);
            ImmutableSet.Builder builder2 = (ImmutableSet.Builder)hashMap.get(builder3);
            if (builder2 == null) {
                builder2 = ImmutableSet.builder();
                hashMap.put(builder3, builder2);
            }
            builder2.add(node.element);
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (ImmutableSet.Builder builder3 : hashMap.values()) {
            builder.add((Object)builder3.build());
        }
        return builder.build();
    }

    private Node<E> findRootOrCreateNode(E e) {
        Node<E> node = this.elmap.get(e);
        if (node != null) {
            return this.findRoot(node);
        }
        node = new Node<E>(e);
        this.elmap.put(e, node);
        return node;
    }

    private Node<E> findRoot(Node<E> node) {
        if (node.parent != node) {
            node.parent = this.findRoot(node.parent);
        }
        return node.parent;
    }

    @Override
    public Set<E> findAll(final E e) {
        Preconditions.checkArgument((boolean)this.elmap.containsKey(e), (Object)("Element does not exist: " + e));
        Predicate<Object> predicate = new Predicate<Object>(){
            Node<E> nodeForValue;
            {
                this.nodeForValue = (Node)StandardUnionFind.this.elmap.get(e);
            }

            public boolean apply(@Nullable Object object) {
                if (Objects.equal((Object)e, (Object)object)) {
                    return true;
                }
                Node node = (Node)StandardUnionFind.this.elmap.get(object);
                if (node == null) {
                    return false;
                }
                this.nodeForValue = StandardUnionFind.this.findRoot(this.nodeForValue);
                return StandardUnionFind.this.findRoot(node) == this.nodeForValue;
            }
        };
        return new AbstractSet<E>((Predicate)predicate, e){
            final /* synthetic */ Predicate val$isSameRoot;
            final /* synthetic */ Object val$value;
            {
                this.val$isSameRoot = predicate;
                this.val$value = object;
            }

            @Override
            public boolean contains(Object object) {
                return this.val$isSameRoot.apply(object);
            }

            @Override
            public Iterator<E> iterator() {
                return Iterators.unmodifiableIterator((Iterator)Iterators.filter(StandardUnionFind.this.elmap.keySet().iterator(), (Predicate)this.val$isSameRoot));
            }

            @Override
            public int size() {
                return ((StandardUnionFind)StandardUnionFind.this).findRoot((Node)((Node)((StandardUnionFind)StandardUnionFind.this).elmap.get((Object)this.val$value))).size;
            }
        };
    }

    private static class Node<E> {
        Node<E> parent = this;
        final E element;
        int rank = 0;
        int size = 1;

        Node(E e) {
            this.element = e;
        }
    }
}

