/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.collect.ImmutableMap;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.mozilla.rhino.ErrorReporter;
import com.google.javascript.jscomp.mozilla.rhino.EvaluatorException;
import com.google.javascript.jscomp.mozilla.rhino.ScriptRuntime;
import java.util.Map;
import java.util.regex.Pattern;

class RhinoErrorReporter {
    static final DiagnosticType PARSE_ERROR = DiagnosticType.error("JSC_PARSE_ERROR", "Parse error. {0}");
    static final DiagnosticType EXTRA_FILEOVERVIEW = DiagnosticType.warning("JSC_EXTRA_FILEOVERVIEW", "Parse error. {0}");
    static final DiagnosticType TRAILING_COMMA = DiagnosticType.error("JSC_TRAILING_COMMA", "Parse error. Internet Explorer has a non-standard intepretation of trailing commas. Arrays will have the wrong length and objects will not parse at all.");
    static final DiagnosticType DUPLICATE_PARAM = DiagnosticType.error("JSC_DUPLICATE_PARAM", "Parse error. {0}");
    static final DiagnosticType BAD_JSDOC_ANNOTATION = DiagnosticType.warning("JSC_BAD_JSDOC_ANNOTATION", "Parse error. {0}");
    private final Map<String, DiagnosticType> typeMap;
    private final AbstractCompiler compiler;

    private String replacePlaceHolders(String string) {
        string = Pattern.quote(string);
        return string.replaceAll("\\{\\d+\\}", "\\\\E.*\\\\Q");
    }

    private RhinoErrorReporter(AbstractCompiler abstractCompiler) {
        this.compiler = abstractCompiler;
        this.typeMap = ImmutableMap.of((Object)this.replacePlaceHolders(com.google.javascript.rhino.ScriptRuntime.getMessage0("msg.jsdoc.fileoverview.extra")), (Object)EXTRA_FILEOVERVIEW, (Object)this.replacePlaceHolders(ScriptRuntime.getMessage0("msg.extra.trailing.comma")), (Object)TRAILING_COMMA, (Object)this.replacePlaceHolders(ScriptRuntime.getMessage0("msg.dup.parms")), (Object)DUPLICATE_PARAM, (Object)this.replacePlaceHolders(com.google.javascript.rhino.ScriptRuntime.getMessage0("msg.bad.jsdoc.tag")), (Object)BAD_JSDOC_ANNOTATION);
    }

    public static ErrorReporter forNewRhino(AbstractCompiler abstractCompiler) {
        return new NewRhinoErrorReporter(abstractCompiler);
    }

    public static com.google.javascript.rhino.ErrorReporter forOldRhino(AbstractCompiler abstractCompiler) {
        return new OldRhinoErrorReporter(abstractCompiler);
    }

    public void warning(String string, String string2, int n, String string3, int n2) {
        this.compiler.report(this.makeError(string, string2, n, n2, CheckLevel.WARNING));
    }

    public void error(String string, String string2, int n, String string3, int n2) {
        this.compiler.report(this.makeError(string, string2, n, n2, CheckLevel.ERROR));
    }

    private JSError makeError(String string, String string2, int n, int n2, CheckLevel checkLevel) {
        for (Map.Entry<String, DiagnosticType> entry : this.typeMap.entrySet()) {
            if (!string.matches(entry.getKey())) continue;
            return JSError.make(string2, n, n2, entry.getValue(), string);
        }
        return JSError.make(string2, n, n2, checkLevel, PARSE_ERROR, string);
    }

    private static class NewRhinoErrorReporter
    extends RhinoErrorReporter
    implements ErrorReporter {
        private NewRhinoErrorReporter(AbstractCompiler abstractCompiler) {
            super(abstractCompiler);
        }

        @Override
        public EvaluatorException runtimeError(String string, String string2, int n, String string3, int n2) {
            return new EvaluatorException(string, string2, n, string3, n2);
        }
    }

    private static class OldRhinoErrorReporter
    extends RhinoErrorReporter
    implements com.google.javascript.rhino.ErrorReporter {
        private OldRhinoErrorReporter(AbstractCompiler abstractCompiler) {
            super(abstractCompiler);
        }

        @Override
        public com.google.javascript.rhino.EvaluatorException runtimeError(String string, String string2, int n, String string3, int n2) {
            return new com.google.javascript.rhino.EvaluatorException(string, string2, n, string3, n2);
        }
    }
}

