/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DefinitionSite;
import com.google.javascript.jscomp.DefinitionsRemover;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.OptimizeCalls;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.SimpleDefinitionFinder;
import com.google.javascript.jscomp.SyntacticScopeCreator;
import com.google.javascript.jscomp.UseSite;
import com.google.javascript.rhino.Node;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

class RemoveUnusedVars
implements CompilerPass,
OptimizeCalls.CallGraphCompilerPass {
    private final AbstractCompiler compiler;
    private final boolean removeGlobals;
    private boolean preserveFunctionExpressionNames;
    private final Set<Scope.Var> referenced = Sets.newHashSet();
    private final List<Scope.Var> maybeUnreferenced = Lists.newArrayList();
    private final List<Scope> allFunctionScopes = Lists.newArrayList();
    private final Multimap<Scope.Var, Assign> assignsByVar = ArrayListMultimap.create();
    private final Map<Node, Assign> assignsByNode = Maps.newHashMap();
    private final Multimap<Scope.Var, Continuation> continuations = ArrayListMultimap.create();
    private boolean modifyCallSites;
    private CallSiteOptimizer callSiteOptimizer;

    RemoveUnusedVars(AbstractCompiler abstractCompiler, boolean bl, boolean bl2, boolean bl3) {
        this.compiler = abstractCompiler;
        this.removeGlobals = bl;
        this.preserveFunctionExpressionNames = bl2;
        this.modifyCallSites = bl3;
    }

    @Override
    public void process(Node node, Node node2) {
        SimpleDefinitionFinder simpleDefinitionFinder = null;
        if (this.modifyCallSites) {
            simpleDefinitionFinder = new SimpleDefinitionFinder(this.compiler);
            simpleDefinitionFinder.process(node, node2);
        }
        this.process(node, node2, simpleDefinitionFinder);
    }

    @Override
    public void process(Node node, Node node2, SimpleDefinitionFinder simpleDefinitionFinder) {
        if (this.modifyCallSites) {
            Preconditions.checkNotNull((Object)simpleDefinitionFinder);
            this.callSiteOptimizer = new CallSiteOptimizer(this.compiler, simpleDefinitionFinder);
        }
        this.traverseAndRemoveUnusedReferences(node2);
    }

    private void traverseAndRemoveUnusedReferences(Node node) {
        Scope scope = new SyntacticScopeCreator(this.compiler).createScope(node, null);
        this.traverseNode(node, null, scope);
        if (this.removeGlobals) {
            this.collectMaybeUnreferencedVars(scope);
        }
        this.interpretAssigns();
        this.removeUnreferencedVars();
        for (Scope scope2 : this.allFunctionScopes) {
            this.removeUnreferencedFunctionArgs(scope2);
        }
    }

    private void traverseNode(Node node, Node node2, Scope scope) {
        Object object;
        int n = node.getType();
        Scope.Var var = null;
        switch (n) {
            case 105: {
                if (NodeUtil.isFunctionDeclaration(node)) {
                    var = scope.getVar(node.getFirstChild().getString());
                }
                if (var != null && this.isRemovableVar(var)) {
                    this.continuations.put((Object)var, (Object)new Continuation(node, scope));
                } else {
                    this.traverseFunction(node, scope);
                }
                return;
            }
            case 86: {
                object = Assign.maybeCreateAssign(node);
                if (object == null || (var = scope.getVar(((Assign)object).nameNode.getString())) == null) break;
                this.assignsByVar.put((Object)var, object);
                this.assignsByNode.put(((Assign)object).nameNode, (Assign)object);
                if (!this.isRemovableVar(var) || ((Assign)object).mayHaveSecondarySideEffects) break;
                this.continuations.put((Object)var, (Object)new Continuation(node, scope));
                return;
            }
            case 38: {
                var = scope.getVar(node.getString());
                if (node2.getType() == 118) {
                    Node node3 = node.getFirstChild();
                    if (node3 == null || var == null || !this.isRemovableVar(var) || NodeUtil.mayHaveSideEffects(node3)) break;
                    this.continuations.put((Object)var, (Object)new Continuation(node, scope));
                    return;
                }
                if (var == null) break;
                if (this.isRemovableVar(var)) {
                    if (this.assignsByNode.containsKey(node)) break;
                    this.markReferencedVar(var);
                    break;
                }
                this.markReferencedVar(var);
            }
        }
        for (object = node.getFirstChild(); object != null; object = ((Node)object).getNext()) {
            this.traverseNode((Node)object, node, scope);
        }
    }

    private boolean isRemovableVar(Scope.Var var) {
        if (!this.removeGlobals && var.isGlobal()) {
            return false;
        }
        if (this.referenced.contains(var)) {
            return false;
        }
        return !this.compiler.getCodingConvention().isExported(var.getName());
    }

    private void traverseFunction(Node node, Scope scope) {
        Preconditions.checkState((node.getChildCount() == 3 ? 1 : 0) != 0);
        Preconditions.checkState((node.getType() == 105 ? 1 : 0) != 0);
        Node node2 = node.getLastChild();
        Preconditions.checkState((node2.getNext() == null && node2.getType() == 125 ? 1 : 0) != 0);
        Scope scope2 = new SyntacticScopeCreator(this.compiler).createScope(node, scope);
        this.traverseNode(node2, node, scope2);
        this.collectMaybeUnreferencedVars(scope2);
        this.allFunctionScopes.add(scope2);
    }

    private void collectMaybeUnreferencedVars(Scope scope) {
        Iterator<Scope.Var> iterator = scope.getVars();
        while (iterator.hasNext()) {
            Scope.Var var = iterator.next();
            if (!this.isRemovableVar(var)) continue;
            this.maybeUnreferenced.add(var);
        }
    }

    private void removeUnreferencedFunctionArgs(Scope scope) {
        boolean bl;
        Node node = scope.getRootNode();
        Preconditions.checkState((node.getType() == 105 ? 1 : 0) != 0);
        Node node2 = RemoveUnusedVars.getFunctionArgList(node);
        boolean bl2 = bl = this.modifyCallSites && this.callSiteOptimizer.canModifyCallers(node);
        if (!bl) {
            Scope.Var var;
            Node node3;
            while ((node3 = node2.getLastChild()) != null && !this.referenced.contains(var = scope.getVar(node3.getString()))) {
                Preconditions.checkNotNull((Object)(var == null ? 1 : 0));
                node2.removeChild(node3);
                this.compiler.reportCodeChange();
            }
        } else {
            this.callSiteOptimizer.optimize(scope, this.referenced);
        }
    }

    private static Node getFunctionArgList(Node node) {
        return node.getFirstChild().getNext();
    }

    private void interpretAssigns() {
        boolean bl = false;
        do {
            bl = false;
            for (int i = 0; i < this.maybeUnreferenced.size(); ++i) {
                Object object;
                Scope.Var var = this.maybeUnreferenced.get(i);
                if (this.referenced.contains(var)) {
                    this.maybeUnreferenced.remove(i);
                    --i;
                    continue;
                }
                boolean bl2 = false;
                boolean bl3 = false;
                bl2 = var.getParentNode().getType() == 118 && !NodeUtil.isForIn(var.getParentNode().getParent()) ? (object = var.getInitialValue()) != null && !NodeUtil.isLiteralValue((Node)object, true) : true;
                object = this.assignsByVar.get((Object)var).iterator();
                while (object.hasNext()) {
                    Assign assign = (Assign)object.next();
                    if (assign.isPropertyAssign) {
                        bl3 = true;
                        continue;
                    }
                    if (NodeUtil.isLiteralValue(assign.assignNode.getLastChild(), true)) continue;
                    bl2 = true;
                }
                if (!bl2 || !bl3) continue;
                bl = this.markReferencedVar(var) || bl;
                this.maybeUnreferenced.remove(i);
                --i;
            }
        } while (bl);
    }

    private void removeAllAssigns(Scope.Var var) {
        for (Assign assign : this.assignsByVar.get((Object)var)) {
            assign.remove();
            this.compiler.reportCodeChange();
        }
    }

    private boolean markReferencedVar(Scope.Var var) {
        if (this.referenced.add(var)) {
            for (Continuation continuation : this.continuations.get((Object)var)) {
                continuation.apply();
            }
            return true;
        }
        return false;
    }

    private void removeUnreferencedVars() {
        CodingConvention codingConvention = this.compiler.getCodingConvention();
        for (Scope.Var var : this.maybeUnreferenced) {
            this.removeAllAssigns(var);
            this.compiler.addToDebugLog("Unreferenced var: " + var.name);
            Node node = var.nameNode;
            Node node2 = node.getParent();
            Node node3 = node2.getParent();
            Preconditions.checkState((node2.getType() == 118 || node2.getType() == 105 || node2.getType() == 83 && node3.getType() == 105 ? 1 : 0) != 0, (Object)"We should only declare vars and functions and function args");
            if (node2.getType() == 83 && node3.getType() == 105) continue;
            if (NodeUtil.isFunctionExpression(node2)) {
                if (this.preserveFunctionExpressionNames) continue;
                node2.getFirstChild().setString("");
                this.compiler.reportCodeChange();
                continue;
            }
            if (node3 != null && node3.getType() == 115 && node3.getChildCount() < 4) continue;
            if (node2.getType() == 118 && node.hasChildren() && NodeUtil.mayHaveSideEffects(node.getFirstChild())) {
                if (node2.getChildCount() != 1) continue;
                node3.replaceChild(node2, new Node(130, node.removeFirstChild()));
                this.compiler.reportCodeChange();
                continue;
            }
            if (node2.getType() == 118 && node2.getChildCount() > 1) {
                node2.removeChild(node);
                this.compiler.reportCodeChange();
                continue;
            }
            if (node3 == null) continue;
            NodeUtil.removeChild(node3, node2);
            this.compiler.reportCodeChange();
        }
    }

    private static class Assign {
        final Node assignNode;
        final Node nameNode;
        final boolean isPropertyAssign;
        final boolean mayHaveSecondarySideEffects;

        Assign(Node node, Node node2, boolean bl) {
            Preconditions.checkState((boolean)NodeUtil.isAssignmentOp(node));
            this.assignNode = node;
            this.nameNode = node2;
            this.isPropertyAssign = bl;
            this.mayHaveSecondarySideEffects = node.getParent().getType() != 130 || NodeUtil.mayHaveSideEffects(node.getFirstChild()) || NodeUtil.mayHaveSideEffects(node.getLastChild());
        }

        static Assign maybeCreateAssign(Node node) {
            Preconditions.checkState((boolean)NodeUtil.isAssignmentOp(node));
            boolean bl = false;
            Node node2 = node.getFirstChild();
            if (NodeUtil.isGet(node2)) {
                node2 = node2.getFirstChild();
                bl = true;
                if (node2.getType() == 33 && node2.getLastChild().getString().equals("prototype")) {
                    node2 = node2.getFirstChild();
                }
            }
            if (node2.getType() == 38) {
                return new Assign(node, node2, bl);
            }
            return null;
        }

        void remove() {
            Node node = this.assignNode.getParent();
            if (this.mayHaveSecondarySideEffects) {
                Node node2 = this.assignNode.getLastChild().detachFromParent();
                Node node3 = this.assignNode.getFirstChild();
                while (node3.getType() != 38) {
                    if (node3.getType() == 35) {
                        node2 = new Node(85, node3.getLastChild().detachFromParent(), node2);
                        node2.copyInformationFrom(node3);
                    }
                    node3 = node3.getFirstChild();
                }
                node.replaceChild(this.assignNode, node2);
            } else {
                Node node4 = node.getParent();
                if (node.getType() == 130) {
                    node4.removeChild(node);
                } else {
                    node.replaceChild(this.assignNode, this.assignNode.getLastChild().detachFromParent());
                }
            }
        }
    }

    private class Continuation {
        private final Node node;
        private final Scope scope;

        Continuation(Node node, Scope scope) {
            this.node = node;
            this.scope = scope;
        }

        void apply() {
            if (NodeUtil.isFunctionDeclaration(this.node)) {
                RemoveUnusedVars.this.traverseFunction(this.node, this.scope);
            } else {
                for (Node node = this.node.getFirstChild(); node != null; node = node.getNext()) {
                    RemoveUnusedVars.this.traverseNode(node, this.node, this.scope);
                }
            }
        }
    }

    private static class CallSiteOptimizer {
        private final AbstractCompiler compiler;
        private final SimpleDefinitionFinder defFinder;

        CallSiteOptimizer(AbstractCompiler abstractCompiler, SimpleDefinitionFinder simpleDefinitionFinder) {
            this.compiler = abstractCompiler;
            this.defFinder = simpleDefinitionFinder;
        }

        public void optimize(Scope scope, Set<Scope.Var> set) {
            Node node = scope.getRootNode();
            Preconditions.checkState((node.getType() == 105 ? 1 : 0) != 0);
            Node node2 = RemoveUnusedVars.getFunctionArgList(node);
            boolean bl = this.canChangeSignature(node);
            this.removeUnreferencedFunctionArgs(scope, node, set, node2.getFirstChild(), 0, bl);
        }

        private boolean removeUnreferencedFunctionArgs(Scope scope, Node node, Set<Scope.Var> set, Node node2, int n, boolean bl) {
            if (node2 != null) {
                boolean bl2 = this.removeUnreferencedFunctionArgs(scope, node, set, node2.getNext(), n + 1, bl);
                Scope.Var var = scope.getVar(node2.getString());
                if (!set.contains(var)) {
                    boolean bl3;
                    Preconditions.checkNotNull((Object)var);
                    boolean bl4 = bl3 = bl || !bl2;
                    if (bl3) {
                        bl3 = this.canRemoveArgFromCallSites(node, n);
                    }
                    this.tryRemoveArgFromCallSites(node, n, bl3);
                    if (bl3 || !bl2) {
                        RemoveUnusedVars.getFunctionArgList(node).removeChild(node2);
                        this.compiler.reportCodeChange();
                        return bl2;
                    }
                }
                return true;
            }
            this.tryRemoveAllFollowingArgs(node, n - 1);
            return false;
        }

        private boolean canRemoveArgFromCallSites(Node node, int n) {
            DefinitionsRemover.Definition definition = this.getFunctionDefinition(node);
            for (UseSite useSite : this.defFinder.getUseSites(definition)) {
                if (CallSiteOptimizer.isModifableCallSite(useSite)) {
                    Node node2 = NodeUtil.getArgumentForCallOrNew(useSite.node.getParent(), n);
                    if (node2 == null || !NodeUtil.mayHaveSideEffects(node2, this.compiler)) continue;
                    return false;
                }
                return false;
            }
            return true;
        }

        private void tryRemoveArgFromCallSites(Node node, int n, boolean bl) {
            DefinitionsRemover.Definition definition = this.getFunctionDefinition(node);
            for (UseSite useSite : this.defFinder.getUseSites(definition)) {
                Node node2;
                if (!CallSiteOptimizer.isModifableCallSite(useSite) || (node2 = NodeUtil.getArgumentForCallOrNew(useSite.node.getParent(), n)) == null) continue;
                Node node3 = node2.getParent();
                if (bl || node2.getNext() == null && !NodeUtil.mayHaveSideEffects(node2, this.compiler)) {
                    node3.removeChild(node2);
                    this.compiler.reportCodeChange();
                    continue;
                }
                if (NodeUtil.mayHaveSideEffects(node2, this.compiler) || node2.getType() == 39 && node2.getDouble() == 0.0) continue;
                node3.replaceChild(node2, Node.newNumber(0.0).copyInformationFrom(node2));
                this.compiler.reportCodeChange();
            }
        }

        private void tryRemoveAllFollowingArgs(Node node, int n) {
            DefinitionsRemover.Definition definition = this.getFunctionDefinition(node);
            for (UseSite useSite : this.defFinder.getUseSites(definition)) {
                if (!CallSiteOptimizer.isModifableCallSite(useSite)) continue;
                Node node2 = NodeUtil.getArgumentForCallOrNew(useSite.node.getParent(), n);
                while (node2 != null) {
                    Node node3 = node2.getNext();
                    if (node3 != null && !NodeUtil.mayHaveSideEffects(node3)) {
                        node2.getParent().removeChildAfter(node2);
                        this.compiler.reportCodeChange();
                        continue;
                    }
                    node2 = node3;
                }
            }
        }

        boolean canModifyCallers(Node node) {
            if (NodeUtil.isVarArgsFunction(node)) {
                return false;
            }
            DefinitionSite definitionSite = this.defFinder.getDefinitionForFunction(node);
            if (definitionSite == null) {
                return false;
            }
            DefinitionsRemover.Definition definition = definitionSite.definition;
            if (!SimpleDefinitionFinder.isSimpleFunctionDeclaration(node)) {
                return false;
            }
            if (SimpleDefinitionFinder.maybeExported(this.compiler, definition)) {
                return false;
            }
            Collection<UseSite> collection = this.defFinder.getUseSites(definition);
            for (UseSite useSite : collection) {
                Node node2 = useSite.node;
                Collection<DefinitionsRemover.Definition> collection2 = this.defFinder.getDefinitionsReferencedAt(node2);
                if (collection2.size() > 1) {
                    return false;
                }
                Preconditions.checkState((!collection2.isEmpty() ? 1 : 0) != 0);
                Preconditions.checkState((boolean)collection2.contains(definition));
            }
            return true;
        }

        private static boolean isModifableCallSite(UseSite useSite) {
            return SimpleDefinitionFinder.isCallOrNewSite(useSite) && !NodeUtil.isFunctionObjectCallOrApply(useSite.node.getParent());
        }

        private boolean canChangeSignature(Node node) {
            DefinitionsRemover.Definition definition = this.getFunctionDefinition(node);
            Preconditions.checkState((!definition.isExtern() ? 1 : 0) != 0);
            Collection<UseSite> collection = this.defFinder.getUseSites(definition);
            for (UseSite useSite : collection) {
                if (!SimpleDefinitionFinder.isCallOrNewSite(useSite)) {
                    return false;
                }
                if (NodeUtil.isFunctionObjectCallOrApply(useSite.node.getParent())) {
                    return false;
                }
                Node node2 = useSite.node;
                Collection<DefinitionsRemover.Definition> collection2 = this.defFinder.getDefinitionsReferencedAt(node2);
                Preconditions.checkState((collection2.size() == 1 ? 1 : 0) != 0);
                Preconditions.checkState((boolean)collection2.contains(definition));
            }
            return true;
        }

        private DefinitionsRemover.Definition getFunctionDefinition(Node node) {
            DefinitionSite definitionSite = this.defFinder.getDefinitionForFunction(node);
            Preconditions.checkNotNull((Object)definitionSite);
            DefinitionsRemover.Definition definition = definitionSite.definition;
            Preconditions.checkState((!definitionSite.inExterns ? 1 : 0) != 0);
            Preconditions.checkState((definition.getRValue() == node ? 1 : 0) != 0);
            return definition;
        }
    }
}

