/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.Compiler;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.JSSourceFile;
import com.google.javascript.jscomp.JsAst;
import com.google.javascript.jscomp.JsMessage;
import com.google.javascript.jscomp.JsMessageDefinition;
import com.google.javascript.jscomp.JsMessageVisitor;
import com.google.javascript.jscomp.LightweightMessageFormatter;
import com.google.javascript.rhino.Node;
import java.io.IOException;
import java.util.Collection;
import java.util.List;

public class JsMessageExtractor {
    private final JsMessage.Style style;
    private final JsMessage.IdGenerator idGenerator;

    public JsMessageExtractor(JsMessage.IdGenerator idGenerator, JsMessage.Style style) {
        this.idGenerator = idGenerator;
        this.style = style;
    }

    public Collection<JsMessage> extractMessages(JSSourceFile ... jSSourceFileArray) throws IOException {
        return this.extractMessages((Iterable<JSSourceFile>)ImmutableList.copyOf((Object[])jSSourceFileArray));
    }

    public Collection<JsMessage> extractMessages(Iterable<JSSourceFile> iterable) throws IOException {
        Object object;
        Compiler compiler = new Compiler();
        compiler.init(new JSSourceFile[0], (JSSourceFile[])Iterables.toArray(iterable, JSSourceFile.class), new CompilerOptions());
        ExtractMessagesVisitor extractMessagesVisitor = new ExtractMessagesVisitor(compiler);
        for (JSSourceFile object2 : iterable) {
            object = new JsAst(object2).getAstRoot(compiler);
            extractMessagesVisitor.process(null, (Node)object);
        }
        JSError[] jSErrorArray = compiler.getErrors();
        if (jSErrorArray.length > 0) {
            StringBuilder stringBuilder = new StringBuilder("JSCompiler errors\n");
            object = new LightweightMessageFormatter(compiler);
            for (JSError jSError : jSErrorArray) {
                stringBuilder.append(object.formatError(jSError));
            }
            throw new RuntimeException(stringBuilder.toString());
        }
        return extractMessagesVisitor.getMessages();
    }

    private class ExtractMessagesVisitor
    extends JsMessageVisitor {
        private final List<JsMessage> messages;

        private ExtractMessagesVisitor(AbstractCompiler abstractCompiler) {
            super(abstractCompiler, true, JsMessageExtractor.this.style, JsMessageExtractor.this.idGenerator);
            this.messages = Lists.newLinkedList();
        }

        @Override
        protected void processJsMessage(JsMessage jsMessage, JsMessageDefinition jsMessageDefinition) {
            if (!jsMessage.isExternal()) {
                this.messages.add(jsMessage);
            }
        }

        public Collection<JsMessage> getMessages() {
            return this.messages;
        }
    }
}

