/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.ControlFlowGraph;
import com.google.javascript.jscomp.DefinitionsRemover;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.SimpleDefinitionFinder;
import com.google.javascript.jscomp.graph.DiGraph;
import com.google.javascript.rhino.Node;
import java.util.Collection;
import java.util.List;
import java.util.Set;

class ChainCalls
implements CompilerPass {
    private final AbstractCompiler compiler;
    private final Set<Node> badFunctionNodes = Sets.newHashSet();
    private final Set<Node> goodFunctionNodes = Sets.newHashSet();
    private final List<CallSite> callSites = Lists.newArrayList();
    private SimpleDefinitionFinder defFinder;
    private GatherFunctions gatherFunctions = new GatherFunctions();

    ChainCalls(AbstractCompiler abstractCompiler) {
        this.compiler = abstractCompiler;
    }

    @Override
    public void process(Node node, Node node2) {
        this.defFinder = new SimpleDefinitionFinder(this.compiler);
        this.defFinder.process(node, node2);
        NodeTraversal.traverse(this.compiler, node2, new GatherCallSites());
        for (CallSite callSite : this.callSites) {
            callSite.parent.removeChild(callSite.n);
            callSite.n.removeChild(callSite.callNode);
            callSite.nextGetPropNode.replaceChild(callSite.nextGetPropFirstChildNode, callSite.callNode);
            this.compiler.reportCodeChange();
        }
    }

    private static class CallSite {
        final Node parent;
        final Node n;
        final Node callNode;
        final Node nextGetPropNode;
        final Node nextGetPropFirstChildNode;

        CallSite(Node node, Node node2, Node node3, Node node4, Node node5) {
            this.parent = node;
            this.n = node2;
            this.callNode = node3;
            this.nextGetPropNode = node4;
            this.nextGetPropFirstChildNode = node5;
        }
    }

    private class GatherCallSites
    extends NodeTraversal.AbstractPostOrderCallback {
        private GatherCallSites() {
        }

        @Override
        public void visit(NodeTraversal nodeTraversal, Node node, Node node2) {
            Node node3;
            if (!NodeUtil.isExpressionNode(node)) {
                return;
            }
            Node node4 = node.getFirstChild();
            if (node4.getType() != 37) {
                return;
            }
            Node node5 = node4.getFirstChild();
            if (node5.getType() != 33) {
                return;
            }
            Node node6 = node5.getFirstChild();
            Collection<DefinitionsRemover.Definition> collection = ChainCalls.this.defFinder.getDefinitionsReferencedAt(node5);
            if (collection == null) {
                return;
            }
            for (DefinitionsRemover.Definition object2 : collection) {
                node3 = object2.getRValue();
                if (node3 == null) {
                    return;
                }
                if (ChainCalls.this.badFunctionNodes.contains(node3)) {
                    return;
                }
                if (ChainCalls.this.goodFunctionNodes.contains(node3)) continue;
                NodeTraversal.traverse(ChainCalls.this.compiler, node3, ChainCalls.this.gatherFunctions);
                if (!ChainCalls.this.badFunctionNodes.contains(node3)) continue;
                return;
            }
            Node node7 = node.getNext();
            if (node7 == null || node7.getType() != 130) {
                return;
            }
            Node node8 = node7.getFirstChild();
            if (node8.getType() != 37) {
                return;
            }
            node3 = node8.getFirstChild();
            if (node3.getType() != 33) {
                return;
            }
            Node node9 = node3.getFirstChild();
            if (!ChainCalls.this.compiler.areNodesEqualForInlining(node9, node6)) {
                return;
            }
            if (NodeUtil.mayEffectMutableState(node6)) {
                return;
            }
            ChainCalls.this.callSites.add(new CallSite(node2, node, node4, node3, node9));
        }
    }

    private class GatherFunctions
    implements NodeTraversal.ScopedCallback {
        private GatherFunctions() {
        }

        @Override
        public void enterScope(NodeTraversal nodeTraversal) {
            ControlFlowGraph<Node> controlFlowGraph = nodeTraversal.getControlFlowGraph();
            for (DiGraph.DiGraphEdge<Node, ControlFlowGraph.Branch> diGraphEdge : controlFlowGraph.getImplicitReturn().getInEdges()) {
                Node node = (Node)diGraphEdge.getSource().getValue();
                if (node.getType() == 4 && node.getFirstChild() != null && node.getFirstChild().getType() == 42) continue;
                ChainCalls.this.badFunctionNodes.add(nodeTraversal.getScopeRoot());
                return;
            }
            ChainCalls.this.goodFunctionNodes.add(nodeTraversal.getScopeRoot());
        }

        @Override
        public void exitScope(NodeTraversal nodeTraversal) {
        }

        @Override
        public boolean shouldTraverse(NodeTraversal nodeTraversal, Node node, Node node2) {
            return true;
        }

        @Override
        public void visit(NodeTraversal nodeTraversal, Node node, Node node2) {
        }
    }
}

