/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.AnonymousFunctionNamingCallback;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.NodeNameExtractor;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.rhino.Node;
import java.util.logging.Logger;

class NameAnonymousFunctions
implements CompilerPass {
    private static final Logger logger = Logger.getLogger(NameAnonymousFunctions.class.getName());
    static final char DELIMITER = '$';
    private final AbstractCompiler compiler;
    private int namedCount = 0;
    private int bytesUsed = 0;

    NameAnonymousFunctions(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node root) {
        AnonymousFunctionNamingCallback namingCallback = new AnonymousFunctionNamingCallback(new AnonymousFunctionNamer());
        NodeTraversal.traverse(this.compiler, root, namingCallback);
        logger.fine("Named " + this.namedCount + " anon functions using " + this.bytesUsed + " bytes");
    }

    private class AnonymousFunctionNamer
    implements AnonymousFunctionNamingCallback.FunctionNamer {
        private NodeNameExtractor nameExtractor = new NodeNameExtractor('$');

        AnonymousFunctionNamer() {
        }

        private String getLikelyNonConflictingName(String name) {
            return '$' + name + '$';
        }

        @Override
        public final String getName(Node node) {
            return this.nameExtractor.getName(node);
        }

        @Override
        public final void setFunctionName(String name, Node fnNode) {
            Node fnNameNode = fnNode.getFirstChild();
            String uniqueName = this.getLikelyNonConflictingName(name);
            fnNameNode.setString(uniqueName);
            NameAnonymousFunctions.this.compiler.reportCodeChange();
            NameAnonymousFunctions.this.namedCount++;
            NameAnonymousFunctions.this.bytesUsed += uniqueName.length();
        }

        @Override
        public final String getCombinedName(String lhs, String rhs) {
            return lhs + '$' + rhs;
        }
    }
}

