/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino.jstype;

import com.google.javascript.rhino.ErrorReporter;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.ObjectType;
import com.google.javascript.rhino.jstype.StaticScope;
import com.google.javascript.rhino.jstype.TernaryValue;
import com.google.javascript.rhino.jstype.Visitor;
import java.util.Set;

public class EnumElementType
extends ObjectType {
    private static final long serialVersionUID = 1L;
    private JSType primitiveType;
    private ObjectType primitiveObjectType;
    private final String name;

    EnumElementType(JSTypeRegistry registry, JSType elementType, String name) {
        super(registry);
        this.primitiveType = elementType;
        this.primitiveObjectType = elementType.toObjectType();
        this.name = name;
    }

    @Override
    public ObjectType.Property getSlot(String name) {
        if (this.primitiveObjectType != null) {
            return this.primitiveObjectType.getSlot(name);
        }
        return null;
    }

    @Override
    public EnumElementType toMaybeEnumElementType() {
        return this;
    }

    @Override
    public boolean matchesNumberContext() {
        return this.primitiveType.matchesNumberContext();
    }

    @Override
    public boolean matchesStringContext() {
        return this.primitiveType.matchesStringContext();
    }

    @Override
    public boolean matchesObjectContext() {
        return this.primitiveType.matchesObjectContext();
    }

    @Override
    public boolean canBeCalled() {
        return this.primitiveType.canBeCalled();
    }

    @Override
    public boolean isObject() {
        return this.primitiveType.isObject();
    }

    @Override
    public TernaryValue testForEquality(JSType that) {
        return this.primitiveType.testForEquality(that);
    }

    @Override
    public boolean isNullable() {
        return this.primitiveType.isNullable();
    }

    @Override
    public boolean isNominalType() {
        return this.hasReferenceName();
    }

    @Override
    public boolean isEquivalentTo(JSType that) {
        ObjectType thatObj;
        if (this == that) {
            return true;
        }
        if (this.isNominalType() && (thatObj = ObjectType.cast(that)) != null && thatObj.isNominalType()) {
            return this.getReferenceName().equals(thatObj.getReferenceName());
        }
        return false;
    }

    @Override
    public int hashCode() {
        if (this.hasReferenceName()) {
            return this.getReferenceName().hashCode();
        }
        return super.hashCode();
    }

    @Override
    String toStringHelper(boolean forAnnotations) {
        return forAnnotations ? this.primitiveType.toString() : this.getReferenceName() + ".<" + this.primitiveType + ">";
    }

    @Override
    public String getReferenceName() {
        return this.name;
    }

    @Override
    public boolean hasReferenceName() {
        return true;
    }

    @Override
    public boolean isSubtype(JSType that) {
        if (JSType.isSubtypeHelper(this, that)) {
            return true;
        }
        return this.primitiveType.isSubtype(that);
    }

    @Override
    public <T> T visit(Visitor<T> visitor) {
        return visitor.caseEnumElementType(this);
    }

    @Override
    boolean defineProperty(String propertyName, JSType type, boolean inferred, Node propertyNode) {
        return true;
    }

    @Override
    public boolean isPropertyTypeDeclared(String propertyName) {
        return this.primitiveObjectType == null ? false : this.primitiveObjectType.isPropertyTypeDeclared(propertyName);
    }

    @Override
    public boolean isPropertyTypeInferred(String propertyName) {
        return this.primitiveObjectType == null ? false : this.primitiveObjectType.isPropertyTypeInferred(propertyName);
    }

    @Override
    public ObjectType getImplicitPrototype() {
        return null;
    }

    @Override
    public int getPropertiesCount() {
        return this.primitiveObjectType == null ? 0 : this.primitiveObjectType.getPropertiesCount();
    }

    @Override
    void collectPropertyNames(Set<String> props) {
        if (this.primitiveObjectType != null) {
            this.primitiveObjectType.collectPropertyNames(props);
        }
    }

    @Override
    public JSType findPropertyType(String propertyName) {
        return this.primitiveType.findPropertyType(propertyName);
    }

    @Override
    public JSType getPropertyType(String propertyName) {
        return this.primitiveObjectType == null ? this.getNativeType(JSTypeNative.UNKNOWN_TYPE) : this.primitiveObjectType.getPropertyType(propertyName);
    }

    @Override
    public boolean hasProperty(String propertyName) {
        return this.primitiveObjectType == null ? false : this.primitiveObjectType.hasProperty(propertyName);
    }

    @Override
    public FunctionType getConstructor() {
        return this.primitiveObjectType == null ? null : this.primitiveObjectType.getConstructor();
    }

    @Override
    public JSType autoboxesTo() {
        return this.primitiveType.autoboxesTo();
    }

    public JSType getPrimitiveType() {
        return this.primitiveType;
    }

    JSType meet(JSType that) {
        JSType meetPrimitive = this.primitiveType.getGreatestSubtype(that);
        if (meetPrimitive.isEmptyType()) {
            return null;
        }
        return new EnumElementType(this.registry, meetPrimitive, this.name);
    }

    @Override
    JSType resolveInternal(ErrorReporter t, StaticScope<JSType> scope) {
        this.primitiveType = this.primitiveType.resolve(t, scope);
        this.primitiveObjectType = ObjectType.cast(this.primitiveType);
        return this;
    }
}

