/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.javascript.jscomp.JoinOp;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.type.FlowScope;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.SimpleSlot;
import com.google.javascript.rhino.jstype.StaticScope;
import com.google.javascript.rhino.jstype.StaticSlot;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

class LinkedFlowScope
implements FlowScope {
    private final FlatFlowScopeCache cache;
    private final LinkedFlowScope parent;
    private int depth;
    static final int MAX_DEPTH = 250;
    private FlatFlowScopeCache flattened;
    private boolean frozen = false;
    private LinkedFlowSlot lastSlot;

    private LinkedFlowScope(FlatFlowScopeCache cache, LinkedFlowScope directParent) {
        this.cache = cache;
        if (directParent == null) {
            this.lastSlot = null;
            this.depth = 0;
            this.parent = cache.linkedEquivalent;
        } else {
            this.lastSlot = directParent.lastSlot;
            this.depth = directParent.depth + 1;
            this.parent = directParent;
        }
    }

    LinkedFlowScope(FlatFlowScopeCache cache) {
        this(cache, null);
    }

    LinkedFlowScope(LinkedFlowScope directParent) {
        this(directParent.cache, directParent);
    }

    private Scope getFunctionScope() {
        return this.cache.functionScope;
    }

    private boolean flowsFromBottom() {
        return this.getFunctionScope().isBottom();
    }

    public static LinkedFlowScope createEntryLattice(Scope scope) {
        return new LinkedFlowScope(new FlatFlowScopeCache(scope));
    }

    @Override
    public void inferSlotType(String symbol, JSType type) {
        Preconditions.checkState((!this.frozen ? 1 : 0) != 0);
        this.lastSlot = new LinkedFlowSlot(symbol, type, this.lastSlot);
        ++this.depth;
        this.cache.dirtySymbols.add(symbol);
    }

    @Override
    public void inferQualifiedSlot(Node node, String symbol, JSType bottomType, JSType inferredType) {
        Scope functionScope = this.getFunctionScope();
        if (functionScope.isLocal()) {
            if (functionScope.getVar(symbol) == null && !functionScope.isBottom()) {
                functionScope.declare(symbol, node, bottomType, null);
            }
            this.inferSlotType(symbol, inferredType);
        }
    }

    @Override
    public JSType getTypeOfThis() {
        return this.cache.functionScope.getTypeOfThis();
    }

    @Override
    public Node getRootNode() {
        return this.getFunctionScope().getRootNode();
    }

    @Override
    public StaticScope<JSType> getParentScope() {
        return this.getFunctionScope().getParentScope();
    }

    @Override
    public StaticSlot<JSType> getSlot(String name) {
        if (this.cache.dirtySymbols.contains(name)) {
            LinkedFlowSlot slot = this.lastSlot;
            while (slot != null) {
                if (slot.getName().equals(name)) {
                    return slot;
                }
                slot = slot.parent;
            }
        }
        return this.cache.getSlot(name);
    }

    @Override
    public StaticSlot<JSType> getOwnSlot(String name) {
        throw new UnsupportedOperationException();
    }

    @Override
    public FlowScope createChildFlowScope() {
        this.frozen = true;
        if (this.depth > 250) {
            if (this.flattened == null) {
                this.flattened = new FlatFlowScopeCache(this);
            }
            return new LinkedFlowScope(this.flattened);
        }
        return new LinkedFlowScope(this);
    }

    @Override
    public StaticSlot<JSType> findUniqueRefinedSlot(FlowScope blindScope) {
        LinkedFlowSlot result = null;
        LinkedFlowScope currentScope = this;
        while (currentScope != blindScope) {
            LinkedFlowSlot currentSlot = currentScope.lastSlot;
            while (currentSlot != null && (currentScope.parent == null || currentScope.parent.lastSlot != currentSlot)) {
                if (result == null) {
                    result = currentSlot;
                } else if (!currentSlot.getName().equals(result.getName())) {
                    return null;
                }
                currentSlot = currentSlot.parent;
            }
            currentScope = currentScope.parent;
        }
        return result;
    }

    @Override
    public void completeScope(StaticScope<JSType> staticScope) {
        Scope scope = (Scope)staticScope;
        Iterator<Scope.Var> it = scope.getVars();
        while (it.hasNext()) {
            JSType type;
            Scope.Var var = it.next();
            if (!var.isTypeInferred() || (type = var.getType()) != null && !type.isUnknownType()) continue;
            JSType flowType = this.getSlot(var.getName()).getType();
            var.setType(flowType);
        }
    }

    @Override
    public LinkedFlowScope optimize() {
        LinkedFlowScope current = this;
        while (current.parent != null && current.lastSlot == current.parent.lastSlot) {
            current = current.parent;
        }
        return current;
    }

    public boolean equals(Object other) {
        if (other instanceof LinkedFlowScope) {
            LinkedFlowScope that = (LinkedFlowScope)other;
            if (this.optimize() == that.optimize()) {
                return true;
            }
            if (this.getFunctionScope() != that.getFunctionScope()) {
                return false;
            }
            if (this.cache == that.cache) {
                for (String name : this.cache.dirtySymbols) {
                    if (!this.diffSlots(this.getSlot(name), that.getSlot(name))) continue;
                    return false;
                }
                return true;
            }
            Map<String, StaticSlot<JSType>> myFlowSlots = this.allFlowSlots();
            Map<String, StaticSlot<JSType>> otherFlowSlots = that.allFlowSlots();
            for (StaticSlot<JSType> slot : myFlowSlots.values()) {
                if (this.diffSlots(slot, otherFlowSlots.get(slot.getName()))) {
                    return false;
                }
                otherFlowSlots.remove(slot.getName());
            }
            for (StaticSlot<JSType> slot : otherFlowSlots.values()) {
                if (!this.diffSlots(slot, myFlowSlots.get(slot.getName()))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean diffSlots(StaticSlot<JSType> slotA, StaticSlot<JSType> slotB) {
        boolean bIsNull;
        boolean aIsNull = slotA == null || slotA.getType() == null;
        boolean bl = bIsNull = slotB == null || slotB.getType() == null;
        if (aIsNull && bIsNull) {
            return false;
        }
        if (aIsNull ^ bIsNull) {
            return true;
        }
        return slotA.getType().differsFrom(slotB.getType());
    }

    private Map<String, StaticSlot<JSType>> allFlowSlots() {
        HashMap slots = Maps.newHashMap();
        LinkedFlowSlot slot = this.lastSlot;
        while (slot != null) {
            if (!slots.containsKey(slot.getName())) {
                slots.put(slot.getName(), slot);
            }
            slot = slot.parent;
        }
        for (Map.Entry symbolEntry : this.cache.symbols.entrySet()) {
            if (slots.containsKey(symbolEntry.getKey())) continue;
            slots.put(symbolEntry.getKey(), symbolEntry.getValue());
        }
        return slots;
    }

    private static class FlatFlowScopeCache {
        private final Scope functionScope;
        private final LinkedFlowScope linkedEquivalent;
        private Map<String, StaticSlot<JSType>> symbols = Maps.newHashMap();
        final Set<String> dirtySymbols = Sets.newHashSet();

        FlatFlowScopeCache(Scope functionScope) {
            this.functionScope = functionScope;
            this.symbols = ImmutableMap.of();
            this.linkedEquivalent = null;
        }

        FlatFlowScopeCache(LinkedFlowScope directParent) {
            FlatFlowScopeCache cache = directParent.cache;
            this.functionScope = cache.functionScope;
            this.symbols = directParent.allFlowSlots();
            this.linkedEquivalent = directParent;
        }

        FlatFlowScopeCache(LinkedFlowScope joinedScopeA, LinkedFlowScope joinedScopeB) {
            this.linkedEquivalent = null;
            this.functionScope = joinedScopeA.flowsFromBottom() ? joinedScopeB.getFunctionScope() : joinedScopeA.getFunctionScope();
            Map slotsA = joinedScopeA.allFlowSlots();
            Map slotsB = joinedScopeB.allFlowSlots();
            this.symbols = slotsA;
            HashSet symbolNames = Sets.newHashSet(this.symbols.keySet());
            symbolNames.addAll(slotsB.keySet());
            for (String name : symbolNames) {
                JSType fnSlotType;
                StaticSlot<JSType> fnSlot;
                StaticSlot slotA = (StaticSlot)slotsA.get(name);
                StaticSlot slotB = (StaticSlot)slotsB.get(name);
                JSType joinedType = null;
                if (slotB == null || slotB.getType() == null) {
                    fnSlot = joinedScopeB.getFunctionScope().getSlot(name);
                    JSType jSType = fnSlotType = fnSlot == null ? null : fnSlot.getType();
                    if (fnSlotType != null) {
                        joinedType = ((JSType)slotA.getType()).getLeastSupertype(fnSlotType);
                    }
                } else if (slotA == null || slotA.getType() == null) {
                    fnSlot = joinedScopeA.getFunctionScope().getSlot(name);
                    JSType jSType = fnSlotType = fnSlot == null ? null : fnSlot.getType();
                    if (fnSlotType == null) {
                        this.symbols.put(name, slotB);
                    } else {
                        joinedType = ((JSType)slotB.getType()).getLeastSupertype(fnSlotType);
                    }
                } else {
                    joinedType = ((JSType)slotA.getType()).getLeastSupertype((JSType)slotB.getType());
                }
                if (joinedType == null) continue;
                this.symbols.put(name, new SimpleSlot(name, joinedType, true));
            }
        }

        public StaticSlot<JSType> getSlot(String name) {
            if (this.symbols.containsKey(name)) {
                return this.symbols.get(name);
            }
            return this.functionScope.getSlot(name);
        }
    }

    private static class LinkedFlowSlot
    extends SimpleSlot {
        final LinkedFlowSlot parent;

        LinkedFlowSlot(String name, JSType type, LinkedFlowSlot parent) {
            super(name, type, true);
            this.parent = parent;
        }
    }

    static class FlowScopeJoinOp
    extends JoinOp.BinaryJoinOp<FlowScope> {
        FlowScopeJoinOp() {
        }

        @Override
        public FlowScope apply(FlowScope a, FlowScope b) {
            LinkedFlowScope linkedA = (LinkedFlowScope)a;
            LinkedFlowScope linkedB = (LinkedFlowScope)b;
            linkedA.frozen = true;
            linkedB.frozen = true;
            if (linkedA.optimize() == linkedB.optimize()) {
                return linkedA.createChildFlowScope();
            }
            return new LinkedFlowScope(new FlatFlowScopeCache(linkedA, linkedB));
        }
    }
}

