/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.rpc.impl;

import com.google.gwt.user.client.rpc.SerializationException;
import com.google.gwt.user.client.rpc.SerializationStreamWriter;
import com.google.gwt.user.client.rpc.impl.AbstractSerializationStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractSerializationStreamWriter
extends AbstractSerializationStream
implements SerializationStreamWriter {
    private static final double TWO_PWR_16_DBL = 65536.0;
    private static final double TWO_PWR_32_DBL = 4.294967296E9;
    private int objectCount;
    private Map<Object, Integer> objectMap = new IdentityHashMap<Object, Integer>();
    private Map<String, Integer> stringMap = new HashMap<String, Integer>();
    private List<String> stringTable = new ArrayList<String>();

    public static double[] getAsDoubleArray(long value) {
        int lowBits = (int)(value & 0xFFFFFFFFFFFFFFFFL);
        int highBits = (int)(value >> 32);
        return AbstractSerializationStreamWriter.makeLongComponents(lowBits, highBits);
    }

    protected static double[] makeLongComponents(int lowBits, int highBits) {
        double high = (double)highBits * 4.294967296E9;
        double low = lowBits;
        if (lowBits < 0) {
            low += 4.294967296E9;
        }
        return new double[]{low, high};
    }

    public void prepareToWrite() {
        this.objectCount = 0;
        this.objectMap.clear();
        this.stringMap.clear();
        this.stringTable.clear();
    }

    @Override
    public abstract String toString();

    @Override
    public void writeBoolean(boolean fieldValue) {
        this.append(fieldValue ? "1" : "0");
    }

    @Override
    public void writeByte(byte fieldValue) {
        this.append(String.valueOf(fieldValue));
    }

    @Override
    public void writeChar(char ch) {
        this.append(String.valueOf((int)ch));
    }

    @Override
    public void writeDouble(double fieldValue) {
        this.append(String.valueOf(fieldValue));
    }

    @Override
    public void writeFloat(float fieldValue) {
        this.writeDouble(fieldValue);
    }

    @Override
    public void writeInt(int fieldValue) {
        this.append(String.valueOf(fieldValue));
    }

    @Override
    public abstract void writeLong(long var1);

    @Override
    public void writeObject(Object instance) throws SerializationException {
        if (instance == null) {
            this.writeString(null);
            return;
        }
        int objIndex = this.getIndexForObject(instance);
        if (objIndex >= 0) {
            this.writeInt(-(objIndex + 1));
            return;
        }
        this.saveIndexForObject(instance);
        String typeSignature = this.getObjectTypeSignature(instance);
        if (typeSignature == null) {
            String string = String.valueOf(instance.getClass());
            throw new SerializationException(new StringBuilder(33 + String.valueOf(string).length()).append("could not get type signature for ").append(string).toString());
        }
        this.writeString(typeSignature);
        this.serialize(instance, typeSignature);
    }

    @Override
    public void writeShort(short value) {
        this.append(String.valueOf(value));
    }

    @Override
    public void writeString(String value) {
        this.writeInt(this.addString(value));
    }

    protected int addString(String string) {
        if (string == null) {
            return 0;
        }
        Integer o = this.stringMap.get(string);
        if (o != null) {
            return o;
        }
        this.stringTable.add(string);
        int index = this.stringTable.size();
        this.stringMap.put(string, index);
        return index;
    }

    protected abstract void append(String var1);

    protected int getIndexForObject(Object instance) {
        return this.objectMap.containsKey(instance) ? this.objectMap.get(instance) : -1;
    }

    protected abstract String getObjectTypeSignature(Object var1) throws SerializationException;

    protected List<String> getStringTable() {
        return this.stringTable;
    }

    protected void saveIndexForObject(Object instance) {
        this.objectMap.put(instance, this.objectCount++);
    }

    protected abstract void serialize(Object var1, String var2) throws SerializationException;
}

