/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.shared.impl.cldr;

// DO NOT EDIT - GENERATED FROM CLDR AND ICU DATA
//  cldrVersion=21.0
//  number=$Revision: 6546 $
//  type=root
//  date=$Date: 2012-02-07 13:32:35 -0500 (Tue, 07 Feb 2012) $

/**
 * Implementation of DateTimeFormatInfo for the "chr" locale.
 */
public class DateTimeFormatInfoImpl_chr extends DateTimeFormatInfoImpl {

  @Override
  public String[] ampms() {
    return new String[] {
        "ᏌᎾᎴ",
        "ᏒᎯᏱᎢᏗᏢ"
    };
  }

  @Override
  public String dateFormatFull() {
    return "EEEE, MMMM d, y";
  }

  @Override
  public String dateFormatLong() {
    return "MMMM d, y";
  }

  @Override
  public String dateFormatMedium() {
    return "MMM d, y";
  }

  @Override
  public String dateFormatShort() {
    return "M/d/yy";
  }

  @Override
  public String[] erasFull() {
    return new String[] {
        "Ꮟ ᏥᏌ ᎾᏕᎲᏍᎬᎾ",
        "ᎠᎩᏃᎮᎵᏓᏍᏗᏱ ᎠᏕᏘᏱᏍᎬ ᏱᎰᏩ ᏧᏓᏂᎸᎢᏍᏗ"
    };
  }

  @Override
  public String[] erasShort() {
    return new String[] {
        "ᎤᏓᎷᎸ",
        "ᎤᎶᏐᏅ"
    };
  }

  @Override
  public int firstDayOfTheWeek() {
    return 0;
  }

  @Override
  public String formatHour24Minute() {
    return "H:mm";
  }

  @Override
  public String formatHour24MinuteSecond() {
    return "H:mm:ss";
  }

  @Override
  public String formatMonthNumDay() {
    return "M/d";
  }

  @Override
  public String formatYearMonthAbbrev() {
    return "MMM y";
  }

  @Override
  public String formatYearMonthAbbrevDay() {
    return "MMM d, y";
  }

  @Override
  public String formatYearMonthFull() {
    return "MMMM y";
  }

  @Override
  public String formatYearMonthFullDay() {
    return "MMMM d, y";
  }

  @Override
  public String formatYearMonthNum() {
    return "M/y";
  }

  @Override
  public String formatYearMonthNumDay() {
    return "M/d/y";
  }

  @Override
  public String formatYearMonthWeekdayDay() {
    return "EEE, MMM d, y";
  }

  @Override
  public String formatYearQuarterFull() {
    return "QQQQ y";
  }

  @Override
  public String formatYearQuarterShort() {
    return "Q y";
  }

  @Override
  public String[] monthsFull() {
    return new String[] {
        "ᎤᏃᎸᏔᏅ",
        "ᎧᎦᎵ",
        "ᎠᏅᏱ",
        "ᎧᏬᏂ",
        "ᎠᏂᏍᎬᏘ",
        "ᏕᎭᎷᏱ",
        "ᎫᏰᏉᏂ",
        "ᎦᎶᏂ",
        "ᏚᎵᏍᏗ",
        "ᏚᏂᏅᏗ",
        "ᏅᏓᏕᏆ",
        "ᎤᏍᎩᏱ"
    };
  }

  @Override
  public String[] monthsNarrow() {
    return new String[] {
        "Ꭴ",
        "Ꭷ",
        "Ꭰ",
        "Ꭷ",
        "Ꭰ",
        "Ꮥ",
        "Ꭻ",
        "Ꭶ",
        "Ꮪ",
        "Ꮪ",
        "Ꮕ",
        "Ꭴ"
    };
  }

  @Override
  public String[] monthsShort() {
    return new String[] {
        "ᎤᏃ",
        "ᎧᎦ",
        "ᎠᏅ",
        "ᎧᏬ",
        "ᎠᏂ",
        "ᏕᎭ",
        "ᎫᏰ",
        "ᎦᎶ",
        "ᏚᎵ",
        "ᏚᏂ",
        "ᏅᏓ",
        "ᎤᏍ"
    };
  }

  @Override
  public String[] quartersFull() {
    return new String[] {
        "Q1",
        "Q2",
        "Q3",
        "Q4"
    };
  }

  @Override
  public String timeFormatFull() {
    return "h:mm:ss a zzzz";
  }

  @Override
  public String timeFormatLong() {
    return "h:mm:ss a z";
  }

  @Override
  public String timeFormatMedium() {
    return "h:mm:ss a";
  }

  @Override
  public String timeFormatShort() {
    return "h:mm a";
  }

  @Override
  public String[] weekdaysFull() {
    return new String[] {
        "ᎤᎾᏙᏓᏆᏍᎬ",
        "ᎤᎾᏙᏓᏉᏅᎯ",
        "ᏔᎵᏁᎢᎦ",
        "ᏦᎢᏁᎢᎦ",
        "ᏅᎩᏁᎢᎦ",
        "ᏧᎾᎩᎶᏍᏗ",
        "ᎤᎾᏙᏓᏈᏕᎾ"
    };
  }

  @Override
  public String[] weekdaysNarrow() {
    return new String[] {
        "Ꮖ",
        "Ꮙ",
        "Ꮤ",
        "Ꮶ",
        "Ꮕ",
        "Ꮷ",
        "Ꭴ"
    };
  }

  @Override
  public String[] weekdaysShort() {
    return new String[] {
        "ᏆᏍᎬ",
        "ᏉᏅᎯ",
        "ᏔᎵᏁ",
        "ᏦᎢᏁ",
        "ᏅᎩᏁ",
        "ᏧᎾᎩ",
        "ᏈᏕᎾ"
    };
  }
}
