/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.cell.client;

import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.ValueUpdater;
import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.i18n.client.LocaleInfo;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.safehtml.client.SafeHtmlTemplates;
import com.google.gwt.safehtml.shared.SafeHtml;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import com.google.gwt.user.client.ui.AbstractImagePrototype;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IconCellDecorator<C>
implements Cell<C> {
    private static final int DEFAULT_SPACING = 6;
    private static Template template;
    private final Cell<C> cell;
    private final String direction;
    private final SafeHtml iconHtml;
    private final int imageWidth;
    private final SafeHtml placeHolderHtml;

    public IconCellDecorator(ImageResource icon, Cell<C> cell) {
        this(icon, cell, HasVerticalAlignment.ALIGN_MIDDLE, 6);
    }

    public IconCellDecorator(ImageResource icon, Cell<C> cell, HasVerticalAlignment.VerticalAlignmentConstant valign, int spacing) {
        String string = this.direction = LocaleInfo.getCurrentLocale().isRTL() ? "right" : "left";
        if (template == null) {
            template = (Template)GWT.create(Template.class);
        }
        this.cell = cell;
        this.iconHtml = this.getImageHtml(icon, valign, false);
        this.imageWidth = icon.getWidth() + spacing;
        this.placeHolderHtml = this.getImageHtml(icon, valign, true);
    }

    @Override
    public boolean dependsOnSelection() {
        return this.cell.dependsOnSelection();
    }

    @Override
    public Set<String> getConsumedEvents() {
        return this.cell.getConsumedEvents();
    }

    @Override
    public boolean handlesSelection() {
        return this.cell.handlesSelection();
    }

    @Override
    public boolean isEditing(Cell.Context context, Element parent, C value) {
        return this.cell.isEditing(context, this.getCellParent(parent), value);
    }

    @Override
    public void onBrowserEvent(Cell.Context context, Element parent, C value, NativeEvent event, ValueUpdater<C> valueUpdater) {
        this.cell.onBrowserEvent(context, this.getCellParent(parent), value, event, valueUpdater);
    }

    @Override
    public void render(Cell.Context context, C value, SafeHtmlBuilder sb) {
        SafeHtmlBuilder cellBuilder = new SafeHtmlBuilder();
        this.cell.render(context, value, cellBuilder);
        sb.append(template.outerDiv(this.direction, this.imageWidth, this.isIconUsed(value) ? this.getIconHtml(value) : this.placeHolderHtml, cellBuilder.toSafeHtml()));
    }

    @Override
    public boolean resetFocus(Cell.Context context, Element parent, C value) {
        return this.cell.resetFocus(context, this.getCellParent(parent), value);
    }

    @Override
    public void setValue(Cell.Context context, Element parent, C value) {
        this.cell.setValue(context, this.getCellParent(parent), value);
    }

    protected SafeHtml getIconHtml(C value) {
        return this.iconHtml;
    }

    protected boolean isIconUsed(C value) {
        return true;
    }

    SafeHtml getImageHtml(ImageResource res, HasVerticalAlignment.VerticalAlignmentConstant valign, boolean isPlaceholder) {
        SafeHtml image;
        if (isPlaceholder) {
            image = SafeHtmlUtils.fromTrustedString("<div></div>");
        } else {
            AbstractImagePrototype proto = AbstractImagePrototype.create(res);
            image = SafeHtmlUtils.fromTrustedString(proto.getHTML());
        }
        if (HasVerticalAlignment.ALIGN_TOP == valign) {
            return template.imageWrapperTop(this.direction, image);
        }
        if (HasVerticalAlignment.ALIGN_BOTTOM == valign) {
            return template.imageWrapperBottom(this.direction, image);
        }
        int halfHeight = (int)Math.round((double)res.getHeight() / 2.0);
        return template.imageWrapperMiddle(this.direction, halfHeight, image);
    }

    private Element getCellParent(Element parent) {
        return (Element)parent.getFirstChildElement().getChild(1).cast();
    }

    static interface Template
    extends SafeHtmlTemplates {
        @SafeHtmlTemplates.Template(value="<div style=\"position:relative;padding-{0}:{1}px;zoom:1;\">{2}<div>{3}</div></div>")
        public SafeHtml outerDiv(String var1, int var2, SafeHtml var3, SafeHtml var4);

        @SafeHtmlTemplates.Template(value="<div style=\"position:absolute;{0}:0px;bottom:0px;line-height:0px;\">{1}</div>")
        public SafeHtml imageWrapperBottom(String var1, SafeHtml var2);

        @SafeHtmlTemplates.Template(value="<div style=\"position:absolute;{0}:0px;top:50%;line-height:0px;margin-top:-{1}px;\">{2}</div>")
        public SafeHtml imageWrapperMiddle(String var1, int var2, SafeHtml var3);

        @SafeHtmlTemplates.Template(value="<div style=\"position:absolute;{0}:0px;top:0px;line-height:0px;\">{1}</div>")
        public SafeHtml imageWrapperTop(String var1, SafeHtml var2);
    }
}

