/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.ui;

import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.IndexedPanel;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.user.client.ui.WidgetCollection;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ComplexPanel
extends Panel
implements IndexedPanel {
    private WidgetCollection children = new WidgetCollection(this);

    @Override
    public Widget getWidget(int index) {
        return this.getChildren().get(index);
    }

    @Override
    public int getWidgetCount() {
        return this.getChildren().size();
    }

    @Override
    public int getWidgetIndex(Widget child) {
        return this.getChildren().indexOf(child);
    }

    @Override
    public Iterator<Widget> iterator() {
        return this.getChildren().iterator();
    }

    @Override
    public boolean remove(int index) {
        return this.remove(this.getWidget(index));
    }

    @Override
    public boolean remove(Widget w) {
        if (w.getParent() != this) {
            return false;
        }
        this.orphan(w);
        Element elem = w.getElement();
        DOM.removeChild(DOM.getParent(elem), elem);
        this.getChildren().remove(w);
        return true;
    }

    protected void add(Widget child, Element container) {
        child.removeFromParent();
        this.getChildren().add(child);
        DOM.appendChild(container, child.getElement());
        this.adopt(child);
    }

    protected int adjustIndex(Widget child, int beforeIndex) {
        int idx;
        this.checkIndexBoundsForInsertion(beforeIndex);
        if (child.getParent() == this && (idx = this.getWidgetIndex(child)) < beforeIndex) {
            --beforeIndex;
        }
        return beforeIndex;
    }

    protected void checkIndexBoundsForAccess(int index) {
        if (index < 0 || index >= this.getWidgetCount()) {
            throw new IndexOutOfBoundsException();
        }
    }

    protected void checkIndexBoundsForInsertion(int index) {
        if (index < 0 || index > this.getWidgetCount()) {
            throw new IndexOutOfBoundsException();
        }
    }

    protected WidgetCollection getChildren() {
        return this.children;
    }

    @Deprecated
    protected void insert(Widget child, Element container, int beforeIndex) {
        if (container == null) {
            throw new NullPointerException("container may not be null");
        }
        this.insert(child, container, beforeIndex, false);
    }

    protected void insert(Widget child, Element container, int beforeIndex, boolean domInsert) {
        beforeIndex = this.adjustIndex(child, beforeIndex);
        child.removeFromParent();
        this.getChildren().insert(child, beforeIndex);
        if (domInsert) {
            DOM.insertChild(container, child.getElement(), beforeIndex);
        } else {
            DOM.appendChild(container, child.getElement());
        }
        this.adopt(child);
    }

    void doLogicalClear() {
        int size = this.children.size();
        for (int i = 0; i < size; ++i) {
            this.orphan(this.children.get(i));
        }
        this.children = new WidgetCollection(this);
    }
}

