/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.facebookapi;

import com.google.code.facebookapi.IPair;
import com.google.code.facebookapi.Pair;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplatizedAction {
    protected static Log log = LogFactory.getLog(TemplatizedAction.class);
    private String titleTemplate;
    private String bodyTemplate;
    private String bodyGeneral;
    private String targetIds;
    private JSONObject titleParams;
    private JSONObject bodyParams;
    private List<IPair<Object, URL>> pictures;
    private Long pageActorId;
    public static final String UID_TOKEN = "http://UID/";

    public TemplatizedAction(String titleTemplate) {
        this.setTitleTemplate(titleTemplate);
        this.titleParams = new JSONObject();
        this.bodyParams = new JSONObject();
        this.bodyTemplate = null;
        this.bodyGeneral = null;
        this.targetIds = null;
        this.pictures = new ArrayList<IPair<Object, URL>>();
        this.pageActorId = null;
    }

    public TemplatizedAction(String titleTemplate, String bodyTemplate) {
        this(titleTemplate);
        this.setBodyTemplate(bodyTemplate);
        this.bodyGeneral = null;
        this.targetIds = null;
    }

    public TemplatizedAction(String titleTemplate, String bodyTemplate, String bodyGeneral) {
        this(titleTemplate, bodyTemplate);
        this.setBodyGeneral(bodyGeneral);
        this.targetIds = null;
    }

    public void removePicture(int index) {
        if (this.pictures == null || index > this.pictures.size()) {
            return;
        }
        this.pictures.remove(index);
    }

    public void addPicture(Long imageUid, String linkHref) {
        this.addPicture(Long.toString(imageUid), linkHref);
    }

    public void addPicture(String imageHref, String linkHref) {
        if (linkHref == null) {
            this.addPicture(imageHref);
        }
        try {
            if (!imageHref.startsWith("http")) {
                imageHref = UID_TOKEN + imageHref;
            }
            this.addPicture(new URL(imageHref), new URL(linkHref));
        }
        catch (Exception ex) {
            log.warn((Object)"Could not add entry for picture!", (Throwable)ex);
        }
    }

    public void addPicture(String imageHref) {
        try {
            if (!imageHref.startsWith("http")) {
                imageHref = UID_TOKEN + imageHref;
            }
            this.addPicture(new URL(imageHref), null);
        }
        catch (Exception ex) {
            log.warn((Object)"Could not add entry for picture!", (Throwable)ex);
        }
    }

    private void addPicture(URL imageUrl, URL linkUrl) {
        if (this.pictures == null) {
            this.pictures = new ArrayList<IPair<Object, URL>>();
        }
        if (this.pictures.size() < 4) {
            this.pictures.add(new Pair<URL, URL>(imageUrl, linkUrl));
        }
    }

    public void setPictures(List<IPair<Object, URL>> pics) {
        if (pics == null || pics.isEmpty()) {
            this.pictures = null;
            return;
        }
        if (pics.size() <= 4) {
            this.pictures = pics;
        }
        if (pics.size() > 4) {
            int count = 0;
            for (IPair<Object, URL> pic : pics) {
                this.pictures.add(pic);
                if (++count != 4) continue;
                break;
            }
        }
    }

    public Collection<IPair<Object, URL>> getPictures() {
        if (this.pictures == null || this.pictures.isEmpty()) {
            return null;
        }
        return this.pictures;
    }

    public void addTitleParam(String key, String value) {
        this.addParam(this.titleParams, key, value);
    }

    public void addBodyParam(String key, String value) {
        this.addParam(this.bodyParams, key, value);
    }

    private void addParam(JSONObject map, String key, String value) {
        if ("actor".equals(key) || "target".equals(key)) {
            throw new RuntimeException(key + " is a reserved token name, you cannot set it yourself!");
        }
        try {
            map.put(key, (Object)value);
        }
        catch (JSONException ex) {
            log.warn((Object)("JSONException for key=" + key + ", value=" + value + "!"), (Throwable)ex);
        }
    }

    public String getTitleParams() {
        return this.getJsonParams(this.titleParams);
    }

    public String getBodyParams() {
        return this.getJsonParams(this.bodyParams);
    }

    private String getJsonParams(JSONObject params) {
        if (params.length() == 0) {
            return null;
        }
        return params.toString();
    }

    public String getBodyGeneral() {
        return this.bodyGeneral;
    }

    public void setBodyGeneral(String bodyGeneral) {
        if ("".equals(bodyGeneral)) {
            bodyGeneral = null;
        }
        this.bodyGeneral = bodyGeneral;
    }

    public String getBodyTemplate() {
        return this.bodyTemplate;
    }

    public void setBodyTemplate(String bodyTemplate) {
        if ("".equals(bodyTemplate)) {
            bodyTemplate = null;
        }
        this.bodyTemplate = bodyTemplate;
    }

    public String getTargetIds() {
        if ("".equals(this.targetIds)) {
            this.targetIds = null;
        }
        return this.targetIds;
    }

    public void setTargetIds(String targetIds) {
        if ("".equals(targetIds)) {
            targetIds = null;
        }
        this.targetIds = targetIds;
    }

    public void addTargetIds(String newIds) {
        if (this.targetIds == null) {
            this.targetIds = "";
        }
        if (!"".equals(this.targetIds)) {
            this.targetIds = this.targetIds + ",";
        }
        this.targetIds = this.targetIds + newIds;
    }

    public void setTargetIds(Collection<Object> facebookIds) {
        if (facebookIds.isEmpty()) {
            this.targetIds = null;
            return;
        }
        this.targetIds = "";
        for (Object current : facebookIds) {
            if (!"".equals(this.targetIds)) {
                this.targetIds = this.targetIds + ",";
            }
            this.targetIds = this.targetIds + current;
        }
    }

    public void addTargetIds(Collection<Object> facebookIds) {
        if (this.targetIds == null) {
            this.targetIds = "";
        }
        for (Object current : facebookIds) {
            if (!"".equals(this.targetIds)) {
                this.targetIds = this.targetIds + ",";
            }
            this.targetIds = this.targetIds + current;
        }
    }

    public String getTitleTemplate() {
        return this.titleTemplate;
    }

    public void setTitleTemplate(String titleTemplate) {
        if (titleTemplate == null) {
            throw new RuntimeException("The title-template cannot be null!");
        }
        if (!titleTemplate.contains("{actor}") && !titleTemplate.contains("{*actor*}")) {
            throw new RuntimeException(titleTemplate + " is an invalid template!  The title-template must contain the \"{actor}\" token.");
        }
        this.titleTemplate = titleTemplate;
    }

    public Long getPageActorId() {
        return this.pageActorId;
    }

    public void setPageActorId(Long pageActorId) {
        this.pageActorId = pageActorId;
    }
}

