/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.autoconfigure.spanner.health;

import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spring.data.spanner.core.SpannerTemplate;
import org.springframework.boot.actuate.health.AbstractHealthIndicator;
import org.springframework.boot.actuate.health.Health;

public class SpannerHealthIndicator
extends AbstractHealthIndicator {
    private Statement validationStatement;
    private SpannerTemplate spannerTemplate;

    public SpannerHealthIndicator(SpannerTemplate spannerTemplate, String validationQuery) {
        super("Spanner health check failed");
        this.spannerTemplate = spannerTemplate;
        this.validationStatement = Statement.of((String)validationQuery);
    }

    protected void doHealthCheck(Health.Builder builder) throws Exception {
        try (ResultSet resultSet = this.spannerTemplate.executeQuery(this.validationStatement, null);){
            resultSet.next();
        }
        builder.up();
    }
}

