/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.autoconfigure.parameter;

import com.google.cloud.spring.core.Credentials;
import com.google.cloud.spring.core.CredentialsSupplier;
import com.google.cloud.spring.core.GcpScope;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;

@ConfigurationProperties(value="spring.cloud.gcp.parameter")
public class GcpParameterProperties
implements CredentialsSupplier,
EnvironmentAware {
    @NestedConfigurationProperty
    private final Credentials credentials = new Credentials(new String[]{GcpScope.CLOUD_PLATFORM.getUrl()});
    public static final String PREFIX = "spring.cloud.gcp.parameter";
    private boolean enabled;
    @Value(value="${spring.application.name:application}")
    private String name;
    private String profile;
    private String location;
    private String projectId;

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setProfile(String profile) {
        String[] profiles = profile.split(",");
        this.profile = profiles.length > 0 ? profiles[profiles.length - 1] : "default";
    }

    public String getProfile() {
        return this.profile;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public Credentials getCredentials() {
        return this.credentials;
    }

    public void setEnvironment(Environment environment) {
        if (this.profile == null) {
            String[] profiles = environment.getActiveProfiles();
            if (profiles.length == 0) {
                profiles = environment.getDefaultProfiles();
            }
            this.profile = profiles.length > 0 ? profiles[profiles.length - 1] : "default";
        }
        if (this.location == null) {
            this.location = "global";
        }
    }
}

