/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.autoconfigure.spanner;

import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spring.data.spanner.core.SpannerTransactionManager;
import java.util.function.Supplier;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.transaction.TransactionAutoConfiguration;
import org.springframework.boot.autoconfigure.transaction.TransactionManagerCustomizers;
import org.springframework.context.annotation.Bean;
import org.springframework.transaction.PlatformTransactionManager;

@AutoConfiguration
@ConditionalOnClass(value={SpannerTransactionManager.class})
@ConditionalOnProperty(value={"spring.cloud.gcp.spanner.enabled"}, matchIfMissing=true)
@AutoConfigureBefore(value={TransactionAutoConfiguration.class})
public class SpannerTransactionManagerAutoConfiguration {
    private SpannerTransactionManagerAutoConfiguration() {
    }

    @AutoConfiguration
    static class DatabaseClientTransactionManagerConfiguration {
        private final Supplier<DatabaseClient> databaseClientProvider;
        private final TransactionManagerCustomizers transactionManagerCustomizers;

        DatabaseClientTransactionManagerConfiguration(Supplier<DatabaseClient> databaseClientProvider, ObjectProvider<TransactionManagerCustomizers> transactionManagerCustomizers) {
            this.databaseClientProvider = databaseClientProvider;
            this.transactionManagerCustomizers = (TransactionManagerCustomizers)transactionManagerCustomizers.getIfAvailable();
        }

        @Bean
        @ConditionalOnMissingBean
        public SpannerTransactionManager spannerTransactionManager() {
            SpannerTransactionManager transactionManager = new SpannerTransactionManager(this.databaseClientProvider);
            if (this.transactionManagerCustomizers != null) {
                this.transactionManagerCustomizers.customize((PlatformTransactionManager)transactionManager);
            }
            return transactionManager;
        }
    }
}

