/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.logging.v2.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.logging.v2.MetricsClient;
import com.google.cloud.logging.v2.stub.GrpcMetricsServiceV2CallableFactory;
import com.google.cloud.logging.v2.stub.MetricsServiceV2Stub;
import com.google.cloud.logging.v2.stub.MetricsServiceV2StubSettings;
import com.google.logging.v2.CreateLogMetricRequest;
import com.google.logging.v2.DeleteLogMetricRequest;
import com.google.logging.v2.GetLogMetricRequest;
import com.google.logging.v2.ListLogMetricsRequest;
import com.google.logging.v2.ListLogMetricsResponse;
import com.google.logging.v2.LogMetric;
import com.google.logging.v2.UpdateLogMetricRequest;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcMetricsServiceV2Stub
extends MetricsServiceV2Stub {
    private static final MethodDescriptor<ListLogMetricsRequest, ListLogMetricsResponse> listLogMetricsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.logging.v2.MetricsServiceV2/ListLogMetrics").setRequestMarshaller(ProtoUtils.marshaller((Message)ListLogMetricsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListLogMetricsResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<GetLogMetricRequest, LogMetric> getLogMetricMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.logging.v2.MetricsServiceV2/GetLogMetric").setRequestMarshaller(ProtoUtils.marshaller((Message)GetLogMetricRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)LogMetric.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<CreateLogMetricRequest, LogMetric> createLogMetricMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.logging.v2.MetricsServiceV2/CreateLogMetric").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateLogMetricRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)LogMetric.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<UpdateLogMetricRequest, LogMetric> updateLogMetricMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.logging.v2.MetricsServiceV2/UpdateLogMetric").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateLogMetricRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)LogMetric.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<DeleteLogMetricRequest, Empty> deleteLogMetricMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.logging.v2.MetricsServiceV2/DeleteLogMetric").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteLogMetricRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Empty.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private final UnaryCallable<ListLogMetricsRequest, ListLogMetricsResponse> listLogMetricsCallable;
    private final UnaryCallable<ListLogMetricsRequest, MetricsClient.ListLogMetricsPagedResponse> listLogMetricsPagedCallable;
    private final UnaryCallable<GetLogMetricRequest, LogMetric> getLogMetricCallable;
    private final UnaryCallable<CreateLogMetricRequest, LogMetric> createLogMetricCallable;
    private final UnaryCallable<UpdateLogMetricRequest, LogMetric> updateLogMetricCallable;
    private final UnaryCallable<DeleteLogMetricRequest, Empty> deleteLogMetricCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcMetricsServiceV2Stub create(MetricsServiceV2StubSettings settings) throws IOException {
        return new GrpcMetricsServiceV2Stub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcMetricsServiceV2Stub create(ClientContext clientContext) throws IOException {
        return new GrpcMetricsServiceV2Stub(MetricsServiceV2StubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcMetricsServiceV2Stub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcMetricsServiceV2Stub(MetricsServiceV2StubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcMetricsServiceV2Stub(MetricsServiceV2StubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcMetricsServiceV2CallableFactory());
    }

    protected GrpcMetricsServiceV2Stub(MetricsServiceV2StubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings listLogMetricsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listLogMetricsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings getLogMetricTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getLogMetricMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("metric_name", String.valueOf(request.getMetricName()));
            return builder.build();
        }).build();
        GrpcCallSettings createLogMetricTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createLogMetricMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings updateLogMetricTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateLogMetricMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("metric_name", String.valueOf(request.getMetricName()));
            return builder.build();
        }).build();
        GrpcCallSettings deleteLogMetricTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteLogMetricMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("metric_name", String.valueOf(request.getMetricName()));
            return builder.build();
        }).build();
        this.listLogMetricsCallable = callableFactory.createUnaryCallable(listLogMetricsTransportSettings, settings.listLogMetricsSettings(), clientContext);
        this.listLogMetricsPagedCallable = callableFactory.createPagedCallable(listLogMetricsTransportSettings, settings.listLogMetricsSettings(), clientContext);
        this.getLogMetricCallable = callableFactory.createUnaryCallable(getLogMetricTransportSettings, settings.getLogMetricSettings(), clientContext);
        this.createLogMetricCallable = callableFactory.createUnaryCallable(createLogMetricTransportSettings, settings.createLogMetricSettings(), clientContext);
        this.updateLogMetricCallable = callableFactory.createUnaryCallable(updateLogMetricTransportSettings, settings.updateLogMetricSettings(), clientContext);
        this.deleteLogMetricCallable = callableFactory.createUnaryCallable(deleteLogMetricTransportSettings, settings.deleteLogMetricSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<ListLogMetricsRequest, ListLogMetricsResponse> listLogMetricsCallable() {
        return this.listLogMetricsCallable;
    }

    @Override
    public UnaryCallable<ListLogMetricsRequest, MetricsClient.ListLogMetricsPagedResponse> listLogMetricsPagedCallable() {
        return this.listLogMetricsPagedCallable;
    }

    @Override
    public UnaryCallable<GetLogMetricRequest, LogMetric> getLogMetricCallable() {
        return this.getLogMetricCallable;
    }

    @Override
    public UnaryCallable<CreateLogMetricRequest, LogMetric> createLogMetricCallable() {
        return this.createLogMetricCallable;
    }

    @Override
    public UnaryCallable<UpdateLogMetricRequest, LogMetric> updateLogMetricCallable() {
        return this.updateLogMetricCallable;
    }

    @Override
    public UnaryCallable<DeleteLogMetricRequest, Empty> deleteLogMetricCallable() {
        return this.deleteLogMetricCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

