/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmlib.testrunner;

public class TestIdentifier {
    private final String mClassName;
    private final String mTestName;

    public TestIdentifier(String className, String testName) {
        if (className == null || testName == null) {
            throw new IllegalArgumentException("className and testName must be non-null");
        }
        this.mClassName = className;
        this.mTestName = testName;
    }

    public String getClassName() {
        return this.mClassName;
    }

    public String getTestName() {
        return this.mTestName;
    }

    public boolean equals(Object other) {
        if (!(other instanceof TestIdentifier)) {
            return false;
        }
        TestIdentifier otherTest = (TestIdentifier)other;
        return this.getClassName().equals(otherTest.getClassName()) && this.getTestName().equals(otherTest.getTestName());
    }

    public int hashCode() {
        return this.getClassName().hashCode() * 31 + this.getTestName().hashCode();
    }

    public String toString() {
        return String.format("%s#%s", this.getClassName(), this.getTestName());
    }
}

