/*
 * Decompiled with CFR 0.152.
 */
package com.github.miachm.sods;

import com.github.miachm.sods.Color;
import java.util.HashMap;
import java.util.Map;

public final class Style
implements Cloneable {
    private boolean bold;
    private boolean italic;
    private boolean underline;
    private Color fontColor;
    private Color backgroundColor;
    private int fontSize = -1;

    public Style() {
    }

    public Style(boolean bold, boolean italic, boolean underline, Color fontColor, Color backgroundColor, int fontSize) {
        this.bold = bold;
        this.italic = italic;
        this.underline = underline;
        this.fontColor = fontColor;
        this.backgroundColor = backgroundColor;
        this.fontSize = fontSize;
    }

    public boolean isDefault() {
        return this.equals(new Style());
    }

    public boolean isBold() {
        return this.bold;
    }

    public boolean isItalic() {
        return this.italic;
    }

    public Color getFontColor() {
        return this.fontColor;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public void setFontColor(Color fontColor) {
        this.fontColor = fontColor;
    }

    public void setBold(boolean bold) {
        this.bold = bold;
    }

    public void setItalic(boolean italic) {
        this.italic = italic;
    }

    public boolean isUnderline() {
        return this.underline;
    }

    public void setUnderline(boolean underline) {
        this.underline = underline;
    }

    public void setFontSize(int fontSize) {
        if (fontSize < -1) {
            throw new IllegalArgumentException("Error, font size can be less of -1");
        }
        this.fontSize = fontSize;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Style style = (Style)o;
        if (this.bold != style.bold) {
            return false;
        }
        if (this.italic != style.italic) {
            return false;
        }
        if (this.underline != style.underline) {
            return false;
        }
        if (this.fontSize != style.fontSize) {
            return false;
        }
        if (this.fontColor != null ? !this.fontColor.equals(style.fontColor) : style.fontColor != null) {
            return false;
        }
        return this.backgroundColor != null ? this.backgroundColor.equals(style.backgroundColor) : style.backgroundColor == null;
    }

    public int hashCode() {
        int result = this.bold ? 1 : 0;
        result = 31 * result + (this.italic ? 1 : 0);
        result = 31 * result + (this.underline ? 1 : 0);
        result = 31 * result + (this.fontColor != null ? this.fontColor.hashCode() : 0);
        result = 31 * result + (this.backgroundColor != null ? this.backgroundColor.hashCode() : 0);
        result = 31 * result + this.fontSize;
        return result;
    }

    public Map<String, String> getCssStyles() {
        HashMap<String, String> result = new HashMap<String, String>();
        if (this.isBold()) {
            result.put("font-weight", "bold");
        }
        if (this.isItalic()) {
            result.put("font-style", "italic");
        }
        if (this.isUnderline()) {
            result.put("text-decoration", "underline");
        }
        if (this.getFontSize() != -1) {
            result.put("font-size", "" + this.getFontSize());
        }
        if (this.getFontColor() != null) {
            result.put("color", "" + this.getFontColor().toString() + ";");
        }
        if (this.getBackgroundColor() != null) {
            result.put("background-color", this.getBackgroundColor().toString());
        }
        return result;
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String prefix) {
        String result = "";
        Map<String, String> styles = this.getCssStyles();
        for (Map.Entry<String, String> style : styles.entrySet()) {
            result = result + prefix + style.getKey() + ": " + style.getValue() + ";\n";
        }
        return result;
    }
}

