/*
 * Decompiled with CFR 0.152.
 */
package com.github.maven_nar.cpptasks.openwatcom;

import com.github.maven_nar.cpptasks.CUtil;
import com.github.maven_nar.cpptasks.TargetMatcher;
import com.github.maven_nar.cpptasks.VersionInfo;
import com.github.maven_nar.cpptasks.compiler.CommandLineLinker;
import com.github.maven_nar.cpptasks.compiler.LinkType;
import com.github.maven_nar.cpptasks.openwatcom.OpenWatcomProcessor;
import com.github.maven_nar.cpptasks.platforms.WindowsPlatform;
import com.github.maven_nar.cpptasks.types.LibraryTypeEnum;
import java.io.File;
import java.io.IOException;
import java.util.Vector;

public abstract class OpenWatcomLinker
extends CommandLineLinker {
    protected OpenWatcomLinker(String command, String outputSuffix) {
        super(command, "-r", new String[]{".obj", ".lib", ".res"}, new String[]{".map", ".pdb", ".lnk"}, outputSuffix, false, null);
    }

    protected final void addBase(long base, Vector<String> args) {
    }

    protected final void addEntry(String entry, Vector<String> args) {
    }

    protected final void addFixed(Boolean fixed, Vector<String> args) {
    }

    protected final void addImpliedArgs(boolean debug, LinkType linkType, Vector<String> args) {
        if (linkType.isExecutable()) {
            if (linkType.isSubsystemConsole()) {
                args.addElement("/bc");
            } else if (linkType.isSubsystemGUI()) {
                args.addElement("/bg");
            }
        }
        if (linkType.isSharedLibrary()) {
            args.addElement("/bd");
        }
    }

    protected final void addIncremental(boolean incremental, Vector<String> args) {
    }

    protected final void addMap(boolean map, Vector<String> args) {
        if (map) {
            args.addElement("/fm");
        }
    }

    protected final void addStack(int stack, Vector<String> args) {
        if (stack >= 0) {
            String stackStr = Integer.toString(stack);
            args.addElement("/k" + stackStr);
        }
    }

    @Override
    public final void addVersionFiles(VersionInfo versionInfo, LinkType linkType, File outputFile, boolean isDebug, File objDir, TargetMatcher matcher) throws IOException {
        WindowsPlatform.addVersionFiles(versionInfo, linkType, outputFile, isDebug, objDir, matcher);
    }

    @Override
    public final String getCommandFileSwitch(String commandFile) {
        return "@" + commandFile;
    }

    @Override
    public final File[] getLibraryPath() {
        return CUtil.getPathFromEnvironment("LIB", ";");
    }

    @Override
    public final String[] getLibraryPatterns(String[] libnames, LibraryTypeEnum libType) {
        return OpenWatcomProcessor.getLibraryPatterns(libnames, libType);
    }

    @Override
    public final int getMaximumCommandLength() {
        return 1024;
    }

    @Override
    public final String[] getOutputFileSwitch(String outFile) {
        return OpenWatcomProcessor.getOutputFileSwitch(outFile);
    }

    @Override
    public final boolean isCaseSensitive() {
        return OpenWatcomProcessor.isCaseSensitive();
    }
}

