/*
 * Decompiled with CFR 0.152.
 */
package com.github.maven_nar.cpptasks.gcc.cross;

import com.github.maven_nar.cpptasks.CCTask;
import com.github.maven_nar.cpptasks.LinkerParam;
import com.github.maven_nar.cpptasks.compiler.CommandLineLinkerConfiguration;
import com.github.maven_nar.cpptasks.compiler.LinkType;
import com.github.maven_nar.cpptasks.compiler.Linker;
import com.github.maven_nar.cpptasks.gcc.AbstractLdLinker;
import com.github.maven_nar.cpptasks.gcc.cross.GccLibrarian;
import java.io.File;
import org.apache.tools.ant.BuildException;

public final class LdLinker
extends AbstractLdLinker {
    private static final String[] libtoolObjFiles = new String[]{".fo", ".a", ".lib", ".dll", ".so", ".sl"};
    private static final String[] objFiles = new String[]{".o", ".a", ".lib", ".dll", ".so", ".sl"};
    private static final String[] discardFiles = new String[0];
    private static final LdLinker dllLinker = new LdLinker("ld", objFiles, discardFiles, "lib", ".so", false, new LdLinker("ld", objFiles, discardFiles, "lib", ".so", true, null));
    private static final LdLinker instance = new LdLinker("ld", objFiles, discardFiles, "", "", false, null);
    private File[] libDirs;

    public static LdLinker getInstance() {
        return instance;
    }

    private LdLinker(String command, String[] extensions, String[] ignoredExtensions, String outputPrefix, String outputSuffix, boolean isLibtool, LdLinker libtoolLinker) {
        super(command, "-version", extensions, ignoredExtensions, outputPrefix, outputSuffix, isLibtool, libtoolLinker);
    }

    @Override
    protected Object clone() throws CloneNotSupportedException {
        LdLinker clone = (LdLinker)super.clone();
        return clone;
    }

    @Override
    public Linker getLinker(LinkType type) {
        if (type.isStaticLibrary()) {
            return GccLibrarian.getInstance();
        }
        if (type.isSharedLibrary()) {
            return dllLinker;
        }
        return instance;
    }

    @Override
    public void link(CCTask task, File outputFile, String[] sourceFiles, CommandLineLinkerConfiguration config) throws BuildException {
        try {
            LdLinker clone = (LdLinker)this.clone();
            LinkerParam param = config.getParam("target");
            if (param != null) {
                clone.setCommand(param.getValue() + "-" + this.getCommand());
            }
            clone.superlink(task, outputFile, sourceFiles, config);
        }
        catch (CloneNotSupportedException e) {
            this.superlink(task, outputFile, sourceFiles, config);
        }
    }

    private void superlink(CCTask task, File outputFile, String[] sourceFiles, CommandLineLinkerConfiguration config) throws BuildException {
        super.link(task, outputFile, sourceFiles, config);
    }
}

