/*
 * Decompiled with CFR 0.152.
 */
package com.github.maven_nar.cpptasks.arm;

import com.github.maven_nar.cpptasks.CUtil;
import com.github.maven_nar.cpptasks.OptimizationEnum;
import com.github.maven_nar.cpptasks.arm.ADSLibrarian;
import com.github.maven_nar.cpptasks.arm.ADSLinker;
import com.github.maven_nar.cpptasks.compiler.CommandLineCCompiler;
import com.github.maven_nar.cpptasks.compiler.LinkType;
import com.github.maven_nar.cpptasks.compiler.Linker;
import java.io.File;
import java.util.Vector;
import org.apache.tools.ant.types.Environment;

public class ADSCCompiler
extends CommandLineCCompiler {
    private static final String[] headerExtensions = new String[]{".h", ".hpp", ".inl"};
    private static final String[] sourceExtensions = new String[]{".c", ".cc", ".cpp", ".cxx", ".c++"};
    private static final ADSCCompiler armcc = new ADSCCompiler("armcc", false, null);
    private static final ADSCCompiler armcpp = new ADSCCompiler("armcpp", false, null);
    private static final ADSCCompiler tcc = new ADSCCompiler("tcc", false, null);
    private static final ADSCCompiler tcpp = new ADSCCompiler("tcpp", false, null);

    public static ADSCCompiler getArmCC() {
        return armcc;
    }

    public static ADSCCompiler getArmCpp() {
        return armcpp;
    }

    public static ADSCCompiler getThumbCC() {
        return tcc;
    }

    public static ADSCCompiler getThumbCpp() {
        return tcpp;
    }

    private static void quoteFile(StringBuffer buf, String outPath) {
        if (outPath.indexOf(32) >= 0) {
            buf.append('\"');
            buf.append(outPath);
            buf.append('\"');
        } else {
            buf.append(outPath);
        }
    }

    private ADSCCompiler(String command, boolean newEnvironment, Environment env) {
        super(command, "-vsn", sourceExtensions, headerExtensions, ".o", false, null, newEnvironment, env);
    }

    @Override
    protected void addImpliedArgs(Vector<String> args, boolean debug, boolean multithreaded, boolean exceptions, LinkType linkType, Boolean rtti, OptimizationEnum optimization) {
        if (debug) {
            args.addElement("-g");
        }
        if (linkType.isExecutable() || linkType.isSharedLibrary()) {
            // empty if block
        }
    }

    @Override
    protected void addWarningSwitch(Vector<String> args, int warnings) {
    }

    @Override
    protected void getDefineSwitch(StringBuffer buffer, String define, String value) {
        buffer.append("-D");
        buffer.append(define);
        if (value != null) {
            buffer.append('=');
            buffer.append(value);
        }
    }

    @Override
    protected File[] getEnvironmentIncludePath() {
        return CUtil.getPathFromEnvironment("ARMINC", ";");
    }

    @Override
    protected String getIncludeDirSwitch(String source) {
        StringBuffer buf = new StringBuffer("-I");
        ADSCCompiler.quoteFile(buf, source);
        return buf.toString();
    }

    @Override
    public Linker getLinker(LinkType type) {
        if (type.isStaticLibrary()) {
            return ADSLibrarian.getInstance();
        }
        if (type.isSharedLibrary()) {
            return ADSLinker.getDllInstance();
        }
        return ADSLinker.getInstance();
    }

    @Override
    public int getMaximumCommandLength() {
        return 1000;
    }

    @Override
    protected void getUndefineSwitch(StringBuffer buffer, String define) {
        buffer.append("-U");
        buffer.append(define);
    }
}

