/*
 * Decompiled with CFR 0.152.
 */
package com.github.maven_nar.cpptasks;

import com.github.maven_nar.cpptasks.CCTask;
import com.github.maven_nar.cpptasks.FileVisitor;
import com.github.maven_nar.cpptasks.TargetInfo;
import com.github.maven_nar.cpptasks.VersionInfo;
import com.github.maven_nar.cpptasks.compiler.LinkerConfiguration;
import com.github.maven_nar.cpptasks.compiler.ProcessorConfiguration;
import java.io.File;
import java.util.Map;
import java.util.Vector;
import org.apache.tools.ant.BuildException;

public final class TargetMatcher
implements FileVisitor {
    private LinkerConfiguration linker;
    private Vector<File> objectFiles;
    private File outputDir;
    private ProcessorConfiguration[] processors;
    private final File[] sourceFiles = new File[1];
    private Map<String, TargetInfo> targets;
    private VersionInfo versionInfo;
    private CCTask task;

    public TargetMatcher(CCTask task, File outputDir, ProcessorConfiguration[] processors, LinkerConfiguration linker, Vector<File> objectFiles, Map<String, TargetInfo> targets, VersionInfo versionInfo) {
        this.task = task;
        this.outputDir = outputDir;
        this.processors = processors;
        this.targets = targets;
        this.linker = linker;
        this.objectFiles = objectFiles;
        this.versionInfo = versionInfo;
    }

    @Override
    public void visit(File parentDir, String filename) throws BuildException {
        File fullPath = new File(parentDir, filename);
        ProcessorConfiguration selectedCompiler = null;
        int bid = 0;
        if (this.processors != null) {
            for (int k = 0; k < this.processors.length; ++k) {
                int newBid = this.processors[k].bid(fullPath.toString());
                if (newBid <= bid) continue;
                bid = newBid;
                selectedCompiler = this.processors[k];
            }
        }
        if (bid <= 0) {
            int linkerbid;
            if (this.linker != null && (linkerbid = this.linker.bid(filename)) > 0) {
                this.objectFiles.addElement(fullPath);
                if (linkerbid == 1) {
                    this.task.log("Unrecognized file type " + fullPath.toString() + " will be passed to linker");
                }
            }
        } else {
            String[] outputFileNames = selectedCompiler.getOutputFileNames(filename, this.versionInfo);
            this.sourceFiles[0] = fullPath;
            for (int i = 0; i < outputFileNames.length; ++i) {
                TargetInfo previousTarget = this.targets.get(outputFileNames[i]);
                if (previousTarget == null) {
                    this.targets.put(outputFileNames[i], new TargetInfo(selectedCompiler, this.sourceFiles, null, new File(this.outputDir, outputFileNames[i]), selectedCompiler.getRebuild()));
                    continue;
                }
                if (previousTarget.getSources()[0].equals(this.sourceFiles[0])) continue;
                StringBuffer builder = new StringBuffer("Output filename conflict: ");
                builder.append(outputFileNames[i]);
                builder.append(" would be produced from ");
                builder.append(previousTarget.getSources()[0].toString());
                builder.append(" and ");
                builder.append(filename);
                throw new BuildException(builder.toString());
            }
        }
    }
}

