/*
 * Decompiled with CFR 0.152.
 */
package smile.util;

import java.util.Arrays;

public class IntArray2D {
    private int[] A;
    private int nrows;
    private int ncols;

    public IntArray2D(int[][] A) {
        this.nrows = A.length;
        this.ncols = A[0].length;
        this.A = new int[this.nrows * this.ncols];
        int pos = 0;
        for (int i = 0; i < this.nrows; ++i) {
            System.arraycopy(A[i], 0, this.A, pos, this.ncols);
            pos += this.ncols;
        }
    }

    public IntArray2D(int rows, int cols) {
        this.nrows = rows;
        this.ncols = cols;
        this.A = new int[rows * cols];
    }

    public IntArray2D(int rows, int cols, int value) {
        this(rows, cols);
        if ((double)value != 0.0) {
            Arrays.fill(this.A, value);
        }
    }

    public IntArray2D(int rows, int cols, int[] value) {
        this.nrows = rows;
        this.ncols = cols;
        this.A = value;
    }

    public int nrows() {
        return this.nrows;
    }

    public int ncols() {
        return this.ncols;
    }

    public int apply(int i, int j) {
        return this.A[i * this.ncols + j];
    }

    public int get(int i, int j) {
        return this.A[i * this.ncols + j];
    }

    public int set(int i, int j, int x) {
        int n = x;
        this.A[i * this.ncols + j] = n;
        return n;
    }

    public int add(int i, int j, int x) {
        int n = i * this.ncols + j;
        int n2 = this.A[n] + x;
        this.A[n] = n2;
        return n2;
    }

    public int sub(int i, int j, int x) {
        int n = i * this.ncols + j;
        int n2 = this.A[n] - x;
        this.A[n] = n2;
        return n2;
    }

    public int mul(int i, int j, int x) {
        int n = i * this.ncols + j;
        int n2 = this.A[n] * x;
        this.A[n] = n2;
        return n2;
    }

    public int div(int i, int j, int x) {
        int n = i * this.ncols + j;
        int n2 = this.A[n] / x;
        this.A[n] = n2;
        return n2;
    }

    public IntArray2D add(IntArray2D b) {
        if (this.nrows() != b.nrows() || this.ncols() != b.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        for (int i = 0; i < this.A.length; ++i) {
            int n = i;
            this.A[n] = this.A[n] + b.A[i];
        }
        return this;
    }

    public IntArray2D sub(IntArray2D b) {
        if (this.nrows() != b.nrows() || this.ncols() != b.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        for (int i = 0; i < this.A.length; ++i) {
            int n = i;
            this.A[n] = this.A[n] - b.A[i];
        }
        return this;
    }

    public IntArray2D mul(IntArray2D b) {
        if (this.nrows() != b.nrows() || this.ncols() != b.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        for (int i = 0; i < this.A.length; ++i) {
            int n = i;
            this.A[n] = this.A[n] * b.A[i];
        }
        return this;
    }

    public IntArray2D div(IntArray2D b) {
        if (this.nrows() != b.nrows() || this.ncols() != b.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        for (int i = 0; i < this.A.length; ++i) {
            int n = i;
            this.A[n] = this.A[n] / b.A[i];
        }
        return this;
    }

    public IntArray2D add(int x) {
        int i = 0;
        while (i < this.A.length) {
            int n = i++;
            this.A[n] = this.A[n] + x;
        }
        return this;
    }

    public IntArray2D sub(int x) {
        int i = 0;
        while (i < this.A.length) {
            int n = i++;
            this.A[n] = this.A[n] - x;
        }
        return this;
    }

    public IntArray2D mul(int x) {
        int i = 0;
        while (i < this.A.length) {
            int n = i++;
            this.A[n] = this.A[n] * x;
        }
        return this;
    }

    public IntArray2D div(int x) {
        int i = 0;
        while (i < this.A.length) {
            int n = i++;
            this.A[n] = this.A[n] / x;
        }
        return this;
    }

    public long sum() {
        long s = 0L;
        for (int i = 0; i < this.A.length; ++i) {
            s += (long)this.A[i];
        }
        return s;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean full) {
        return full ? this.toString(this.nrows(), this.ncols()) : this.toString(7, 7);
    }

    public String toString(int m, int n) {
        StringBuilder sb = new StringBuilder();
        m = Math.min(m, this.nrows());
        String newline = (n = Math.min(n, this.ncols())) < this.ncols() ? "...\n" : "\n";
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                sb.append(String.format("%d  ", this.get(i, j)));
            }
            sb.append(newline);
        }
        if (m < this.nrows()) {
            sb.append("  ...\n");
        }
        return sb.toString();
    }
}

