/*
 * Decompiled with CFR 0.152.
 */
package smile.math.matrix;

import java.io.IOException;
import java.io.LineNumberReader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Scanner;
import smile.math.blas.Transpose;
import smile.math.blas.UPLO;
import smile.math.matrix.IMatrix;
import smile.math.matrix.Matrix;
import smile.math.matrix.SparseMatrix;
import smile.math.matrix.SymmMatrix;
import smile.util.SparseArray;
import smile.util.Strings;

public abstract class DMatrix
extends IMatrix<double[]> {
    public abstract DMatrix set(int var1, int var2, double var3);

    public DMatrix update(int i, int j, double x) {
        return this.set(i, j, x);
    }

    public abstract double get(int var1, int var2);

    public double apply(int i, int j) {
        return this.get(i, j);
    }

    @Override
    String str(int i, int j) {
        return Strings.format(this.get(i, j), true);
    }

    public double[] diag() {
        int n = Math.min(this.nrows(), this.ncols());
        double[] d = new double[n];
        for (int i = 0; i < n; ++i) {
            d[i] = this.get(i, i);
        }
        return d;
    }

    public double trace() {
        int n = Math.min(this.nrows(), this.ncols());
        double t2 = 0.0;
        for (int i = 0; i < n; ++i) {
            t2 += this.get(i, i);
        }
        return t2;
    }

    public abstract void mv(Transpose var1, double var2, double[] var4, double var5, double[] var7);

    @Override
    public double[] mv(double[] x) {
        double[] y = new double[this.nrows()];
        this.mv(Transpose.NO_TRANSPOSE, 1.0, x, 0.0, y);
        return y;
    }

    @Override
    public void mv(double[] x, double[] y) {
        this.mv(Transpose.NO_TRANSPOSE, 1.0, x, 0.0, y);
    }

    public void mv(double alpha, double[] x, double beta, double[] y) {
        this.mv(Transpose.NO_TRANSPOSE, alpha, x, beta, y);
    }

    @Override
    public double[] tv(double[] x) {
        double[] y = new double[this.ncols()];
        this.mv(Transpose.TRANSPOSE, 1.0, x, 0.0, y);
        return y;
    }

    @Override
    public void tv(double[] x, double[] y) {
        this.mv(Transpose.TRANSPOSE, 1.0, x, 0.0, y);
    }

    public void tv(double alpha, double[] x, double beta, double[] y) {
        this.mv(Transpose.TRANSPOSE, alpha, x, beta, y);
    }

    public static DMatrix market(Path path) throws IOException, ParseException {
        Throwable throwable = null;
        try (LineNumberReader reader = new LineNumberReader(Files.newBufferedReader(path));){
            String format;
            Throwable throwable2;
            Scanner scanner;
            block70: {
                int i;
                int nz;
                int ncols;
                int nrows;
                String line;
                boolean skew;
                boolean symmetric;
                block71: {
                    SymmMatrix k2;
                    block72: {
                        block73: {
                            block67: {
                                Matrix j2;
                                block68: {
                                    block69: {
                                        scanner = new Scanner(reader);
                                        throwable2 = null;
                                        String header = scanner.next();
                                        if (!header.equals("%%MatrixMarket")) {
                                            throw new ParseException("Invalid Matrix Market file header", reader.getLineNumber());
                                        }
                                        String object = scanner.next();
                                        if (!object.equals("matrix")) {
                                            throw new UnsupportedOperationException("The object is not a matrix file: " + object);
                                        }
                                        format = scanner.next();
                                        String field = scanner.next();
                                        if (field.equals("complex") || field.equals("pattern")) {
                                            throw new UnsupportedOperationException("No support of complex or pattern matrix");
                                        }
                                        String symmetry = scanner.nextLine().trim();
                                        if (symmetry.equals("Hermitian")) {
                                            throw new UnsupportedOperationException("No support of Hermitian matrix");
                                        }
                                        symmetric = symmetry.equals("symmetric");
                                        skew = symmetry.equals("skew-symmetric");
                                        line = scanner.nextLine();
                                        while (line.startsWith("%")) {
                                            line = scanner.nextLine();
                                        }
                                        if (!format.equals("array")) break block67;
                                        Scanner s = new Scanner(line);
                                        int nrows2 = s.nextInt();
                                        int ncols2 = s.nextInt();
                                        Matrix matrix = new Matrix(nrows2, ncols2);
                                        for (int j2 = 0; j2 < ncols2; ++j2) {
                                            for (int i2 = 0; i2 < nrows2; ++i2) {
                                                double x = scanner.nextDouble();
                                                matrix.set(i2, j2, x);
                                            }
                                        }
                                        if (symmetric) {
                                            matrix.uplo(UPLO.LOWER);
                                        }
                                        j2 = matrix;
                                        if (scanner == null) break block68;
                                        if (throwable2 == null) break block69;
                                        try {
                                            scanner.close();
                                        }
                                        catch (Throwable i2) {
                                            throwable2.addSuppressed(i2);
                                        }
                                        break block68;
                                    }
                                    scanner.close();
                                }
                                return j2;
                            }
                            if (!format.equals("coordinate")) break block70;
                            Scanner s = new Scanner(line);
                            nrows = s.nextInt();
                            ncols = s.nextInt();
                            nz = s.nextInt();
                            if (!symmetric || nz != nrows * (nrows + 1) / 2) break block71;
                            if (nrows != ncols) {
                                throw new IllegalStateException(String.format("Symmetric matrix is not square: %d != %d", nrows, ncols));
                            }
                            SymmMatrix matrix = new SymmMatrix(UPLO.LOWER, nrows);
                            for (int k2 = 0; k2 < nz; ++k2) {
                                String[] tokens = scanner.nextLine().trim().split("\\s+");
                                if (tokens.length != 3) {
                                    throw new ParseException("Invalid data line: " + line, reader.getLineNumber());
                                }
                                int i3 = Integer.parseInt(tokens[0]) - 1;
                                int j = Integer.parseInt(tokens[1]) - 1;
                                double x = Double.parseDouble(tokens[2]);
                                matrix.set(i3, j, x);
                            }
                            k2 = matrix;
                            if (scanner == null) break block72;
                            if (throwable2 == null) break block73;
                            try {
                                scanner.close();
                            }
                            catch (Throwable tokens) {
                                throwable2.addSuppressed(tokens);
                            }
                            break block72;
                        }
                        scanner.close();
                    }
                    return k2;
                }
                if (skew && nz == nrows * (nrows + 1) / 2) {
                    if (nrows != ncols) {
                        throw new IllegalStateException(String.format("Skew-symmetric matrix is not square: %d != %d", nrows, ncols));
                    }
                    Matrix matrix = new Matrix(nrows, ncols);
                    for (int k = 0; k < nz; ++k) {
                        String[] tokens = scanner.nextLine().trim().split("\\s+");
                        if (tokens.length != 3) {
                            throw new ParseException("Invalid data line: " + line, reader.getLineNumber());
                        }
                        int i4 = Integer.parseInt(tokens[0]) - 1;
                        int j = Integer.parseInt(tokens[1]) - 1;
                        double x = Double.parseDouble(tokens[2]);
                        matrix.set(i4, j, x);
                        matrix.set(j, i4, -x);
                    }
                    Matrix k = matrix;
                    return k;
                }
                int[] colSize = new int[ncols];
                ArrayList<SparseArray> rows = new ArrayList<SparseArray>();
                for (int i5 = 0; i5 < nrows; ++i5) {
                    rows.add(new SparseArray());
                }
                for (int k = 0; k < nz; ++k) {
                    String[] tokens = scanner.nextLine().trim().split("\\s+");
                    if (tokens.length != 3) {
                        throw new ParseException("Invalid data line: " + line, reader.getLineNumber());
                    }
                    i = Integer.parseInt(tokens[0]) - 1;
                    int j = Integer.parseInt(tokens[1]) - 1;
                    double x = Double.parseDouble(tokens[2]);
                    SparseArray row = (SparseArray)rows.get(i);
                    row.set(j, x);
                    int n = j;
                    colSize[n] = colSize[n] + 1;
                    if (symmetric) {
                        row = (SparseArray)rows.get(j);
                        row.set(i, x);
                        int n2 = i;
                        colSize[n2] = colSize[n2] + 1;
                        continue;
                    }
                    if (!skew) continue;
                    row = (SparseArray)rows.get(j);
                    row.set(i, -x);
                    int n3 = i;
                    colSize[n3] = colSize[n3] + 1;
                }
                int[] pos = new int[ncols];
                int[] colIndex = new int[ncols + 1];
                for (i = 0; i < ncols; ++i) {
                    colIndex[i + 1] = colIndex[i] + colSize[i];
                }
                if (symmetric || skew) {
                    nz *= 2;
                }
                int[] rowIndex = new int[nz];
                double[] x = new double[nz];
                for (int i6 = 0; i6 < nrows; ++i6) {
                    for (SparseArray.Entry e : (SparseArray)rows.get(i6)) {
                        int j = e.i;
                        int k = colIndex[j] + pos[j];
                        rowIndex[k] = i6;
                        x[k] = e.x;
                        int n = j;
                        pos[n] = pos[n] + 1;
                    }
                }
                SparseMatrix matrix = new SparseMatrix(nrows, ncols, x, rowIndex, colIndex);
                SparseMatrix sparseMatrix = matrix;
                return sparseMatrix;
            }
            try {
                try {
                    throw new ParseException("Invalid Matrix Market format: " + format, 0);
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (scanner != null) {
                    if (throwable2 != null) {
                        try {
                            scanner.close();
                        }
                        catch (Throwable tokens) {
                            throwable2.addSuppressed(tokens);
                        }
                    } else {
                        scanner.close();
                    }
                }
            }
        }
    }

    DMatrix square() {
        final DMatrix A = this;
        return new DMatrix(){
            private int m;
            private int n;
            private double[] Ax;
            {
                this.m = Math.max(A.nrows(), A.ncols());
                this.n = Math.min(A.nrows(), A.ncols());
                this.Ax = new double[this.m + this.n];
            }

            @Override
            public int nrows() {
                return this.n;
            }

            @Override
            public int ncols() {
                return this.n;
            }

            @Override
            public long size() {
                return this.m + this.n;
            }

            @Override
            public void mv(double[] work, int inputOffset, int outputOffset) {
                System.arraycopy(work, inputOffset, this.Ax, 0, this.n);
                if (A.nrows() >= A.ncols()) {
                    A.mv(this.Ax, 0, this.n);
                    A.tv(this.Ax, this.n, 0);
                } else {
                    A.tv(this.Ax, 0, this.n);
                    A.mv(this.Ax, this.n, 0);
                }
                System.arraycopy(this.Ax, 0, work, outputOffset, this.n);
            }

            @Override
            public void tv(double[] work, int inputOffset, int outputOffset) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void mv(Transpose trans, double alpha, double[] x, double beta, double[] y) {
                throw new UnsupportedOperationException();
            }

            @Override
            public double get(int i, int j) {
                throw new UnsupportedOperationException();
            }

            @Override
            public DMatrix set(int i, int j, double x) {
                throw new UnsupportedOperationException();
            }
        };
    }
}

