/*
 * Decompiled with CFR 0.152.
 */
package smile.math.kernel;

import java.util.Iterator;
import smile.math.MathEx;
import smile.math.kernel.MercerKernel;
import smile.util.SparseArray;

public class SparseThinPlateSplineKernel
implements MercerKernel<SparseArray> {
    private static final long serialVersionUID = 1L;
    private double sigma;

    public SparseThinPlateSplineKernel(double sigma) {
        if (sigma <= 0.0) {
            throw new IllegalArgumentException("sigma is not positive.");
        }
        this.sigma = sigma;
    }

    public String toString() {
        return String.format("Sparse Thin Plate Spline Kernel (\u02e0 = %.4f)", this.sigma);
    }

    @Override
    public double k(SparseArray x, SparseArray y) {
        Iterator<SparseArray.Entry> it1 = x.iterator();
        Iterator<SparseArray.Entry> it2 = y.iterator();
        SparseArray.Entry e1 = it1.hasNext() ? it1.next() : null;
        SparseArray.Entry e2 = it2.hasNext() ? it2.next() : null;
        double s = 0.0;
        while (e1 != null && e2 != null) {
            if (e1.i == e2.i) {
                s += MathEx.sqr(e1.x - e2.x);
                e1 = it1.hasNext() ? it1.next() : null;
                e2 = it2.hasNext() ? it2.next() : null;
                continue;
            }
            if (e1.i > e2.i) {
                s += MathEx.sqr(e2.x);
                e2 = it2.hasNext() ? it2.next() : null;
                continue;
            }
            s += MathEx.sqr(e1.x);
            e1 = it1.hasNext() ? it1.next() : null;
        }
        while (it1.hasNext()) {
            s += MathEx.sqr(it1.next().x);
        }
        while (it2.hasNext()) {
            s += MathEx.sqr(it2.next().x);
        }
        return s / (this.sigma * this.sigma) * Math.log(Math.sqrt(s) / this.sigma);
    }
}

