/*
 * Decompiled with CFR 0.152.
 */
package smile.math.kernel;

import smile.math.MathEx;
import smile.math.kernel.MercerKernel;

public class PolynomialKernel
implements MercerKernel<double[]> {
    private static final long serialVersionUID = 1L;
    private int degree;
    private double scale;
    private double offset;

    public PolynomialKernel(int degree) {
        this(degree, 1.0, 0.0);
    }

    public PolynomialKernel(int degree, double scale, double offset) {
        if (degree <= 0) {
            throw new IllegalArgumentException("Non-positive polynomial degree.");
        }
        if (offset < 0.0) {
            throw new IllegalArgumentException("Negative offset: the kernel does not satisfy Mercer's condition.");
        }
        this.degree = degree;
        this.scale = scale;
        this.offset = offset;
    }

    public String toString() {
        return String.format("Polynomial Kernel (scale = %.4f, offset = %.4f)", this.scale, this.offset);
    }

    @Override
    public double k(double[] x, double[] y) {
        if (x.length != y.length) {
            throw new IllegalArgumentException(String.format("Arrays have different length: x[%d], y[%d]", x.length, y.length));
        }
        double dot = MathEx.dot(x, y);
        return Math.pow(this.scale * dot + this.offset, this.degree);
    }
}

