/*
 * Decompiled with CFR 0.152.
 */
package smile.math;

import java.lang.reflect.Array;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import smile.math.Random;
import smile.sort.QuickSelect;
import smile.sort.QuickSort;
import smile.sort.Sort;
import smile.util.IntPair;
import smile.util.SparseArray;

public class MathEx {
    private static final Logger logger = LoggerFactory.getLogger(MathEx.class);
    private static final FPU fpu = new FPU();
    public static final double EPSILON = MathEx.fpu.EPSILON;
    public static final float FLOAT_EPSILON = MathEx.fpu.FLOAT_EPSILON;
    public static final int RADIX = MathEx.fpu.RADIX;
    public static final int DIGITS = MathEx.fpu.DIGITS;
    public static final int FLOAT_DIGITS = MathEx.fpu.FLOAT_DIGITS;
    public static final int ROUND_STYLE = MathEx.fpu.ROUND_STYLE;
    public static final int MACHEP = MathEx.fpu.MACHEP;
    public static final int FLOAT_MACHEP = MathEx.fpu.FLOAT_MACHEP;
    public static final int NEGEP = MathEx.fpu.NEGEP;
    public static final int FLOAT_NEGEP = MathEx.fpu.FLOAT_NEGEP;
    private static Random seedRNG = new Random();
    private static HashSet<Long> seeds = new HashSet();
    private static ThreadLocal<Random> random = new ThreadLocal<Random>(){

        @Override
        protected synchronized Random initialValue() {
            long seed = 19650218L;
            if (!seeds.isEmpty()) {
                do {
                    seed = MathEx.probablePrime(19650218L, 256, seedRNG);
                } while (seeds.contains(seed));
            }
            logger.info(String.format("Set RNG seed %d for thread %s", seed, Thread.currentThread().getName()));
            seeds.add(seed);
            return new Random(seed);
        }
    };
    private static final double LOG2 = Math.log(2.0);

    private MathEx() {
    }

    public static double log2(double x) {
        return Math.log(x) / LOG2;
    }

    public static double log(double x) {
        double y = -690.7755;
        if (x > 1.0E-300) {
            y = Math.log(x);
        }
        return y;
    }

    public static double log1pe(double x) {
        double y = x;
        if (x <= 15.0) {
            y = Math.log1p(Math.exp(x));
        }
        return y;
    }

    public static boolean isInt(float x) {
        return x == (float)Math.floor(x) && !Float.isInfinite(x);
    }

    public static boolean isInt(double x) {
        return x == Math.floor(x) && !Double.isInfinite(x);
    }

    public static boolean equals(double a, double b) {
        if (a == b) {
            return true;
        }
        double absa = Math.abs(a);
        double absb = Math.abs(b);
        return Math.abs(a - b) <= Math.min(absa, absb) * 2.220446049250313E-16;
    }

    public static double logistic(double x) {
        double y = x < -40.0 ? 2.353853E17 : (x > 40.0 ? 1.0 : 1.0 + Math.exp(-x));
        return 1.0 / y;
    }

    public static double tanh(double x) {
        return 2.0 * MathEx.logistic(2.0 * x) - 1.0;
    }

    public static double sqr(double x) {
        return x * x;
    }

    public static boolean isPower2(int x) {
        return x > 0 && (x & x - 1) == 0;
    }

    public static boolean isProbablePrime(long n, int k) {
        return MathEx.isProbablePrime(n, k, random.get());
    }

    private static boolean isProbablePrime(long n, int k, Random rng) {
        if (n <= 1L || n == 4L) {
            return false;
        }
        if (n <= 3L) {
            return true;
        }
        int s = 0;
        long d = n - 1L;
        while (d % 2L == 0L) {
            ++s;
            d /= 2L;
        }
        for (int i = 0; i < k; ++i) {
            int r;
            long a = 2L + rng.nextLong() % (n - 4L);
            long x = MathEx.power(a, d, n);
            if (x == 1L || x == n - 1L) continue;
            for (r = 0; r < s; ++r) {
                if ((x = x * x % n) == 1L) {
                    return false;
                }
                if (x == n - 1L) break;
            }
            if (r != s) continue;
            return false;
        }
        return true;
    }

    private static long power(long x, long y, long p) {
        long res = 1L;
        x %= p;
        while (y > 0L) {
            if ((y & 1L) == 1L) {
                res = res * x % p;
            }
            y >>= 1;
            x = x * x % p;
        }
        return res;
    }

    public static double round(double x, int decimal) {
        if (decimal < 0) {
            return (double)Math.round(x / Math.pow(10.0, -decimal)) * Math.pow(10.0, -decimal);
        }
        return (double)Math.round(x * Math.pow(10.0, decimal)) / Math.pow(10.0, decimal);
    }

    public static double factorial(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("n has to be non-negative.");
        }
        double f = 1.0;
        for (int i = 2; i <= n; ++i) {
            f *= (double)i;
        }
        return f;
    }

    public static double lfactorial(int n) {
        if (n < 0) {
            throw new IllegalArgumentException(String.format("n has to be non-negative: %d", n));
        }
        double f = 0.0;
        for (int i = 2; i <= n; ++i) {
            f += Math.log(i);
        }
        return f;
    }

    public static double choose(int n, int k) {
        if (n < 0 || k < 0) {
            throw new IllegalArgumentException(String.format("Invalid n = %d, k = %d", n, k));
        }
        if (n < k) {
            return 0.0;
        }
        return Math.floor(0.5 + Math.exp(MathEx.lchoose(n, k)));
    }

    public static double lchoose(int n, int k) {
        if (n < 0 || k < 0 || k > n) {
            throw new IllegalArgumentException(String.format("Invalid n = %d, k = %d", n, k));
        }
        return MathEx.lfactorial(n) - MathEx.lfactorial(k) - MathEx.lfactorial(n - k);
    }

    public static void setSeed(long seed) {
        if (seeds.isEmpty()) {
            seedRNG.setSeed(seed);
            random.get().setSeed(seed);
            seeds.clear();
            seeds.add(seed);
        } else {
            random.get().setSeed(seed);
            seeds.add(seed);
        }
    }

    public static void setSeed() {
        SecureRandom sr = new SecureRandom();
        byte[] bytes = sr.generateSeed(8);
        long seed = 0L;
        for (int i = 0; i < 8; ++i) {
            seed <<= 8;
            seed |= (long)(bytes[i] & 0xFF);
        }
        MathEx.setSeed(seed);
    }

    public static long probablePrime(long n, int k) {
        return MathEx.probablePrime(n, k, random.get());
    }

    private static long probablePrime(long n, int k, Random rng) {
        long seed = n + (long)rng.nextInt(899999963);
        for (int i = 0; i < 4096 && !MathEx.isProbablePrime(seed, k, rng); ++i) {
            seed = n + (long)rng.nextInt(899999963);
        }
        return seed;
    }

    public static LongStream seeds(long n, int k) {
        return LongStream.generate(() -> MathEx.probablePrime(n, k, seedRNG));
    }

    public static int random(double[] prob) {
        int[] ans = MathEx.random(prob, 1);
        return ans[0];
    }

    public static int[] random(double[] prob, int n) {
        double[] q = new double[prob.length];
        for (int i = 0; i < prob.length; ++i) {
            q[i] = prob[i] * (double)prob.length;
        }
        int[] a = new int[prob.length];
        for (int i = 0; i < prob.length; ++i) {
            a[i] = i;
        }
        int[] HL = new int[prob.length];
        int head = 0;
        int tail = prob.length - 1;
        for (int i = 0; i < prob.length; ++i) {
            if (q[i] >= 1.0) {
                HL[head++] = i;
                continue;
            }
            HL[tail--] = i;
        }
        while (head != 0 && tail != prob.length - 1) {
            int k;
            int j = HL[tail + 1];
            a[j] = k = HL[head - 1];
            int n2 = k;
            q[n2] = q[n2] + (q[j] - 1.0);
            ++tail;
            if (!(q[k] < 1.0)) continue;
            HL[tail--] = k;
            --head;
        }
        int[] ans = new int[n];
        for (int i = 0; i < n; ++i) {
            int k;
            double rU = MathEx.random() * (double)prob.length;
            ans[i] = (rU -= (double)(k = (int)rU)) < q[k] ? k : a[k];
        }
        return ans;
    }

    public static double random() {
        return random.get().nextDouble();
    }

    public static double[] random(int n) {
        double[] x = new double[n];
        random.get().nextDoubles(x);
        return x;
    }

    public static double random(double lo, double hi) {
        return random.get().nextDouble(lo, hi);
    }

    public static double[] random(double lo, double hi, int n) {
        double[] x = new double[n];
        random.get().nextDoubles(x, lo, hi);
        return x;
    }

    public static long randomLong() {
        return random.get().nextLong();
    }

    public static int randomInt(int n) {
        return random.get().nextInt(n);
    }

    public static int randomInt(int lo, int hi) {
        int w = hi - lo;
        return lo + random.get().nextInt(w);
    }

    public static int[] permutate(int n) {
        return random.get().permutate(n);
    }

    public static void permutate(int[] x) {
        random.get().permutate(x);
    }

    public static void permutate(float[] x) {
        random.get().permutate(x);
    }

    public static void permutate(double[] x) {
        random.get().permutate(x);
    }

    public static void permutate(Object[] x) {
        random.get().permutate(x);
    }

    public static int softmax(double[] posteriori) {
        return MathEx.softmax(posteriori, posteriori.length);
    }

    public static int softmax(double[] x, int k) {
        int i;
        int y = -1;
        double max = Double.NEGATIVE_INFINITY;
        for (int i2 = 0; i2 < k; ++i2) {
            if (!(x[i2] > max)) continue;
            max = x[i2];
            y = i2;
        }
        double Z = 0.0;
        for (i = 0; i < k; ++i) {
            double out;
            x[i] = out = Math.exp(x[i] - max);
            Z += out;
        }
        i = 0;
        while (i < k) {
            int n = i++;
            x[n] = x[n] / Z;
        }
        return y;
    }

    public static int[] c(int ... x) {
        return x;
    }

    public static float[] c(float ... x) {
        return x;
    }

    public static double[] c(double ... x) {
        return x;
    }

    public static String[] c(String ... x) {
        return x;
    }

    public static int[] c(int[] ... list) {
        int n = 0;
        for (int[] x : list) {
            n += x.length;
        }
        int[] y = new int[n];
        int pos = 0;
        for (int[] x : list) {
            System.arraycopy(x, 0, y, pos, x.length);
            pos += x.length;
        }
        return y;
    }

    public static float[] c(float[] ... list) {
        int n = 0;
        for (float[] x : list) {
            n += x.length;
        }
        float[] y = new float[n];
        int pos = 0;
        for (float[] x : list) {
            System.arraycopy(x, 0, y, pos, x.length);
            pos += x.length;
        }
        return y;
    }

    public static double[] c(double[] ... list) {
        int n = 0;
        for (double[] x : list) {
            n += x.length;
        }
        double[] y = new double[n];
        int pos = 0;
        for (double[] x : list) {
            System.arraycopy(x, 0, y, pos, x.length);
            pos += x.length;
        }
        return y;
    }

    public static String[] c(String[] ... list) {
        int n = 0;
        for (String[] x : list) {
            n += x.length;
        }
        String[] y = new String[n];
        int pos = 0;
        for (String[] x : list) {
            System.arraycopy(x, 0, y, pos, x.length);
            pos += x.length;
        }
        return y;
    }

    public static int[] cbind(int[] ... x) {
        return MathEx.c(x);
    }

    public static float[] cbind(float[] ... x) {
        return MathEx.c(x);
    }

    public static double[] cbind(double[] ... x) {
        return MathEx.c(x);
    }

    public static String[] cbind(String[] ... x) {
        return MathEx.c(x);
    }

    public static int[][] rbind(int[] ... x) {
        return x;
    }

    public static float[][] rbind(float[] ... x) {
        return x;
    }

    public static double[][] rbind(double[] ... x) {
        return x;
    }

    public static String[][] rbind(String[] ... x) {
        return x;
    }

    public static <E> E[] slice(E[] data, int[] index) {
        int n = index.length;
        Object[] x = (Object[])Array.newInstance(data.getClass().getComponentType(), n);
        for (int i = 0; i < n; ++i) {
            x[i] = data[index[i]];
        }
        return x;
    }

    public static int[] slice(int[] data, int[] index) {
        int n = index.length;
        int[] x = new int[n];
        for (int i = 0; i < n; ++i) {
            x[i] = data[index[i]];
        }
        return x;
    }

    public static float[] slice(float[] data, int[] index) {
        int n = index.length;
        float[] x = new float[n];
        for (int i = 0; i < n; ++i) {
            x[i] = data[index[i]];
        }
        return x;
    }

    public static double[] slice(double[] data, int[] index) {
        int n = index.length;
        double[] x = new double[n];
        for (int i = 0; i < n; ++i) {
            x[i] = data[index[i]];
        }
        return x;
    }

    public static boolean contains(double[][] polygon, double[] point) {
        return MathEx.contains(polygon, point[0], point[1]);
    }

    /*
     * Unable to fully structure code
     */
    public static boolean contains(double[][] polygon, double x, double y) {
        if (polygon.length <= 2) {
            return false;
        }
        hits = 0;
        n = polygon.length;
        lastx = polygon[n - 1][0];
        lasty = polygon[n - 1][1];
        for (i = 0; i < n; ++i) {
            block8: {
                block11: {
                    block12: {
                        block10: {
                            block9: {
                                curx = polygon[i][0];
                                cury = polygon[i][1];
                                if (cury == lasty) break block8;
                                if (!(curx < lastx)) break block9;
                                if (x >= lastx) break block8;
                                leftx = curx;
                                break block10;
                            }
                            if (x >= curx) break block8;
                            leftx = lastx;
                        }
                        if (!(cury < lasty)) break block11;
                        if (y < cury || y >= lasty) break block8;
                        if (!(x < leftx)) break block12;
                        ++hits;
                        break block8;
                    }
                    test1 = x - curx;
                    test2 = y - cury;
                    ** GOTO lbl35
                }
                if (y < lasty || y >= cury) break block8;
                if (x < leftx) {
                    ++hits;
                } else {
                    test1 = x - lastx;
                    test2 = y - lasty;
lbl35:
                    // 2 sources

                    if (test1 < test2 / (lasty - cury) * (lastx - curx)) {
                        ++hits;
                    }
                }
            }
            lastx = curx;
            lasty = cury;
        }
        return (hits & true) != false;
    }

    public static void reverse(int[] a) {
        int i = 0;
        int j = a.length - 1;
        while (i < j) {
            Sort.swap(a, i++, j--);
        }
    }

    public static void reverse(float[] a) {
        int i = 0;
        int j = a.length - 1;
        while (i < j) {
            Sort.swap(a, i++, j--);
        }
    }

    public static void reverse(double[] a) {
        int i = 0;
        int j = a.length - 1;
        while (i < j) {
            Sort.swap(a, i++, j--);
        }
    }

    public static <T> void reverse(T[] a) {
        int i = 0;
        int j = a.length - 1;
        while (i < j) {
            Sort.swap(a, i++, j--);
        }
    }

    public static int min(int a, int b, int c) {
        return Math.min(Math.min(a, b), c);
    }

    public static double min(float a, float b, float c) {
        return Math.min(Math.min(a, b), c);
    }

    public static double min(double a, double b, double c) {
        return Math.min(Math.min(a, b), c);
    }

    public static int min(int a, int b, int c, int d) {
        return Math.min(Math.min(Math.min(a, b), c), d);
    }

    public static double min(float a, float b, float c, float d) {
        return Math.min(Math.min(Math.min(a, b), c), d);
    }

    public static double min(double a, double b, double c, double d) {
        return Math.min(Math.min(Math.min(a, b), c), d);
    }

    public static int max(int a, int b, int c) {
        return Math.max(Math.max(a, b), c);
    }

    public static float max(float a, float b, float c) {
        return Math.max(Math.max(a, b), c);
    }

    public static double max(double a, double b, double c) {
        return Math.max(Math.max(a, b), c);
    }

    public static int max(int a, int b, int c, int d) {
        return Math.max(Math.max(Math.max(a, b), c), d);
    }

    public static float max(float a, float b, float c, float d) {
        return Math.max(Math.max(Math.max(a, b), c), d);
    }

    public static double max(double a, double b, double c, double d) {
        return Math.max(Math.max(Math.max(a, b), c), d);
    }

    public static int min(int[] x) {
        int min = x[0];
        for (int n : x) {
            if (n >= min) continue;
            min = n;
        }
        return min;
    }

    public static float min(float[] x) {
        float min = Float.POSITIVE_INFINITY;
        for (float n : x) {
            if (!(n < min)) continue;
            min = n;
        }
        return min;
    }

    public static double min(double[] x) {
        double min = Double.POSITIVE_INFINITY;
        for (double n : x) {
            if (!(n < min)) continue;
            min = n;
        }
        return min;
    }

    public static int whichMin(int[] x) {
        int min = x[0];
        int which = 0;
        for (int i = 1; i < x.length; ++i) {
            if (x[i] >= min) continue;
            min = x[i];
            which = i;
        }
        return which;
    }

    public static int whichMin(float[] x) {
        float min = Float.POSITIVE_INFINITY;
        int which = 0;
        for (int i = 0; i < x.length; ++i) {
            if (!(x[i] < min)) continue;
            min = x[i];
            which = i;
        }
        return which;
    }

    public static int whichMin(double[] x) {
        double min = Double.POSITIVE_INFINITY;
        int which = 0;
        for (int i = 0; i < x.length; ++i) {
            if (!(x[i] < min)) continue;
            min = x[i];
            which = i;
        }
        return which;
    }

    public static IntPair whichMin(double[][] x) {
        double min = Double.POSITIVE_INFINITY;
        int whichRow = 0;
        int whichCol = 0;
        for (int i = 0; i < x.length; ++i) {
            for (int j = 0; j < x[i].length; ++j) {
                if (!(x[i][j] < min)) continue;
                min = x[i][j];
                whichRow = i;
                whichCol = j;
            }
        }
        return new IntPair(whichRow, whichCol);
    }

    public static int max(int[] x) {
        int max = x[0];
        for (int n : x) {
            if (n <= max) continue;
            max = n;
        }
        return max;
    }

    public static float max(float[] x) {
        float max = Float.NEGATIVE_INFINITY;
        for (float n : x) {
            if (!(n > max)) continue;
            max = n;
        }
        return max;
    }

    public static double max(double[] x) {
        double max = Double.NEGATIVE_INFINITY;
        for (double n : x) {
            if (!(n > max)) continue;
            max = n;
        }
        return max;
    }

    public static int whichMax(int[] x) {
        int max = x[0];
        int which = 0;
        for (int i = 1; i < x.length; ++i) {
            if (x[i] <= max) continue;
            max = x[i];
            which = i;
        }
        return which;
    }

    public static int whichMax(float[] x) {
        float max = Float.NEGATIVE_INFINITY;
        int which = 0;
        for (int i = 0; i < x.length; ++i) {
            if (!(x[i] > max)) continue;
            max = x[i];
            which = i;
        }
        return which;
    }

    public static int whichMax(double[] x) {
        double max = Double.NEGATIVE_INFINITY;
        int which = 0;
        for (int i = 0; i < x.length; ++i) {
            if (!(x[i] > max)) continue;
            max = x[i];
            which = i;
        }
        return which;
    }

    public static IntPair whichMax(double[][] x) {
        double max = Double.NEGATIVE_INFINITY;
        int whichRow = 0;
        int whichCol = 0;
        for (int i = 0; i < x.length; ++i) {
            for (int j = 0; j < x[i].length; ++j) {
                if (!(x[i][j] > max)) continue;
                max = x[i][j];
                whichRow = i;
                whichCol = j;
            }
        }
        return new IntPair(whichRow, whichCol);
    }

    public static int min(int[][] matrix) {
        int min = matrix[0][0];
        int[][] nArray = matrix;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int[] x;
            for (int y : x = nArray[i]) {
                if (min <= y) continue;
                min = y;
            }
        }
        return min;
    }

    public static double min(double[][] matrix) {
        double min = Double.POSITIVE_INFINITY;
        double[][] dArray = matrix;
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            double[] x;
            for (double y : x = dArray[i]) {
                if (!(min > y)) continue;
                min = y;
            }
        }
        return min;
    }

    public static int max(int[][] matrix) {
        int max = matrix[0][0];
        int[][] nArray = matrix;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int[] x;
            for (int y : x = nArray[i]) {
                if (max >= y) continue;
                max = y;
            }
        }
        return max;
    }

    public static double max(double[][] matrix) {
        double max = Double.NEGATIVE_INFINITY;
        double[][] dArray = matrix;
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            double[] x;
            for (double y : x = dArray[i]) {
                if (!(max < y)) continue;
                max = y;
            }
        }
        return max;
    }

    public static double[][] transpose(double[][] A) {
        int m = A.length;
        int n = A[0].length;
        double[][] matrix = new double[n][m];
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                matrix[j][i] = A[i][j];
            }
        }
        return matrix;
    }

    public static int[] rowMin(int[][] data) {
        int[] x = new int[data.length];
        for (int i = 0; i < x.length; ++i) {
            x[i] = MathEx.min(data[i]);
        }
        return x;
    }

    public static int[] rowMax(int[][] data) {
        int[] x = new int[data.length];
        for (int i = 0; i < x.length; ++i) {
            x[i] = MathEx.max(data[i]);
        }
        return x;
    }

    public static long[] rowSums(int[][] data) {
        long[] x = new long[data.length];
        for (int i = 0; i < x.length; ++i) {
            x[i] = MathEx.sum(data[i]);
        }
        return x;
    }

    public static double[] rowMin(double[][] data) {
        double[] x = new double[data.length];
        for (int i = 0; i < x.length; ++i) {
            x[i] = MathEx.min(data[i]);
        }
        return x;
    }

    public static double[] rowMax(double[][] data) {
        double[] x = new double[data.length];
        for (int i = 0; i < x.length; ++i) {
            x[i] = MathEx.max(data[i]);
        }
        return x;
    }

    public static double[] rowSums(double[][] data) {
        double[] x = new double[data.length];
        for (int i = 0; i < x.length; ++i) {
            x[i] = MathEx.sum(data[i]);
        }
        return x;
    }

    public static double[] rowMeans(double[][] data) {
        double[] x = new double[data.length];
        for (int i = 0; i < x.length; ++i) {
            x[i] = MathEx.mean(data[i]);
        }
        return x;
    }

    public static double[] rowSds(double[][] data) {
        double[] x = new double[data.length];
        for (int i = 0; i < x.length; ++i) {
            x[i] = MathEx.sd(data[i]);
        }
        return x;
    }

    public static int[] colMin(int[][] data) {
        int[] x = new int[data[0].length];
        Arrays.fill(x, Integer.MAX_VALUE);
        for (int i = 0; i < data.length; ++i) {
            for (int j = 0; j < x.length; ++j) {
                if (x[j] <= data[i][j]) continue;
                x[j] = data[i][j];
            }
        }
        return x;
    }

    public static int[] colMax(int[][] data) {
        int[] x = new int[data[0].length];
        Arrays.fill(x, Integer.MIN_VALUE);
        for (int i = 0; i < data.length; ++i) {
            for (int j = 0; j < x.length; ++j) {
                if (x[j] >= data[i][j]) continue;
                x[j] = data[i][j];
            }
        }
        return x;
    }

    public static long[] colSums(int[][] data) {
        long[] x = new long[data[0].length];
        for (int i = 0; i < data.length; ++i) {
            for (int j = 0; j < x.length; ++j) {
                int n = j;
                x[n] = x[n] + (long)data[i][j];
            }
        }
        return x;
    }

    public static double[] colMin(double[][] data) {
        double[] x = new double[data[0].length];
        Arrays.fill(x, Double.POSITIVE_INFINITY);
        for (int i = 0; i < data.length; ++i) {
            for (int j = 0; j < x.length; ++j) {
                if (!(x[j] > data[i][j])) continue;
                x[j] = data[i][j];
            }
        }
        return x;
    }

    public static double[] colMax(double[][] data) {
        double[] x = new double[data[0].length];
        Arrays.fill(x, Double.NEGATIVE_INFINITY);
        for (int i = 0; i < data.length; ++i) {
            for (int j = 0; j < x.length; ++j) {
                if (!(x[j] < data[i][j])) continue;
                x[j] = data[i][j];
            }
        }
        return x;
    }

    public static double[] colSums(double[][] data) {
        double[] x = (double[])data[0].clone();
        for (int i = 1; i < data.length; ++i) {
            for (int j = 0; j < x.length; ++j) {
                int n = j;
                x[n] = x[n] + data[i][j];
            }
        }
        return x;
    }

    public static double[] colMeans(double[][] data) {
        double[] x = (double[])data[0].clone();
        for (int i = 1; i < data.length; ++i) {
            for (int j = 0; j < x.length; ++j) {
                int n = j;
                x[n] = x[n] + data[i][j];
            }
        }
        MathEx.scale(1.0 / (double)data.length, x);
        return x;
    }

    public static double[] colSds(double[][] data) {
        if (data.length < 2) {
            throw new IllegalArgumentException("Array length is less than 2.");
        }
        int p = data[0].length;
        double[] sum = new double[p];
        double[] sumsq = new double[p];
        for (double[] x : data) {
            for (int i = 0; i < p; ++i) {
                int n = i;
                sum[n] = sum[n] + x[i];
                int n2 = i;
                sumsq[n2] = sumsq[n2] + x[i] * x[i];
            }
        }
        int n = data.length - 1;
        for (int i = 0; i < p; ++i) {
            sumsq[i] = Math.sqrt(sumsq[i] / (double)n - sum[i] / (double)data.length * (sum[i] / (double)n));
        }
        return sumsq;
    }

    public static int sum(byte[] x) {
        int sum = 0;
        for (byte n : x) {
            sum += n;
        }
        return sum;
    }

    public static long sum(int[] x) {
        long sum = 0L;
        for (int n : x) {
            sum += (long)n;
        }
        return (int)sum;
    }

    public static double sum(float[] x) {
        double sum = 0.0;
        for (float n : x) {
            sum += (double)n;
        }
        return sum;
    }

    public static double sum(double[] x) {
        double sum = 0.0;
        for (double n : x) {
            sum += n;
        }
        return sum;
    }

    public static int median(int[] a) {
        return QuickSelect.median(a);
    }

    public static float median(float[] a) {
        return QuickSelect.median(a);
    }

    public static double median(double[] a) {
        return QuickSelect.median(a);
    }

    public static <T extends Comparable<? super T>> T median(T[] a) {
        return (T)QuickSelect.median(a);
    }

    public static int q1(int[] a) {
        return QuickSelect.q1(a);
    }

    public static float q1(float[] a) {
        return QuickSelect.q1(a);
    }

    public static double q1(double[] a) {
        return QuickSelect.q1(a);
    }

    public static <T extends Comparable<? super T>> T q1(T[] a) {
        return (T)QuickSelect.q1(a);
    }

    public static int q3(int[] a) {
        return QuickSelect.q3(a);
    }

    public static float q3(float[] a) {
        return QuickSelect.q3(a);
    }

    public static double q3(double[] a) {
        return QuickSelect.q3(a);
    }

    public static <T extends Comparable<? super T>> T q3(T[] a) {
        return (T)QuickSelect.q3(a);
    }

    public static double mean(int[] x) {
        return (double)MathEx.sum(x) / (double)x.length;
    }

    public static double mean(float[] x) {
        return MathEx.sum(x) / (double)x.length;
    }

    public static double mean(double[] x) {
        return MathEx.sum(x) / (double)x.length;
    }

    public static double var(int[] x) {
        if (x.length < 2) {
            throw new IllegalArgumentException("Array length is less than 2.");
        }
        double sum = 0.0;
        double sumsq = 0.0;
        for (int xi : x) {
            sum += (double)xi;
            sumsq += (double)(xi * xi);
        }
        int n = x.length - 1;
        return sumsq / (double)n - sum / (double)x.length * (sum / (double)n);
    }

    public static double var(float[] x) {
        if (x.length < 2) {
            throw new IllegalArgumentException("Array length is less than 2.");
        }
        double sum = 0.0;
        double sumsq = 0.0;
        for (float xi : x) {
            sum += (double)xi;
            sumsq += (double)(xi * xi);
        }
        int n = x.length - 1;
        return sumsq / (double)n - sum / (double)x.length * (sum / (double)n);
    }

    public static double var(double[] x) {
        if (x.length < 2) {
            throw new IllegalArgumentException("Array length is less than 2.");
        }
        double sum = 0.0;
        double sumsq = 0.0;
        for (double xi : x) {
            sum += xi;
            sumsq += xi * xi;
        }
        int n = x.length - 1;
        return sumsq / (double)n - sum / (double)x.length * (sum / (double)n);
    }

    public static double sd(int[] x) {
        return Math.sqrt(MathEx.var(x));
    }

    public static double sd(float[] x) {
        return Math.sqrt(MathEx.var(x));
    }

    public static double sd(double[] x) {
        return Math.sqrt(MathEx.var(x));
    }

    public static double mad(int[] x) {
        int m = MathEx.median(x);
        for (int i = 0; i < x.length; ++i) {
            x[i] = Math.abs(x[i] - m);
        }
        return MathEx.median(x);
    }

    public static double mad(float[] x) {
        float m = MathEx.median(x);
        for (int i = 0; i < x.length; ++i) {
            x[i] = Math.abs(x[i] - m);
        }
        return MathEx.median(x);
    }

    public static double mad(double[] x) {
        double m = MathEx.median(x);
        for (int i = 0; i < x.length; ++i) {
            x[i] = Math.abs(x[i] - m);
        }
        return MathEx.median(x);
    }

    public static boolean all(boolean[] x) {
        for (boolean b : x) {
            if (b) continue;
            return false;
        }
        return true;
    }

    public static boolean any(boolean[] x) {
        for (boolean b : x) {
            if (!b) continue;
            return true;
        }
        return false;
    }

    public static double distance(int[] x, int[] y) {
        return Math.sqrt(MathEx.squaredDistance(x, y));
    }

    public static double distance(float[] x, float[] y) {
        return Math.sqrt(MathEx.squaredDistance(x, y));
    }

    public static double distance(double[] x, double[] y) {
        return Math.sqrt(MathEx.squaredDistance(x, y));
    }

    public static double distance(SparseArray x, SparseArray y) {
        return Math.sqrt(MathEx.squaredDistance(x, y));
    }

    public static double[][] pdist(double[][] x) {
        int n = x.length;
        double[][] dist = new double[n][n];
        MathEx.pdist(x, dist, false, false);
        return dist;
    }

    public static void pdist(double[][] x, double[][] dist, boolean squared, boolean half) {
        int n = x.length;
        int N = n * (n - 1) / 2;
        if (squared) {
            IntStream.range(0, N).parallel().forEach(k -> {
                int j = n - 2 - (int)Math.floor(Math.sqrt(-8 * k + 4 * n * (n - 1) - 7) / 2.0 - 0.5);
                int i = k + j + 1 - n * (n - 1) / 2 + (n - j) * (n - j - 1) / 2;
                dist[i][j] = MathEx.squaredDistance(x[i], x[j]);
            });
        } else {
            IntStream.range(0, N).parallel().forEach(k -> {
                int j = n - 2 - (int)Math.floor(Math.sqrt(-8 * k + 4 * n * (n - 1) - 7) / 2.0 - 0.5);
                int i = k + j + 1 - n * (n - 1) / 2 + (n - j) * (n - j - 1) / 2;
                dist[i][j] = MathEx.distance(x[i], x[j]);
            });
        }
        if (!half) {
            for (int i = 0; i < n; ++i) {
                for (int j = i + 1; j < n; ++j) {
                    dist[i][j] = dist[j][i];
                }
            }
        }
    }

    public static double squaredDistance(int[] x, int[] y) {
        if (x.length != y.length) {
            throw new IllegalArgumentException("Input vector sizes are different.");
        }
        double sum = 0.0;
        for (int i = 0; i < x.length; ++i) {
            sum += MathEx.sqr(x[i] - y[i]);
        }
        return sum;
    }

    public static double squaredDistance(float[] x, float[] y) {
        if (x.length != y.length) {
            throw new IllegalArgumentException("Input vector sizes are different.");
        }
        double sum = 0.0;
        for (int i = 0; i < x.length; ++i) {
            sum += MathEx.sqr(x[i] - y[i]);
        }
        return sum;
    }

    public static double squaredDistance(double[] x, double[] y) {
        if (x.length != y.length) {
            throw new IllegalArgumentException("Input vector sizes are different.");
        }
        double sum = 0.0;
        for (int i = 0; i < x.length; ++i) {
            sum += MathEx.sqr(x[i] - y[i]);
        }
        return sum;
    }

    public static double squaredDistance(SparseArray x, SparseArray y) {
        Iterator<SparseArray.Entry> it1 = x.iterator();
        Iterator<SparseArray.Entry> it2 = y.iterator();
        SparseArray.Entry e1 = it1.hasNext() ? it1.next() : null;
        SparseArray.Entry e2 = it2.hasNext() ? it2.next() : null;
        double sum = 0.0;
        while (e1 != null && e2 != null) {
            if (e1.i == e2.i) {
                sum += MathEx.sqr(e1.x - e2.x);
                e1 = it1.hasNext() ? it1.next() : null;
                e2 = it2.hasNext() ? it2.next() : null;
                continue;
            }
            if (e1.i > e2.i) {
                sum += MathEx.sqr(e2.x);
                e2 = it2.hasNext() ? it2.next() : null;
                continue;
            }
            sum += MathEx.sqr(e1.x);
            e1 = it1.hasNext() ? it1.next() : null;
        }
        while (it1.hasNext()) {
            sum += MathEx.sqr(it1.next().x);
        }
        while (it2.hasNext()) {
            sum += MathEx.sqr(it2.next().x);
        }
        return sum;
    }

    public static double squaredDistanceWithMissingValues(double[] x, double[] y) {
        int n = x.length;
        int m = 0;
        double dist = 0.0;
        for (int i = 0; i < n; ++i) {
            if (Double.isNaN(x[i]) || Double.isNaN(y[i])) continue;
            ++m;
            double d = x[i] - y[i];
            dist += d * d;
        }
        dist = m == 0 ? Double.MAX_VALUE : (double)n * dist / (double)m;
        return dist;
    }

    public static double entropy(double[] p) {
        double h = 0.0;
        for (double pi : p) {
            if (!(pi > 0.0)) continue;
            h -= pi * Math.log(pi);
        }
        return h;
    }

    public static double KullbackLeiblerDivergence(double[] x, double[] y) {
        boolean intersection = false;
        double kl = 0.0;
        for (int i = 0; i < x.length; ++i) {
            if (x[i] == 0.0 || y[i] == 0.0) continue;
            intersection = true;
            kl += x[i] * Math.log(x[i] / y[i]);
        }
        if (intersection) {
            return kl;
        }
        return Double.POSITIVE_INFINITY;
    }

    public static double KullbackLeiblerDivergence(SparseArray x, SparseArray y) {
        if (x.isEmpty()) {
            throw new IllegalArgumentException("List x is empty.");
        }
        if (y.isEmpty()) {
            throw new IllegalArgumentException("List y is empty.");
        }
        Iterator<SparseArray.Entry> iterX = x.iterator();
        Iterator<SparseArray.Entry> iterY = y.iterator();
        SparseArray.Entry a = iterX.hasNext() ? iterX.next() : null;
        SparseArray.Entry b = iterY.hasNext() ? iterY.next() : null;
        boolean intersection = false;
        double kl = 0.0;
        while (a != null && b != null) {
            if (a.i < b.i) {
                a = iterX.hasNext() ? iterX.next() : null;
                continue;
            }
            if (a.i > b.i) {
                b = iterY.hasNext() ? iterY.next() : null;
                continue;
            }
            intersection = true;
            kl += a.x * Math.log(a.x / b.x);
            a = iterX.hasNext() ? iterX.next() : null;
            b = iterY.hasNext() ? iterY.next() : null;
        }
        if (intersection) {
            return kl;
        }
        return Double.POSITIVE_INFINITY;
    }

    public static double KullbackLeiblerDivergence(double[] x, SparseArray y) {
        return MathEx.KullbackLeiblerDivergence(y, x);
    }

    public static double KullbackLeiblerDivergence(SparseArray x, double[] y) {
        if (x.isEmpty()) {
            throw new IllegalArgumentException("List x is empty.");
        }
        Iterator<SparseArray.Entry> iter = x.iterator();
        boolean intersection = false;
        double kl = 0.0;
        while (iter.hasNext()) {
            SparseArray.Entry b = iter.next();
            int i = b.i;
            if (!(y[i] > 0.0)) continue;
            intersection = true;
            kl += b.x * Math.log(b.x / y[i]);
        }
        if (intersection) {
            return kl;
        }
        return Double.POSITIVE_INFINITY;
    }

    public static double JensenShannonDivergence(double[] x, double[] y) {
        double[] m = new double[x.length];
        for (int i = 0; i < m.length; ++i) {
            m[i] = (x[i] + y[i]) / 2.0;
        }
        return (MathEx.KullbackLeiblerDivergence(x, m) + MathEx.KullbackLeiblerDivergence(y, m)) / 2.0;
    }

    public static double JensenShannonDivergence(SparseArray x, SparseArray y) {
        if (x.isEmpty()) {
            throw new IllegalArgumentException("List x is empty.");
        }
        if (y.isEmpty()) {
            throw new IllegalArgumentException("List y is empty.");
        }
        Iterator<SparseArray.Entry> iterX = x.iterator();
        Iterator<SparseArray.Entry> iterY = y.iterator();
        SparseArray.Entry a = iterX.hasNext() ? iterX.next() : null;
        SparseArray.Entry b = iterY.hasNext() ? iterY.next() : null;
        double js = 0.0;
        while (a != null && b != null) {
            double mi;
            if (a.i < b.i) {
                mi = a.x / 2.0;
                js += a.x * Math.log(a.x / mi);
                a = iterX.hasNext() ? iterX.next() : null;
                continue;
            }
            if (a.i > b.i) {
                mi = b.x / 2.0;
                js += b.x * Math.log(b.x / mi);
                b = iterY.hasNext() ? iterY.next() : null;
                continue;
            }
            mi = (a.x + b.x) / 2.0;
            js += a.x * Math.log(a.x / mi) + b.x * Math.log(b.x / mi);
            a = iterX.hasNext() ? iterX.next() : null;
            b = iterY.hasNext() ? iterY.next() : null;
        }
        return js / 2.0;
    }

    public static double JensenShannonDivergence(double[] x, SparseArray y) {
        return MathEx.JensenShannonDivergence(y, x);
    }

    public static double JensenShannonDivergence(SparseArray x, double[] y) {
        if (x.isEmpty()) {
            throw new IllegalArgumentException("List x is empty.");
        }
        Iterator<SparseArray.Entry> iter = x.iterator();
        double js = 0.0;
        while (iter.hasNext()) {
            SparseArray.Entry b = iter.next();
            int i = b.i;
            double mi = (b.x + y[i]) / 2.0;
            js += b.x * Math.log(b.x / mi);
            if (!(y[i] > 0.0)) continue;
            js += y[i] * Math.log(y[i] / mi);
        }
        return js / 2.0;
    }

    public static int dot(int[] x, int[] y) {
        if (x.length != y.length) {
            throw new IllegalArgumentException("Arrays have different length.");
        }
        int p = 0;
        for (int i = 0; i < x.length; ++i) {
            p += x[i] * y[i];
        }
        return p;
    }

    public static float dot(float[] x, float[] y) {
        if (x.length != y.length) {
            throw new IllegalArgumentException("Arrays have different length.");
        }
        float p = 0.0f;
        for (int i = 0; i < x.length; ++i) {
            p += x[i] * y[i];
        }
        return p;
    }

    public static double dot(double[] x, double[] y) {
        if (x.length != y.length) {
            throw new IllegalArgumentException("Arrays have different length.");
        }
        double p = 0.0;
        for (int i = 0; i < x.length; ++i) {
            p += x[i] * y[i];
        }
        return p;
    }

    public static double dot(SparseArray x, SparseArray y) {
        Iterator<SparseArray.Entry> it1 = x.iterator();
        Iterator<SparseArray.Entry> it2 = y.iterator();
        SparseArray.Entry e1 = it1.hasNext() ? it1.next() : null;
        SparseArray.Entry e2 = it2.hasNext() ? it2.next() : null;
        double s = 0.0;
        while (e1 != null && e2 != null) {
            if (e1.i == e2.i) {
                s += e1.x * e2.x;
                e1 = it1.hasNext() ? it1.next() : null;
                e2 = it2.hasNext() ? it2.next() : null;
                continue;
            }
            if (e1.i > e2.i) {
                e2 = it2.hasNext() ? it2.next() : null;
                continue;
            }
            e1 = it1.hasNext() ? it1.next() : null;
        }
        return s;
    }

    public static double cov(int[] x, int[] y) {
        if (x.length != y.length) {
            throw new IllegalArgumentException("Arrays have different length.");
        }
        if (x.length < 3) {
            throw new IllegalArgumentException("array length has to be at least 3.");
        }
        double mx = MathEx.mean(x);
        double my = MathEx.mean(y);
        double Sxy = 0.0;
        for (int i = 0; i < x.length; ++i) {
            double dx = (double)x[i] - mx;
            double dy = (double)y[i] - my;
            Sxy += dx * dy;
        }
        return Sxy / (double)(x.length - 1);
    }

    public static double cov(float[] x, float[] y) {
        if (x.length != y.length) {
            throw new IllegalArgumentException("Arrays have different length.");
        }
        if (x.length < 3) {
            throw new IllegalArgumentException("array length has to be at least 3.");
        }
        double mx = MathEx.mean(x);
        double my = MathEx.mean(y);
        double Sxy = 0.0;
        for (int i = 0; i < x.length; ++i) {
            double dx = (double)x[i] - mx;
            double dy = (double)y[i] - my;
            Sxy += dx * dy;
        }
        return Sxy / (double)(x.length - 1);
    }

    public static double cov(double[] x, double[] y) {
        if (x.length != y.length) {
            throw new IllegalArgumentException("Arrays have different length.");
        }
        if (x.length < 3) {
            throw new IllegalArgumentException("array length has to be at least 3.");
        }
        double mx = MathEx.mean(x);
        double my = MathEx.mean(y);
        double Sxy = 0.0;
        for (int i = 0; i < x.length; ++i) {
            double dx = x[i] - mx;
            double dy = y[i] - my;
            Sxy += dx * dy;
        }
        return Sxy / (double)(x.length - 1);
    }

    public static double[][] cov(double[][] data) {
        return MathEx.cov(data, MathEx.colMeans(data));
    }

    public static double[][] cov(double[][] data, double[] mu) {
        int k;
        int j;
        double[][] sigma = new double[data[0].length][data[0].length];
        for (int i = 0; i < data.length; ++i) {
            for (j = 0; j < mu.length; ++j) {
                for (k = 0; k <= j; ++k) {
                    double[] dArray = sigma[j];
                    int n = k;
                    dArray[n] = dArray[n] + (data[i][j] - mu[j]) * (data[i][k] - mu[k]);
                }
            }
        }
        int n = data.length - 1;
        for (j = 0; j < mu.length; ++j) {
            for (k = 0; k <= j; ++k) {
                double[] dArray = sigma[j];
                int n2 = k;
                dArray[n2] = dArray[n2] / (double)n;
                sigma[k][j] = sigma[j][k];
            }
        }
        return sigma;
    }

    public static double cor(int[] x, int[] y) {
        if (x.length != y.length) {
            throw new IllegalArgumentException("Arrays have different length.");
        }
        if (x.length < 3) {
            throw new IllegalArgumentException("array length has to be at least 3.");
        }
        double Sxy = MathEx.cov(x, y);
        double Sxx = MathEx.var(x);
        double Syy = MathEx.var(y);
        if (Sxx == 0.0 || Syy == 0.0) {
            return Double.NaN;
        }
        return Sxy / Math.sqrt(Sxx * Syy);
    }

    public static double cor(float[] x, float[] y) {
        if (x.length != y.length) {
            throw new IllegalArgumentException("Arrays have different length.");
        }
        if (x.length < 3) {
            throw new IllegalArgumentException("array length has to be at least 3.");
        }
        double Sxy = MathEx.cov(x, y);
        double Sxx = MathEx.var(x);
        double Syy = MathEx.var(y);
        if (Sxx == 0.0 || Syy == 0.0) {
            return Double.NaN;
        }
        return Sxy / Math.sqrt(Sxx * Syy);
    }

    public static double cor(double[] x, double[] y) {
        if (x.length != y.length) {
            throw new IllegalArgumentException("Arrays have different length.");
        }
        if (x.length < 3) {
            throw new IllegalArgumentException("array length has to be at least 3.");
        }
        double Sxy = MathEx.cov(x, y);
        double Sxx = MathEx.var(x);
        double Syy = MathEx.var(y);
        if (Sxx == 0.0 || Syy == 0.0) {
            return Double.NaN;
        }
        return Sxy / Math.sqrt(Sxx * Syy);
    }

    public static double[][] cor(double[][] data) {
        return MathEx.cor(data, MathEx.colMeans(data));
    }

    public static double[][] cor(double[][] data, double[] mu) {
        int i;
        double[][] sigma = MathEx.cov(data, mu);
        int n = data[0].length;
        double[] sd = new double[n];
        for (i = 0; i < n; ++i) {
            sd[i] = Math.sqrt(sigma[i][i]);
        }
        for (i = 0; i < n; ++i) {
            for (int j = 0; j <= i; ++j) {
                double[] dArray = sigma[i];
                int n2 = j;
                dArray[n2] = dArray[n2] / (sd[i] * sd[j]);
                sigma[j][i] = sigma[i][j];
            }
        }
        return sigma;
    }

    private static double crank(double[] w) {
        int n = w.length;
        double s = 0.0;
        int j = 1;
        while (j < n) {
            int jt;
            if (w[j] != w[j - 1]) {
                w[j - 1] = j;
                ++j;
                continue;
            }
            for (jt = j + 1; jt <= n && w[jt - 1] == w[j - 1]; ++jt) {
            }
            double rank = 0.5 * (double)(j + jt - 1);
            for (int ji = j; ji <= jt - 1; ++ji) {
                w[ji - 1] = rank;
            }
            double t2 = jt - j;
            s += t2 * t2 * t2 - t2;
            j = jt;
        }
        if (j == n) {
            w[n - 1] = n;
        }
        return s;
    }

    public static double spearman(int[] x, int[] y) {
        if (x.length != y.length) {
            throw new IllegalArgumentException("Input vector sizes are different.");
        }
        int n = x.length;
        double[] wksp1 = new double[n];
        double[] wksp2 = new double[n];
        for (int j = 0; j < n; ++j) {
            wksp1[j] = x[j];
            wksp2[j] = y[j];
        }
        QuickSort.sort(wksp1, wksp2);
        MathEx.crank(wksp1);
        QuickSort.sort(wksp2, wksp1);
        MathEx.crank(wksp2);
        return MathEx.cor(wksp1, wksp2);
    }

    public static double spearman(float[] x, float[] y) {
        if (x.length != y.length) {
            throw new IllegalArgumentException("Input vector sizes are different.");
        }
        int n = x.length;
        double[] wksp1 = new double[n];
        double[] wksp2 = new double[n];
        for (int j = 0; j < n; ++j) {
            wksp1[j] = x[j];
            wksp2[j] = y[j];
        }
        QuickSort.sort(wksp1, wksp2);
        MathEx.crank(wksp1);
        QuickSort.sort(wksp2, wksp1);
        MathEx.crank(wksp2);
        return MathEx.cor(wksp1, wksp2);
    }

    public static double spearman(double[] x, double[] y) {
        if (x.length != y.length) {
            throw new IllegalArgumentException("Input vector sizes are different.");
        }
        double[] wksp1 = (double[])x.clone();
        double[] wksp2 = (double[])y.clone();
        QuickSort.sort(wksp1, wksp2);
        MathEx.crank(wksp1);
        QuickSort.sort(wksp2, wksp1);
        MathEx.crank(wksp2);
        return MathEx.cor(wksp1, wksp2);
    }

    public static double kendall(int[] x, int[] y) {
        if (x.length != y.length) {
            throw new IllegalArgumentException("Input vector sizes are different.");
        }
        int is = 0;
        int n2 = 0;
        int n1 = 0;
        int n = x.length;
        for (int j = 0; j < n - 1; ++j) {
            for (int k = j + 1; k < n; ++k) {
                double a1 = x[j] - x[k];
                double a2 = y[j] - y[k];
                double aa = a1 * a2;
                if (aa != 0.0) {
                    ++n1;
                    ++n2;
                    if (aa > 0.0) {
                        ++is;
                        continue;
                    }
                    --is;
                    continue;
                }
                if (a1 != 0.0) {
                    ++n1;
                }
                if (a2 == 0.0) continue;
                ++n2;
            }
        }
        double tau = (double)is / (Math.sqrt(n1) * Math.sqrt(n2));
        return tau;
    }

    public static double kendall(float[] x, float[] y) {
        if (x.length != y.length) {
            throw new IllegalArgumentException("Input vector sizes are different.");
        }
        int is = 0;
        int n2 = 0;
        int n1 = 0;
        int n = x.length;
        for (int j = 0; j < n - 1; ++j) {
            for (int k = j + 1; k < n; ++k) {
                double a1 = x[j] - x[k];
                double a2 = y[j] - y[k];
                double aa = a1 * a2;
                if (aa != 0.0) {
                    ++n1;
                    ++n2;
                    if (aa > 0.0) {
                        ++is;
                        continue;
                    }
                    --is;
                    continue;
                }
                if (a1 != 0.0) {
                    ++n1;
                }
                if (a2 == 0.0) continue;
                ++n2;
            }
        }
        double tau = (double)is / (Math.sqrt(n1) * Math.sqrt(n2));
        return tau;
    }

    public static double kendall(double[] x, double[] y) {
        if (x.length != y.length) {
            throw new IllegalArgumentException("Input vector sizes are different.");
        }
        int is = 0;
        int n2 = 0;
        int n1 = 0;
        int n = x.length;
        for (int j = 0; j < n - 1; ++j) {
            for (int k = j + 1; k < n; ++k) {
                double a1 = x[j] - x[k];
                double a2 = y[j] - y[k];
                double aa = a1 * a2;
                if (aa != 0.0) {
                    ++n1;
                    ++n2;
                    if (aa > 0.0) {
                        ++is;
                        continue;
                    }
                    --is;
                    continue;
                }
                if (a1 != 0.0) {
                    ++n1;
                }
                if (a2 == 0.0) continue;
                ++n2;
            }
        }
        double tau = (double)is / (Math.sqrt(n1) * Math.sqrt(n2));
        return tau;
    }

    public static float norm1(float[] x) {
        float norm = 0.0f;
        for (float n : x) {
            norm += Math.abs(n);
        }
        return norm;
    }

    public static double norm1(double[] x) {
        double norm = 0.0;
        for (double n : x) {
            norm += Math.abs(n);
        }
        return norm;
    }

    public static float norm2(float[] x) {
        float norm = 0.0f;
        for (float n : x) {
            norm += n * n;
        }
        norm = (float)Math.sqrt(norm);
        return norm;
    }

    public static double norm2(double[] x) {
        double norm = 0.0;
        for (double n : x) {
            norm += n * n;
        }
        norm = Math.sqrt(norm);
        return norm;
    }

    public static float normInf(float[] x) {
        int n = x.length;
        float f = Math.abs(x[0]);
        for (int i = 1; i < n; ++i) {
            f = Math.max(f, Math.abs(x[i]));
        }
        return f;
    }

    public static double normInf(double[] x) {
        int n = x.length;
        double f = Math.abs(x[0]);
        for (int i = 1; i < n; ++i) {
            f = Math.max(f, Math.abs(x[i]));
        }
        return f;
    }

    public static float norm(float[] x) {
        return MathEx.norm2(x);
    }

    public static double norm(double[] x) {
        return MathEx.norm2(x);
    }

    public static float cos(float[] x, float[] y) {
        return MathEx.dot(x, y) / (MathEx.norm2(x) * MathEx.norm2(y));
    }

    public static double cos(double[] x, double[] y) {
        return MathEx.dot(x, y) / (MathEx.norm2(x) * MathEx.norm2(y));
    }

    public static void standardize(double[] x) {
        double mu = MathEx.mean(x);
        double sigma = MathEx.sd(x);
        if (MathEx.isZero(sigma)) {
            logger.warn("array has variance of 0.");
            return;
        }
        for (int i = 0; i < x.length; ++i) {
            x[i] = (x[i] - mu) / sigma;
        }
    }

    public static void scale(double[][] x) {
        int n = x.length;
        int p = x[0].length;
        double[] min = MathEx.colMin(x);
        double[] max = MathEx.colMax(x);
        for (int j = 0; j < p; ++j) {
            int i;
            double scale = max[j] - min[j];
            if (!MathEx.isZero(scale)) {
                for (i = 0; i < n; ++i) {
                    x[i][j] = (x[i][j] - min[j]) / scale;
                }
                continue;
            }
            for (i = 0; i < n; ++i) {
                x[i][j] = 0.5;
            }
        }
    }

    public static void standardize(double[][] x) {
        int j;
        int n = x.length;
        int p = x[0].length;
        double[] center = MathEx.colMeans(x);
        for (int i = 0; i < n; ++i) {
            for (j = 0; j < p; ++j) {
                x[i][j] = x[i][j] - center[j];
            }
        }
        double[] scale = new double[p];
        for (j = 0; j < p; ++j) {
            int i;
            for (i = 0; i < n; ++i) {
                int n2 = j;
                scale[n2] = scale[n2] + MathEx.sqr(x[i][j]);
            }
            scale[j] = Math.sqrt(scale[j] / (double)(n - 1));
            if (MathEx.isZero(scale[j])) continue;
            for (i = 0; i < n; ++i) {
                double[] dArray = x[i];
                int n3 = j;
                dArray[n3] = dArray[n3] / scale[j];
            }
        }
    }

    public static void normalize(double[][] x) {
        MathEx.normalize(x, false);
    }

    public static void normalize(double[][] x, boolean centerizing) {
        int j;
        int i;
        int n = x.length;
        int p = x[0].length;
        if (centerizing) {
            double[] center = MathEx.colMeans(x);
            for (i = 0; i < n; ++i) {
                for (j = 0; j < p; ++j) {
                    x[i][j] = x[i][j] - center[j];
                }
            }
        }
        double[] scale = new double[p];
        for (int j2 = 0; j2 < p; ++j2) {
            for (int i2 = 0; i2 < n; ++i2) {
                int n2 = j2;
                scale[n2] = scale[n2] + MathEx.sqr(x[i2][j2]);
            }
            scale[j2] = Math.sqrt(scale[j2]);
        }
        for (i = 0; i < n; ++i) {
            for (j = 0; j < p; ++j) {
                if (MathEx.isZero(scale[j])) continue;
                double[] dArray = x[i];
                int n3 = j;
                dArray[n3] = dArray[n3] / scale[j];
            }
        }
    }

    public static void unitize(double[] x) {
        MathEx.unitize2(x);
    }

    public static void unitize1(double[] x) {
        double n = MathEx.norm1(x);
        int i = 0;
        while (i < x.length) {
            int n2 = i++;
            x[n2] = x[n2] / n;
        }
    }

    public static void unitize2(double[] x) {
        double n = MathEx.norm(x);
        int i = 0;
        while (i < x.length) {
            int n2 = i++;
            x[n2] = x[n2] / n;
        }
    }

    public static boolean equals(float[] x, float[] y) {
        return MathEx.equals(x, y, 1.0E-7f);
    }

    public static boolean equals(float[] x, float[] y, float epsilon) {
        if (x.length != y.length) {
            throw new IllegalArgumentException(String.format("Arrays have different length: x[%d], y[%d]", x.length, y.length));
        }
        for (int i = 0; i < x.length; ++i) {
            if (!(Math.abs(x[i] - y[i]) > epsilon)) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(double[] x, double[] y) {
        return MathEx.equals(x, y, 1.0E-10);
    }

    public static boolean equals(double[] x, double[] y, double eps) {
        if (x.length != y.length) {
            throw new IllegalArgumentException(String.format("Arrays have different length: x[%d], y[%d]", x.length, y.length));
        }
        if (eps <= 0.0) {
            throw new IllegalArgumentException("Invalid epsilon: " + eps);
        }
        for (int i = 0; i < x.length; ++i) {
            if (!(Math.abs(x[i] - y[i]) > eps)) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(float[][] x, float[][] y) {
        return MathEx.equals(x, y, 1.0E-7f);
    }

    public static boolean equals(float[][] x, float[][] y, float epsilon) {
        if (x.length != y.length || x[0].length != y[0].length) {
            throw new IllegalArgumentException(String.format("Matrices have different rows: %d x %d vs %d x %d", x.length, x[0].length, y.length, y[0].length));
        }
        for (int i = 0; i < x.length; ++i) {
            for (int j = 0; j < x[i].length; ++j) {
                if (!(Math.abs(x[i][j] - y[i][j]) > epsilon)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean equals(double[][] x, double[][] y) {
        return MathEx.equals(x, y, 1.0E-10);
    }

    public static boolean equals(double[][] x, double[][] y, double eps) {
        if (x.length != y.length || x[0].length != y[0].length) {
            throw new IllegalArgumentException(String.format("Matrices have different rows: %d x %d vs %d x %d", x.length, x[0].length, y.length, y[0].length));
        }
        if (eps <= 0.0) {
            throw new IllegalArgumentException("Invalid epsilon: " + eps);
        }
        for (int i = 0; i < x.length; ++i) {
            for (int j = 0; j < x[i].length; ++j) {
                if (!(Math.abs(x[i][j] - y[i][j]) > eps)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isZero(float x) {
        return MathEx.isZero(x, FLOAT_EPSILON);
    }

    public static boolean isZero(float x, float epsilon) {
        return Math.abs(x) < epsilon;
    }

    public static boolean isZero(double x) {
        return MathEx.isZero(x, EPSILON);
    }

    public static boolean isZero(double x, double epsilon) {
        return Math.abs(x) < epsilon;
    }

    public static int[][] clone(int[][] x) {
        int[][] matrix = new int[x.length][];
        for (int i = 0; i < x.length; ++i) {
            matrix[i] = (int[])x[i].clone();
        }
        return matrix;
    }

    public static float[][] clone(float[][] x) {
        float[][] matrix = new float[x.length][];
        for (int i = 0; i < x.length; ++i) {
            matrix[i] = (float[])x[i].clone();
        }
        return matrix;
    }

    public static double[][] clone(double[][] x) {
        double[][] matrix = new double[x.length][];
        for (int i = 0; i < x.length; ++i) {
            matrix[i] = (double[])x[i].clone();
        }
        return matrix;
    }

    public static void swap(int[] x, int i, int j) {
        int s = x[i];
        x[i] = x[j];
        x[j] = s;
    }

    public static void swap(float[] x, int i, int j) {
        float s = x[i];
        x[i] = x[j];
        x[j] = s;
    }

    public static void swap(double[] x, int i, int j) {
        double s = x[i];
        x[i] = x[j];
        x[j] = s;
    }

    public static void swap(Object[] x, int i, int j) {
        Object s = x[i];
        x[i] = x[j];
        x[j] = s;
    }

    public static void swap(int[] x, int[] y) {
        if (x.length != y.length) {
            throw new IllegalArgumentException(String.format("Arrays have different length: x[%d], y[%d]", x.length, y.length));
        }
        for (int i = 0; i < x.length; ++i) {
            int s = x[i];
            x[i] = y[i];
            y[i] = s;
        }
    }

    public static void swap(float[] x, float[] y) {
        if (x.length != y.length) {
            throw new IllegalArgumentException(String.format("Arrays have different length: x[%d], y[%d]", x.length, y.length));
        }
        for (int i = 0; i < x.length; ++i) {
            float s = x[i];
            x[i] = y[i];
            y[i] = s;
        }
    }

    public static void swap(double[] x, double[] y) {
        if (x.length != y.length) {
            throw new IllegalArgumentException(String.format("Arrays have different length: x[%d], y[%d]", x.length, y.length));
        }
        for (int i = 0; i < x.length; ++i) {
            double s = x[i];
            x[i] = y[i];
            y[i] = s;
        }
    }

    public static <E> void swap(E[] x, E[] y) {
        if (x.length != y.length) {
            throw new IllegalArgumentException(String.format("Arrays have different length: x[%d], y[%d]", x.length, y.length));
        }
        for (int i = 0; i < x.length; ++i) {
            E s = x[i];
            x[i] = y[i];
            y[i] = s;
        }
    }

    public static void copy(int[] x, int[] y) {
        if (x.length != y.length) {
            throw new IllegalArgumentException(String.format("Arrays have different length: x[%d], y[%d]", x.length, y.length));
        }
        System.arraycopy(x, 0, y, 0, x.length);
    }

    public static void copy(float[] x, float[] y) {
        if (x.length != y.length) {
            throw new IllegalArgumentException(String.format("Arrays have different length: x[%d], y[%d]", x.length, y.length));
        }
        System.arraycopy(x, 0, y, 0, x.length);
    }

    public static void copy(double[] x, double[] y) {
        if (x.length != y.length) {
            throw new IllegalArgumentException(String.format("Arrays have different length: x[%d], y[%d]", x.length, y.length));
        }
        System.arraycopy(x, 0, y, 0, x.length);
    }

    public static void copy(int[][] x, int[][] y) {
        if (x.length != y.length || x[0].length != y[0].length) {
            throw new IllegalArgumentException(String.format("Matrices have different rows: %d x %d vs %d x %d", x.length, x[0].length, y.length, y[0].length));
        }
        for (int i = 0; i < x.length; ++i) {
            System.arraycopy(x[i], 0, y[i], 0, x[i].length);
        }
    }

    public static void copy(float[][] x, float[][] y) {
        if (x.length != y.length || x[0].length != y[0].length) {
            throw new IllegalArgumentException(String.format("Matrices have different rows: %d x %d vs %d x %d", x.length, x[0].length, y.length, y[0].length));
        }
        for (int i = 0; i < x.length; ++i) {
            System.arraycopy(x[i], 0, y[i], 0, x[i].length);
        }
    }

    public static void copy(double[][] x, double[][] y) {
        if (x.length != y.length || x[0].length != y[0].length) {
            throw new IllegalArgumentException(String.format("Matrices have different rows: %d x %d vs %d x %d", x.length, x[0].length, y.length, y[0].length));
        }
        for (int i = 0; i < x.length; ++i) {
            System.arraycopy(x[i], 0, y[i], 0, x[i].length);
        }
    }

    public static void add(double[] y, double[] x) {
        if (x.length != y.length) {
            throw new IllegalArgumentException(String.format("Arrays have different length: x[%d], y[%d]", x.length, y.length));
        }
        for (int i = 0; i < x.length; ++i) {
            int n = i;
            y[n] = y[n] + x[i];
        }
    }

    public static void sub(double[] y, double[] x) {
        if (x.length != y.length) {
            throw new IllegalArgumentException(String.format("Arrays have different length: x[%d], y[%d]", x.length, y.length));
        }
        for (int i = 0; i < x.length; ++i) {
            int n = i;
            y[n] = y[n] - x[i];
        }
    }

    public static void scale(double a, double[] x) {
        int i = 0;
        while (i < x.length) {
            int n = i++;
            x[n] = x[n] * a;
        }
    }

    public static void scale(double a, double[] x, double[] y) {
        for (int i = 0; i < x.length; ++i) {
            y[i] = a * x[i];
        }
    }

    public static double[] axpy(double a, double[] x, double[] y) {
        if (x.length != y.length) {
            throw new IllegalArgumentException(String.format("Arrays have different length: x[%d], y[%d]", x.length, y.length));
        }
        for (int i = 0; i < x.length; ++i) {
            int n = i;
            y[n] = y[n] + a * x[i];
        }
        return y;
    }

    public static double[] pow(double[] x, double n) {
        double[] y = new double[x.length];
        for (int i = 0; i < x.length; ++i) {
            y[i] = Math.pow(x[i], n);
        }
        return y;
    }

    public static int[] unique(int[] x) {
        return Arrays.stream(x).distinct().toArray();
    }

    public static String[] unique(String[] x) {
        return (String[])Arrays.stream(x).distinct().toArray(String[]::new);
    }

    public static int[][] sort(double[][] x) {
        int n = x.length;
        int p = x[0].length;
        double[] a = new double[n];
        int[][] index = new int[p][];
        for (int j = 0; j < p; ++j) {
            for (int i = 0; i < n; ++i) {
                a[i] = x[i][j];
            }
            index[j] = QuickSort.sort(a);
        }
        return index;
    }

    public static double[] solve(double[] a, double[] b, double[] c, double[] r) {
        int j;
        if (b[0] == 0.0) {
            throw new IllegalArgumentException("Invalid value of b[0] == 0. The equations should be rewritten as a set of order n - 1.");
        }
        int n = a.length;
        double[] u = new double[n];
        double[] gam = new double[n];
        double bet = b[0];
        u[0] = r[0] / bet;
        for (j = 1; j < n; ++j) {
            gam[j] = c[j - 1] / bet;
            bet = b[j] - a[j] * gam[j];
            if (bet == 0.0) {
                throw new IllegalArgumentException("The tridagonal matrix is not of diagonal dominance.");
            }
            u[j] = (r[j] - a[j] * u[j - 1]) / bet;
        }
        for (j = n - 2; j >= 0; --j) {
            int n2 = j;
            u[n2] = u[n2] - gam[j + 1] * u[j + 1];
        }
        return u;
    }

    private static class FPU {
        int RADIX = 2;
        int DIGITS = 53;
        int FLOAT_DIGITS = 24;
        int ROUND_STYLE = 2;
        int MACHEP = -52;
        int FLOAT_MACHEP = -23;
        int NEGEP = -53;
        int FLOAT_NEGEP = -24;
        float FLOAT_EPSILON = (float)Math.pow(2.0, this.FLOAT_MACHEP);
        double EPSILON = Math.pow(2.0, this.MACHEP);

        FPU() {
            double temp;
            double ONE = 1.0;
            double TWO = ONE + ONE;
            double ZERO = ONE - ONE;
            double a = ONE;
            double temp1 = ONE;
            while (temp1 - ONE == ZERO) {
                a += a;
                temp = a + ONE;
                temp1 = temp - a;
            }
            double b = ONE;
            int itemp = 0;
            while (itemp == 0) {
                b += b;
                temp = a + b;
                itemp = (int)(temp - a);
            }
            this.RADIX = itemp;
            double beta = this.RADIX;
            this.DIGITS = 0;
            b = ONE;
            temp1 = ONE;
            while (temp1 - ONE == ZERO) {
                ++this.DIGITS;
                temp = (b *= beta) + ONE;
                temp1 = temp - b;
            }
            this.ROUND_STYLE = 0;
            double betah = beta / TWO;
            temp = a + betah;
            if (temp - a != ZERO) {
                this.ROUND_STYLE = 1;
            }
            double tempa = a + beta;
            temp = tempa + betah;
            if (this.ROUND_STYLE == 0 && temp - tempa != ZERO) {
                this.ROUND_STYLE = 2;
            }
            this.NEGEP = this.DIGITS + 3;
            double betain = ONE / beta;
            a = ONE;
            for (int i = 0; i < this.NEGEP; ++i) {
                a *= betain;
            }
            b = a;
            temp = ONE - a;
            while (temp - ONE == ZERO) {
                --this.NEGEP;
                temp = ONE - (a *= beta);
            }
            this.NEGEP = -this.NEGEP;
            this.MACHEP = -this.DIGITS - 3;
            a = b;
            temp = ONE + a;
            while (temp - ONE == ZERO) {
                ++this.MACHEP;
                temp = ONE + (a *= beta);
            }
            this.EPSILON = a;
        }
    }
}

