/*
 * Decompiled with CFR 0.152.
 */
package smile.stat.distribution;

import java.util.Arrays;
import smile.math.MathEx;
import smile.stat.distribution.Distribution;
import smile.stat.distribution.GaussianDistribution;

public class KernelDensity
implements Distribution {
    private static final long serialVersionUID = 2L;
    private double[] x;
    private GaussianDistribution gaussian;
    private double h;
    private double mean;
    private double sd;
    private double variance;

    public KernelDensity(double[] x) {
        this.x = x;
        this.mean = MathEx.mean(x);
        this.variance = MathEx.var(x);
        this.sd = Math.sqrt(this.variance);
        Arrays.sort(x);
        int n = x.length;
        double iqr = x[n * 3 / 4] - x[n / 4];
        this.h = 1.06 * Math.min(this.sd, iqr / 1.34) / Math.pow(x.length, 0.2);
        this.gaussian = new GaussianDistribution(0.0, this.h);
    }

    public KernelDensity(double[] x, double h) {
        if (h <= 0.0) {
            throw new IllegalArgumentException("Invalid bandwidth: " + h);
        }
        this.x = x;
        this.h = h;
        this.mean = MathEx.mean(x);
        this.variance = MathEx.var(x);
        this.sd = Math.sqrt(this.variance);
        this.gaussian = new GaussianDistribution(0.0, h);
        Arrays.sort(x);
    }

    public double bandwidth() {
        return this.h;
    }

    @Override
    public int length() {
        return 0;
    }

    @Override
    public double mean() {
        return this.mean;
    }

    @Override
    public double variance() {
        return this.variance;
    }

    @Override
    public double sd() {
        return this.sd;
    }

    @Override
    public double entropy() {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public double rand() {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public double p(double x) {
        int end;
        int start = Arrays.binarySearch(this.x, x - 5.0 * this.h);
        if (start < 0) {
            start = -start - 1;
        }
        if ((end = Arrays.binarySearch(this.x, x + 5.0 * this.h)) < 0) {
            end = -end - 1;
        }
        double p = 0.0;
        for (int i = start; i < end; ++i) {
            p += this.gaussian.p(this.x[i] - x);
        }
        return p / (double)this.x.length;
    }

    @Override
    public double logp(double x) {
        return Math.log(this.p(x));
    }

    @Override
    public double cdf(double x) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public double quantile(double p) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public double likelihood(double[] x) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public double logLikelihood(double[] x) {
        throw new UnsupportedOperationException("Not supported.");
    }
}

