/*
 * Decompiled with CFR 0.152.
 */
package smile.stat.distribution;

import smile.math.MathEx;
import smile.stat.distribution.AbstractDistribution;
import smile.stat.distribution.ExponentialFamily;
import smile.stat.distribution.Mixture;

public class ExponentialDistribution
extends AbstractDistribution
implements ExponentialFamily {
    private static final long serialVersionUID = 2L;
    public final double lambda;

    public ExponentialDistribution(double lambda) {
        if (lambda <= 0.0) {
            throw new IllegalArgumentException("Invalid lambda: " + lambda);
        }
        this.lambda = lambda;
    }

    public static ExponentialDistribution fit(double[] data) {
        for (int i = 0; i < data.length; ++i) {
            if (!(data[i] < 0.0)) continue;
            throw new IllegalArgumentException("Samples contain negative values.");
        }
        double mean = MathEx.mean(data);
        if (mean == 0.0) {
            throw new IllegalArgumentException("Samples are all zeros.");
        }
        double lambda = 1.0 / mean;
        return new ExponentialDistribution(lambda);
    }

    @Override
    public int length() {
        return 1;
    }

    @Override
    public double mean() {
        return 1.0 / this.lambda;
    }

    @Override
    public double variance() {
        return 1.0 / (this.lambda * this.lambda);
    }

    @Override
    public double sd() {
        return 1.0 / this.lambda;
    }

    @Override
    public double entropy() {
        return 1.0 - Math.log(this.lambda);
    }

    public String toString() {
        return String.format("Exponential Distribution(%.4f)", this.lambda);
    }

    @Override
    public double rand() {
        return -1.0 / this.lambda * Math.log(MathEx.random());
    }

    @Override
    public double p(double x) {
        if (x < 0.0) {
            return 0.0;
        }
        return this.lambda * Math.exp(-this.lambda * x);
    }

    @Override
    public double logp(double x) {
        if (x < 0.0) {
            return Double.NEGATIVE_INFINITY;
        }
        return Math.log(this.lambda) - this.lambda * x;
    }

    @Override
    public double cdf(double x) {
        if (x < 0.0) {
            return 0.0;
        }
        return 1.0 - Math.exp(-this.lambda * x);
    }

    @Override
    public double quantile(double p) {
        if (p < 0.0 || p > 1.0) {
            throw new IllegalArgumentException("Invalid p: " + p);
        }
        return -Math.log(1.0 - p) / this.lambda;
    }

    @Override
    public Mixture.Component M(double[] x, double[] posteriori) {
        double alpha = 0.0;
        double mean = 0.0;
        for (int i = 0; i < x.length; ++i) {
            alpha += posteriori[i];
            mean += x[i] * posteriori[i];
        }
        return new Mixture.Component(alpha, new ExponentialDistribution(1.0 / (mean /= alpha)));
    }
}

