/*
 * Decompiled with CFR 0.152.
 */
package smile.math.matrix;

import smile.math.Math;
import smile.math.matrix.CholeskyDecomposition;
import smile.math.matrix.ColumnMajorMatrix;
import smile.math.matrix.DenseMatrix;

public class SingularValueDecomposition {
    private DenseMatrix U;
    private DenseMatrix V;
    private double[] s;
    private boolean full;
    private int m;
    private int n;
    private double tol;

    SingularValueDecomposition(DenseMatrix U, DenseMatrix V, double[] s) {
        this(U, V, s, true);
    }

    SingularValueDecomposition(DenseMatrix U, DenseMatrix V, double[] s, boolean full) {
        this.U = U;
        this.V = V;
        this.s = s;
        this.full = full;
        this.m = U.nrows();
        this.n = V.ncols();
        this.tol = 0.5 * Math.sqrt((double)(this.m + this.n) + 1.0) * s[0] * Math.EPSILON;
    }

    public DenseMatrix getU() {
        return this.U;
    }

    public DenseMatrix getV() {
        return this.V;
    }

    public double[] getSingularValues() {
        return this.s;
    }

    public DenseMatrix getS() {
        ColumnMajorMatrix S = new ColumnMajorMatrix(this.U.nrows(), this.V.nrows());
        for (int i = 0; i < this.s.length; ++i) {
            S.set(i, i, this.s[i]);
        }
        return S;
    }

    public double norm() {
        return this.s[0];
    }

    public int rank() {
        if (!this.full) {
            throw new IllegalStateException("This is not a FULL singular value decomposition.");
        }
        int r = 0;
        for (int i = 0; i < this.s.length; ++i) {
            if (!(this.s[i] > this.tol)) continue;
            ++r;
        }
        return r;
    }

    public int nullity() {
        if (!this.full) {
            throw new IllegalStateException("This is not a FULL singular value decomposition.");
        }
        int r = 0;
        for (int i = 0; i < this.s.length; ++i) {
            if (!(this.s[i] <= this.tol)) continue;
            ++r;
        }
        return r;
    }

    public double condition() {
        if (!this.full) {
            throw new IllegalStateException("This is not a FULL singular value decomposition.");
        }
        return this.s[0] <= 0.0 || this.s[this.n - 1] <= 0.0 ? Double.POSITIVE_INFINITY : this.s[0] / this.s[this.n - 1];
    }

    public DenseMatrix range() {
        if (!this.full) {
            throw new IllegalStateException("This is not a FULL singular value decomposition.");
        }
        int nr = 0;
        ColumnMajorMatrix rnge = new ColumnMajorMatrix(this.m, this.rank());
        for (int j = 0; j < this.n; ++j) {
            if (!(this.s[j] > this.tol)) continue;
            for (int i = 0; i < this.m; ++i) {
                rnge.set(i, nr, this.U.get(i, j));
            }
            ++nr;
        }
        return rnge;
    }

    public DenseMatrix nullspace() {
        if (!this.full) {
            throw new IllegalStateException("This is not a FULL singular value decomposition.");
        }
        int nn = 0;
        ColumnMajorMatrix nullsp = new ColumnMajorMatrix(this.n, this.nullity());
        for (int j = 0; j < this.n; ++j) {
            if (!(this.s[j] <= this.tol)) continue;
            for (int jj = 0; jj < this.n; ++jj) {
                nullsp.set(jj, nn, this.V.get(jj, j));
            }
            ++nn;
        }
        return nullsp;
    }

    public CholeskyDecomposition toCholesky() {
        ColumnMajorMatrix VD = new ColumnMajorMatrix(this.V.nrows(), this.V.ncols());
        for (int i = 0; i < this.V.nrows(); ++i) {
            for (int j = 0; j < this.V.ncols(); ++j) {
                VD.set(i, j, this.V.get(i, j) * this.s[j]);
            }
        }
        return new CholeskyDecomposition(VD.aat());
    }

    public void solve(double[] b, double[] x) {
        double r;
        int j;
        if (!this.full) {
            throw new IllegalStateException("This is not a FULL singular value decomposition.");
        }
        if (b.length != this.m || x.length != this.n) {
            throw new IllegalArgumentException("Dimensions do not agree.");
        }
        double[] tmp = new double[this.n];
        for (j = 0; j < this.n; ++j) {
            r = 0.0;
            if (this.s[j] > this.tol) {
                for (int i = 0; i < this.m; ++i) {
                    r += this.U.get(i, j) * b[i];
                }
                r /= this.s[j];
            }
            tmp[j] = r;
        }
        for (j = 0; j < this.n; ++j) {
            r = 0.0;
            for (int jj = 0; jj < this.n; ++jj) {
                r += this.V.get(j, jj) * tmp[jj];
            }
            x[j] = r;
        }
    }

    public void solve(double[][] B, double[][] X) {
        if (!this.full) {
            throw new IllegalStateException("This is not a FULL singular value decomposition.");
        }
        if (B.length != this.n || X.length != this.n || B[0].length != X[0].length) {
            throw new IllegalArgumentException("Dimensions do not agree.");
        }
        double[] xx = new double[this.n];
        int p = B[0].length;
        for (int j = 0; j < p; ++j) {
            int i;
            for (i = 0; i < this.n; ++i) {
                xx[i] = B[i][j];
            }
            this.solve(xx, xx);
            for (i = 0; i < this.n; ++i) {
                X[i][j] = xx[i];
            }
        }
    }

    public SingularValueDecomposition(double[][] A) {
        this(new ColumnMajorMatrix(A));
    }

    public SingularValueDecomposition(DenseMatrix A) {
        int j;
        double h;
        double f;
        int k;
        double s;
        int i;
        int m = A.nrows();
        int n = A.ncols();
        int l = 0;
        int nm = 0;
        double anorm = 0.0;
        double scale = 0.0;
        double g = 0.0;
        this.U = A;
        this.V = new ColumnMajorMatrix(n, n);
        double[] w = new double[n];
        double[] rv1 = new double[n];
        for (i = 0; i < n; ++i) {
            l = i + 2;
            rv1[i] = scale * g;
            scale = 0.0;
            s = 0.0;
            g = 0.0;
            if (i < m) {
                for (k = i; k < m; ++k) {
                    scale += Math.abs(this.U.get(k, i));
                }
                if (scale != 0.0) {
                    for (k = i; k < m; ++k) {
                        this.U.div(k, i, scale);
                        s += this.U.get(k, i) * this.U.get(k, i);
                    }
                    f = this.U.get(i, i);
                    g = -Math.copySign(Math.sqrt(s), f);
                    h = f * g - s;
                    this.U.set(i, i, f - g);
                    for (j = l - 1; j < n; ++j) {
                        s = 0.0;
                        for (k = i; k < m; ++k) {
                            s += this.U.get(k, i) * this.U.get(k, j);
                        }
                        f = s / h;
                        for (k = i; k < m; ++k) {
                            this.U.add(k, j, f * this.U.get(k, i));
                        }
                    }
                    for (k = i; k < m; ++k) {
                        this.U.mul(k, i, scale);
                    }
                }
            }
            w[i] = scale * g;
            scale = 0.0;
            s = 0.0;
            g = 0.0;
            if (i + 1 <= m && i + 1 != n) {
                for (k = l - 1; k < n; ++k) {
                    scale += Math.abs(this.U.get(i, k));
                }
                if (scale != 0.0) {
                    for (k = l - 1; k < n; ++k) {
                        this.U.div(i, k, scale);
                        s += this.U.get(i, k) * this.U.get(i, k);
                    }
                    f = this.U.get(i, l - 1);
                    g = -Math.copySign(Math.sqrt(s), f);
                    h = f * g - s;
                    this.U.set(i, l - 1, f - g);
                    for (k = l - 1; k < n; ++k) {
                        rv1[k] = this.U.get(i, k) / h;
                    }
                    for (j = l - 1; j < m; ++j) {
                        s = 0.0;
                        for (k = l - 1; k < n; ++k) {
                            s += this.U.get(j, k) * this.U.get(i, k);
                        }
                        for (k = l - 1; k < n; ++k) {
                            this.U.add(j, k, s * rv1[k]);
                        }
                    }
                    for (k = l - 1; k < n; ++k) {
                        this.U.mul(i, k, scale);
                    }
                }
            }
            anorm = Math.max(anorm, Math.abs(w[i]) + Math.abs(rv1[i]));
        }
        i = n - 1;
        while (i >= 0) {
            if (i < n - 1) {
                if (g != 0.0) {
                    for (j = l; j < n; ++j) {
                        this.V.set(j, i, this.U.get(i, j) / this.U.get(i, l) / g);
                    }
                    for (j = l; j < n; ++j) {
                        s = 0.0;
                        for (k = l; k < n; ++k) {
                            s += this.U.get(i, k) * this.V.get(k, j);
                        }
                        for (k = l; k < n; ++k) {
                            this.V.add(k, j, s * this.V.get(k, i));
                        }
                    }
                }
                for (j = l; j < n; ++j) {
                    this.V.set(i, j, 0.0);
                    this.V.set(j, i, 0.0);
                }
            }
            this.V.set(i, i, 1.0);
            g = rv1[i];
            l = i--;
        }
        for (i = Math.min(m, n) - 1; i >= 0; --i) {
            l = i + 1;
            g = w[i];
            for (j = l; j < n; ++j) {
                this.U.set(i, j, 0.0);
            }
            if (g != 0.0) {
                g = 1.0 / g;
                for (j = l; j < n; ++j) {
                    s = 0.0;
                    for (k = l; k < m; ++k) {
                        s += this.U.get(k, i) * this.U.get(k, j);
                    }
                    f = s / this.U.get(i, i) * g;
                    for (k = i; k < m; ++k) {
                        this.U.add(k, j, f * this.U.get(k, i));
                    }
                }
                for (j = i; j < m; ++j) {
                    this.U.mul(j, i, g);
                }
            } else {
                for (j = i; j < m; ++j) {
                    this.U.set(j, i, 0.0);
                }
            }
            this.U.add(i, i, 1.0);
        }
        block27: for (k = n - 1; k >= 0; --k) {
            for (int its = 0; its < 30; ++its) {
                double z;
                double y;
                double c;
                boolean flag = true;
                for (l = k; l >= 0; --l) {
                    nm = l - 1;
                    if (l == 0 || Math.abs(rv1[l]) <= Math.EPSILON * anorm) {
                        flag = false;
                        break;
                    }
                    if (Math.abs(w[nm]) <= Math.EPSILON * anorm) break;
                }
                if (flag) {
                    c = 0.0;
                    s = 1.0;
                    for (i = l; i < k + 1; ++i) {
                        f = s * rv1[i];
                        rv1[i] = c * rv1[i];
                        if (Math.abs(f) <= Math.EPSILON * anorm) break;
                        g = w[i];
                        w[i] = h = Math.hypot(f, g);
                        h = 1.0 / h;
                        c = g * h;
                        s = -f * h;
                        for (j = 0; j < m; ++j) {
                            y = this.U.get(j, nm);
                            z = this.U.get(j, i);
                            this.U.set(j, nm, y * c + z * s);
                            this.U.set(j, i, z * c - y * s);
                        }
                    }
                }
                z = w[k];
                if (l == k) {
                    if (!(z < 0.0)) continue block27;
                    w[k] = -z;
                    for (j = 0; j < n; ++j) {
                        this.V.set(j, k, -this.V.get(j, k));
                    }
                    continue block27;
                }
                if (its == 29) {
                    throw new IllegalStateException("no convergence in 30 iterations");
                }
                double x = w[l];
                nm = k - 1;
                y = w[nm];
                g = rv1[nm];
                h = rv1[k];
                f = ((y - z) * (y + z) + (g - h) * (g + h)) / (2.0 * h * y);
                g = Math.hypot(f, 1.0);
                f = ((x - z) * (x + z) + h * (y / (f + Math.copySign(g, f)) - h)) / x;
                s = 1.0;
                c = 1.0;
                for (j = l; j <= nm; ++j) {
                    int jj;
                    i = j + 1;
                    g = rv1[i];
                    y = w[i];
                    h = s * g;
                    g = c * g;
                    rv1[j] = z = Math.hypot(f, h);
                    c = f / z;
                    s = h / z;
                    f = x * c + g * s;
                    g = g * c - x * s;
                    h = y * s;
                    y *= c;
                    for (jj = 0; jj < n; ++jj) {
                        x = this.V.get(jj, j);
                        z = this.V.get(jj, i);
                        this.V.set(jj, j, x * c + z * s);
                        this.V.set(jj, i, z * c - x * s);
                    }
                    w[j] = z = Math.hypot(f, h);
                    if (z != 0.0) {
                        z = 1.0 / z;
                        c = f * z;
                        s = h * z;
                    }
                    f = c * g + s * y;
                    x = c * y - s * g;
                    for (jj = 0; jj < m; ++jj) {
                        y = this.U.get(jj, j);
                        z = this.U.get(jj, i);
                        this.U.set(jj, j, y * c + z * s);
                        this.U.set(jj, i, z * c - y * s);
                    }
                }
                rv1[l] = 0.0;
                rv1[k] = f;
                w[k] = x;
            }
        }
        int inc = 1;
        double[] su = new double[m];
        double[] sv = new double[n];
        do {
            inc *= 3;
        } while (++inc <= n);
        do {
            for (i = inc /= 3; i < n; ++i) {
                double sw = w[i];
                for (k = 0; k < m; ++k) {
                    su[k] = this.U.get(k, i);
                }
                for (k = 0; k < n; ++k) {
                    sv[k] = this.V.get(k, i);
                }
                j = i;
                while (w[j - inc] < sw) {
                    w[j] = w[j - inc];
                    for (k = 0; k < m; ++k) {
                        this.U.set(k, j, this.U.get(k, j - inc));
                    }
                    for (k = 0; k < n; ++k) {
                        this.V.set(k, j, this.V.get(k, j - inc));
                    }
                    if ((j -= inc) >= inc) continue;
                }
                w[j] = sw;
                for (k = 0; k < m; ++k) {
                    this.U.set(k, j, su[k]);
                }
                for (k = 0; k < n; ++k) {
                    this.V.set(k, j, sv[k]);
                }
            }
        } while (inc > 1);
        for (k = 0; k < n; ++k) {
            s = 0.0;
            for (i = 0; i < m; ++i) {
                if (!(this.U.get(i, k) < 0.0)) continue;
                s += 1.0;
            }
            for (j = 0; j < n; ++j) {
                if (!(this.V.get(j, k) < 0.0)) continue;
                s += 1.0;
            }
            if (!(s > (double)((m + n) / 2))) continue;
            for (i = 0; i < m; ++i) {
                this.U.set(i, k, -this.U.get(i, k));
            }
            for (j = 0; j < n; ++j) {
                this.V.set(j, k, -this.V.get(j, k));
            }
        }
        this.s = w;
        this.full = true;
        this.m = A.nrows();
        this.n = A.ncols();
        this.tol = 0.5 * Math.sqrt((double)(m + n) + 1.0) * this.s[0] * Math.EPSILON;
    }
}

