/*
 * Decompiled with CFR 0.152.
 */
package smile.math.matrix;

import java.util.Arrays;
import smile.math.Math;
import smile.math.matrix.ColumnMajorMatrix;
import smile.math.matrix.DenseMatrix;
import smile.stat.distribution.GaussianDistribution;

public class RowMajorMatrix
implements DenseMatrix {
    private double[] A;
    private int nrows;
    private int ncols;

    public RowMajorMatrix(double[][] A) {
        this.nrows = A.length;
        this.ncols = A[0].length;
        this.A = new double[this.nrows * this.ncols];
        int pos = 0;
        for (int i = 0; i < this.nrows; ++i) {
            System.arraycopy(A[i], 0, this.A, pos, this.ncols);
            pos += this.ncols;
        }
    }

    public RowMajorMatrix(int rows, int cols) {
        this.nrows = rows;
        this.ncols = cols;
        this.A = new double[rows * cols];
    }

    public RowMajorMatrix(int rows, int cols, double value) {
        this(rows, cols);
        if (value != 0.0) {
            Arrays.fill(this.A, value);
        }
    }

    public RowMajorMatrix(int rows, int cols, double[] value) {
        this.nrows = rows;
        this.ncols = cols;
        this.A = value;
    }

    public RowMajorMatrix(double[] diag) {
        this(diag.length, diag.length);
        for (int i = 0; i < diag.length; ++i) {
            this.set(i, i, diag[i]);
        }
    }

    public RowMajorMatrix(int rows, int cols, double mu, double sigma) {
        this(rows, cols);
        GaussianDistribution g = new GaussianDistribution(mu, sigma);
        int n = rows * cols;
        for (int i = 0; i < n; ++i) {
            this.A[i] = g.rand();
        }
    }

    public static RowMajorMatrix eye(int n) {
        return RowMajorMatrix.eye(n, n);
    }

    public static RowMajorMatrix eye(int m, int n) {
        RowMajorMatrix matrix = new RowMajorMatrix(m, n);
        int l = Math.min(m, n);
        for (int i = 0; i < l; ++i) {
            matrix.set(i, i, 1.0);
        }
        return matrix;
    }

    public String toString() {
        return this.toString(false);
    }

    @Override
    public RowMajorMatrix copy() {
        return new RowMajorMatrix(this.nrows, this.ncols, (double[])this.A.clone());
    }

    @Override
    public ColumnMajorMatrix transpose() {
        return new ColumnMajorMatrix(this.ncols, this.nrows, this.A);
    }

    @Override
    public int nrows() {
        return this.nrows;
    }

    @Override
    public int ncols() {
        return this.ncols;
    }

    @Override
    public double get(int i, int j) {
        return this.A[i * this.ncols + j];
    }

    @Override
    public double set(int i, int j, double x) {
        double d = x;
        this.A[i * this.ncols + j] = d;
        return d;
    }

    @Override
    public double add(int i, int j, double x) {
        int n = i * this.ncols + j;
        double d = this.A[n] + x;
        this.A[n] = d;
        return d;
    }

    @Override
    public double sub(int i, int j, double x) {
        int n = i * this.ncols + j;
        double d = this.A[n] - x;
        this.A[n] = d;
        return d;
    }

    @Override
    public double mul(int i, int j, double x) {
        int n = i * this.ncols + j;
        double d = this.A[n] * x;
        this.A[n] = d;
        return d;
    }

    @Override
    public double div(int i, int j, double x) {
        int n = i * this.ncols + j;
        double d = this.A[n] / x;
        this.A[n] = d;
        return d;
    }

    public RowMajorMatrix add(RowMajorMatrix b) {
        if (this.nrows() != b.nrows() || this.ncols() != b.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        for (int i = 0; i < this.A.length; ++i) {
            int n = i;
            this.A[n] = this.A[n] + b.A[i];
        }
        return this;
    }

    public RowMajorMatrix sub(RowMajorMatrix b) {
        if (this.nrows() != b.nrows() || this.ncols() != b.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        for (int i = 0; i < this.A.length; ++i) {
            int n = i;
            this.A[n] = this.A[n] - b.A[i];
        }
        return this;
    }

    public RowMajorMatrix mul(RowMajorMatrix b) {
        if (this.nrows() != b.nrows() || this.ncols() != b.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        for (int i = 0; i < this.A.length; ++i) {
            int n = i;
            this.A[n] = this.A[n] * b.A[i];
        }
        return this;
    }

    public RowMajorMatrix div(RowMajorMatrix b) {
        if (this.nrows() != b.nrows() || this.ncols() != b.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        for (int i = 0; i < this.A.length; ++i) {
            int n = i;
            this.A[n] = this.A[n] / b.A[i];
        }
        return this;
    }

    @Override
    public RowMajorMatrix add(double x) {
        int i = 0;
        while (i < this.A.length) {
            int n = i++;
            this.A[n] = this.A[n] + x;
        }
        return this;
    }

    @Override
    public RowMajorMatrix sub(double x) {
        int i = 0;
        while (i < this.A.length) {
            int n = i++;
            this.A[n] = this.A[n] - x;
        }
        return this;
    }

    @Override
    public RowMajorMatrix mul(double x) {
        int i = 0;
        while (i < this.A.length) {
            int n = i++;
            this.A[n] = this.A[n] * x;
        }
        return this;
    }

    @Override
    public RowMajorMatrix div(double x) {
        int i = 0;
        while (i < this.A.length) {
            int n = i++;
            this.A[n] = this.A[n] / x;
        }
        return this;
    }

    @Override
    public RowMajorMatrix replaceNaN(double x) {
        for (int i = 0; i < this.A.length; ++i) {
            if (!Double.isNaN(this.A[i])) continue;
            this.A[i] = x;
        }
        return this;
    }

    @Override
    public double sum() {
        double s = 0.0;
        for (int i = 0; i < this.A.length; ++i) {
            s += this.A[i];
        }
        return s;
    }

    @Override
    public RowMajorMatrix ata() {
        RowMajorMatrix C = new RowMajorMatrix(this.ncols, this.ncols);
        for (int k = 0; k < this.nrows; ++k) {
            for (int i = 0; i < this.ncols; ++i) {
                for (int j = 0; j < this.ncols; ++j) {
                    C.add(i, j, this.get(k, i) * this.get(k, j));
                }
            }
        }
        return C;
    }

    @Override
    public RowMajorMatrix aat() {
        RowMajorMatrix C = new RowMajorMatrix(this.nrows, this.nrows);
        for (int i = 0; i < this.nrows; ++i) {
            for (int j = 0; j < this.nrows; ++j) {
                double v = 0.0;
                for (int k = 0; k < this.ncols; ++k) {
                    v += this.get(i, k) * this.get(j, k);
                }
                C.set(i, j, v);
            }
        }
        return C;
    }

    @Override
    public double[] ax(double[] x, double[] y) {
        Arrays.fill(y, 0.0);
        int j = 0;
        for (int i = 0; i < this.nrows; ++i) {
            int k = 0;
            while (k < this.ncols) {
                int n = i;
                y[n] = y[n] + this.A[j] * x[k];
                ++k;
                ++j;
            }
        }
        return y;
    }

    @Override
    public double[] axpy(double[] x, double[] y) {
        int j = 0;
        for (int i = 0; i < this.nrows; ++i) {
            int k = 0;
            while (k < this.ncols) {
                int n = i;
                y[n] = y[n] + this.A[j] * x[k];
                ++k;
                ++j;
            }
        }
        return y;
    }

    @Override
    public double[] axpy(double[] x, double[] y, double b) {
        int j = 0;
        for (int i = 0; i < this.nrows; ++i) {
            int n = i;
            y[n] = y[n] * b;
            int k = 0;
            while (k < this.ncols) {
                int n2 = i;
                y[n2] = y[n2] + this.A[j] * x[k];
                ++k;
                ++j;
            }
        }
        return y;
    }

    @Override
    public double[] atx(double[] x, double[] y) {
        Arrays.fill(y, 0.0);
        int j = 0;
        for (int k = 0; k < this.nrows; ++k) {
            int i = 0;
            while (i < this.ncols) {
                int n = i++;
                y[n] = y[n] + this.A[j] * x[k];
                ++j;
            }
        }
        return y;
    }

    @Override
    public double[] atxpy(double[] x, double[] y) {
        int j = 0;
        for (int k = 0; k < this.nrows; ++k) {
            int i = 0;
            while (i < this.ncols) {
                int n = i++;
                y[n] = y[n] + this.A[j] * x[k];
                ++j;
            }
        }
        return y;
    }

    @Override
    public double[] atxpy(double[] x, double[] y, double b) {
        int i = 0;
        while (i < y.length) {
            int n = i++;
            y[n] = y[n] * b;
        }
        int j = 0;
        for (int k = 0; k < this.nrows; ++k) {
            int i2 = 0;
            while (i2 < this.ncols) {
                int n = i2++;
                y[n] = y[n] + this.A[j] * x[k];
                ++j;
            }
        }
        return y;
    }

    @Override
    public RowMajorMatrix abmm(DenseMatrix B) {
        if (this.ncols() != B.nrows()) {
            throw new IllegalArgumentException(String.format("Matrix multiplication A * B: %d x %d vs %d x %d", this.nrows(), this.ncols(), B.nrows(), B.ncols()));
        }
        RowMajorMatrix C = new RowMajorMatrix(this.nrows, B.ncols());
        for (int i = 0; i < this.nrows; ++i) {
            for (int j = 0; j < B.ncols(); ++j) {
                double v = 0.0;
                for (int k = 0; k < this.ncols; ++k) {
                    v += this.get(i, k) * B.get(k, j);
                }
                C.set(i, j, v);
            }
        }
        return C;
    }

    @Override
    public RowMajorMatrix abtmm(DenseMatrix B) {
        if (this.ncols() != B.ncols()) {
            throw new IllegalArgumentException(String.format("Matrix multiplication A * B': %d x %d vs %d x %d", this.nrows(), this.ncols(), B.nrows(), B.ncols()));
        }
        RowMajorMatrix C = new RowMajorMatrix(this.nrows, B.nrows());
        for (int i = 0; i < this.nrows; ++i) {
            for (int j = 0; j < B.nrows(); ++j) {
                double v = 0.0;
                for (int k = 0; k < this.ncols; ++k) {
                    v += this.get(i, k) * B.get(j, k);
                }
                C.set(i, j, v);
            }
        }
        return C;
    }

    @Override
    public RowMajorMatrix atbmm(DenseMatrix B) {
        if (this.nrows() != B.nrows()) {
            throw new IllegalArgumentException(String.format("Matrix multiplication A' * B: %d x %d vs %d x %d", this.nrows(), this.ncols(), B.nrows(), B.ncols()));
        }
        RowMajorMatrix C = new RowMajorMatrix(this.ncols, B.ncols());
        for (int k = 0; k < this.nrows; ++k) {
            for (int i = 0; i < this.ncols; ++i) {
                for (int j = 0; j < B.ncols(); ++j) {
                    C.add(i, j, this.get(k, i) * B.get(k, j));
                }
            }
        }
        return C;
    }
}

