/*
 * Decompiled with CFR 0.152.
 */
package smile.math.matrix;

import java.util.Arrays;
import smile.math.Math;
import smile.math.matrix.ColumnMajorMatrix;
import smile.math.matrix.DenseMatrix;
import smile.stat.distribution.GaussianDistribution;

public class NaiveMatrix
implements DenseMatrix {
    private double[][] A;

    public NaiveMatrix(double[][] A) {
        this.A = A;
    }

    public NaiveMatrix(int rows, int cols) {
        this.A = new double[rows][cols];
    }

    public NaiveMatrix(int rows, int cols, double value) {
        this.A = new double[rows][cols];
        for (int i = 0; i < rows; ++i) {
            Arrays.fill(this.A[i], value);
        }
    }

    public NaiveMatrix(double[] diag) {
        this(diag.length, diag.length);
        for (int i = 0; i < diag.length; ++i) {
            this.A[i][i] = diag[i];
        }
    }

    public NaiveMatrix(int rows, int cols, double mu, double sigma) {
        GaussianDistribution g = new GaussianDistribution(mu, sigma);
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                this.A[i][j] = g.rand();
            }
        }
    }

    public static NaiveMatrix eye(int n) {
        return NaiveMatrix.eye(n, n);
    }

    public static NaiveMatrix eye(int m, int n) {
        double[][] x = new double[m][n];
        int l = Math.min(m, n);
        for (int i = 0; i < l; ++i) {
            x[i][i] = 1.0;
        }
        return new NaiveMatrix(x);
    }

    public String toString() {
        return this.toString(false);
    }

    @Override
    public ColumnMajorMatrix copy() {
        return new ColumnMajorMatrix(this.A);
    }

    @Override
    public double[][] array() {
        double[][] B = new double[this.nrows()][this.ncols()];
        for (int i = 0; i < this.nrows(); ++i) {
            System.arraycopy(this.A[i], 0, B[i], 0, this.ncols());
        }
        return B;
    }

    @Override
    public int nrows() {
        return this.A.length;
    }

    @Override
    public int ncols() {
        return this.A[0].length;
    }

    @Override
    public double get(int i, int j) {
        return this.A[i][j];
    }

    @Override
    public double set(int i, int j, double x) {
        double d = x;
        this.A[i][j] = d;
        return d;
    }

    @Override
    public double add(int i, int j, double x) {
        double[] dArray = this.A[i];
        int n = j;
        double d = dArray[n] + x;
        dArray[n] = d;
        return d;
    }

    @Override
    public double sub(int i, int j, double x) {
        double[] dArray = this.A[i];
        int n = j;
        double d = dArray[n] - x;
        dArray[n] = d;
        return d;
    }

    @Override
    public double mul(int i, int j, double x) {
        double[] dArray = this.A[i];
        int n = j;
        double d = dArray[n] * x;
        dArray[n] = d;
        return d;
    }

    @Override
    public double div(int i, int j, double x) {
        double[] dArray = this.A[i];
        int n = j;
        double d = dArray[n] / x;
        dArray[n] = d;
        return d;
    }

    @Override
    public NaiveMatrix ata() {
        return new NaiveMatrix(Math.atamm(this.A));
    }

    @Override
    public NaiveMatrix aat() {
        return new NaiveMatrix(Math.aatmm(this.A));
    }

    @Override
    public double[] ax(double[] x, double[] y) {
        return Math.ax(this.A, x, y);
    }

    @Override
    public double[] axpy(double[] x, double[] y) {
        return Math.axpy(this.A, x, y);
    }

    @Override
    public double[] axpy(double[] x, double[] y, double b) {
        return Math.axpy(this.A, x, y, b);
    }

    @Override
    public double[] atx(double[] x, double[] y) {
        return Math.atx(this.A, x, y);
    }

    @Override
    public double[] atxpy(double[] x, double[] y) {
        return Math.atxpy(this.A, x, y);
    }

    @Override
    public double[] atxpy(double[] x, double[] y, double b) {
        return Math.atxpy(this.A, x, y, b);
    }

    @Override
    public NaiveMatrix abmm(DenseMatrix b) {
        if (this.A[0].length != b.nrows()) {
            throw new IllegalArgumentException(String.format("Matrix multiplication A * B: %d x %d vs %d x %d", this.A.length, this.A[0].length, b.nrows(), b.ncols()));
        }
        int m = this.A.length;
        int n = b.ncols();
        int l = b.nrows();
        double[][] C = new double[m][n];
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                C[i][j] = 0.0;
                for (int k = 0; k < l; ++k) {
                    double[] dArray = C[i];
                    int n2 = j;
                    dArray[n2] = dArray[n2] + this.A[i][k] * b.get(k, j);
                }
            }
        }
        return new NaiveMatrix(C);
    }

    @Override
    public NaiveMatrix abtmm(DenseMatrix b) {
        if (this.A[0].length != b.nrows()) {
            throw new IllegalArgumentException(String.format("Matrix multiplication A * B: %d x %d vs %d x %d", this.A.length, this.A[0].length, b.nrows(), b.ncols()));
        }
        int m = this.A.length;
        int n = b.nrows();
        int l = b.ncols();
        double[][] C = new double[m][n];
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                C[i][j] = 0.0;
                for (int k = 0; k < l; ++k) {
                    double[] dArray = C[i];
                    int n2 = j;
                    dArray[n2] = dArray[n2] + this.A[i][k] * b.get(j, k);
                }
            }
        }
        return new NaiveMatrix(C);
    }

    @Override
    public NaiveMatrix atbmm(DenseMatrix b) {
        if (this.A[0].length != b.nrows()) {
            throw new IllegalArgumentException(String.format("Matrix multiplication A * B: %d x %d vs %d x %d", this.A.length, this.A[0].length, b.nrows(), b.ncols()));
        }
        int m = this.A[0].length;
        int n = b.ncols();
        int l = b.nrows();
        double[][] C = new double[m][n];
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                C[i][j] = 0.0;
                for (int k = 0; k < l; ++k) {
                    double[] dArray = C[i];
                    int n2 = j;
                    dArray[n2] = dArray[n2] + this.A[k][i] * b.get(k, j);
                }
            }
        }
        return new NaiveMatrix(C);
    }

    @Override
    public NaiveMatrix transpose() {
        int m = this.A.length;
        int n = this.A[0].length;
        double[][] B = new double[n][m];
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                B[j][i] = this.A[i][j];
            }
        }
        return new NaiveMatrix(B);
    }
}

