/*
 * Decompiled with CFR 0.152.
 */
package smile.math.distance;

import java.io.Serializable;
import smile.math.distance.Metric;

public class ChebyshevDistance
implements Metric<double[]>,
Serializable {
    private static final long serialVersionUID = 1L;

    public String toString() {
        return "Chebyshev distance";
    }

    public static double d(int[] x, int[] y) {
        if (x.length != y.length) {
            throw new IllegalArgumentException(String.format("Arrays have different length: x[%d], y[%d]", x.length, y.length));
        }
        double dist = 0.0;
        for (int i = 0; i < x.length; ++i) {
            double d = Math.abs(x[i] - y[i]);
            if (!(dist < d)) continue;
            dist = d;
        }
        return dist;
    }

    public static double d(float[] x, float[] y) {
        if (x.length != y.length) {
            throw new IllegalArgumentException(String.format("Arrays have different length: x[%d], y[%d]", x.length, y.length));
        }
        double dist = 0.0;
        for (int i = 0; i < x.length; ++i) {
            double d;
            if (Float.isNaN(x[i]) || Float.isNaN(y[i]) || !(dist < (d = (double)Math.abs(x[i] - y[i])))) continue;
            dist = d;
        }
        return dist;
    }

    @Override
    public double d(double[] x, double[] y) {
        if (x.length != y.length) {
            throw new IllegalArgumentException(String.format("Arrays have different length: x[%d], y[%d]", x.length, y.length));
        }
        double dist = 0.0;
        for (int i = 0; i < x.length; ++i) {
            double d;
            if (Double.isNaN(x[i]) || Double.isNaN(y[i]) || !(dist < (d = Math.abs(x[i] - y[i])))) continue;
            dist = d;
        }
        return dist;
    }
}

