/*
 * Decompiled with CFR 0.152.
 */
package smile.json;

import java.io.Serializable;
import java.net.InetAddress;
import java.net.NetPermission;
import java.net.NetworkInterface;
import java.security.MessageDigest;
import java.util.Enumeration;
import java.util.concurrent.atomic.AtomicInteger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Random$;
import scala.util.Try;
import scala.util.Try$;
import smile.json.ObjectId;

public final class ObjectId$
implements Serializable {
    public static final ObjectId$ MODULE$;
    private static final int size;
    private static final MessageDigest md5Encoder;
    private static final int maxCounterValue;
    private static final AtomicInteger increment;
    private static final byte[] machineId;

    static {
        byte[] byArray;
        MODULE$ = new ObjectId$();
        size = 12;
        md5Encoder = MessageDigest.getInstance("MD5");
        maxCounterValue = 0x1000000;
        increment = new AtomicInteger(Random$.MODULE$.nextInt(MODULE$.maxCounterValue()));
        boolean validPlatform = BoxesRunTime.unboxToBoolean((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable)() -> {
            boolean correctVersion = (double)StringOps$.MODULE$.toFloat$extension(Predef$.MODULE$.augmentString(System.getProperty("java.version").substring(0, 3))) >= 1.8;
            String string = System.getProperty("java.net.preferIPv4Stack");
            Boolean bl = BoxesRunTime.boxToBoolean((boolean)true);
            boolean noIpv6 = !(string != null ? !string.equals(bl) : bl != null);
            String string2 = System.getProperty("os.name");
            String string3 = "Linux";
            boolean isLinux = !(string2 != null ? !string2.equals(string3) : string3 != null);
            return !isLinux || correctVersion || noIpv6;
        }).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> false));
        SecurityManager sec = System.getSecurityManager();
        boolean permitted = BoxesRunTime.unboxToBoolean((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> sec.checkPermission(new NetPermission("getNetworkInformation"))).toOption().map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ObjectId$.$anonfun$machineId$4(x$2))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> false));
        if (validPlatform && permitted) {
            Enumeration<NetworkInterface> networkInterfacesEnum = NetworkInterface.getNetworkInterfaces();
            Iterator networkInterfaces = CollectionConverters$.MODULE$.EnumerationHasAsScala(networkInterfacesEnum).asScala();
            byte[] ha2 = (byte[])networkInterfaces.find((Function1 & Serializable)ha -> BoxesRunTime.boxToBoolean((boolean)ObjectId$.$anonfun$machineId$6(ha))).map((Function1 & Serializable)x$3 -> x$3.getHardwareAddress()).getOrElse((Function0 & Serializable)() -> InetAddress.getLocalHost().getHostName().getBytes());
            byArray = (byte[])ArrayOps$.MODULE$.take$extension(Predef$.MODULE$.byteArrayOps(MODULE$.md5(ha2)), 3);
        } else {
            int threadId = (int)Thread.currentThread().getId();
            byte[] arr = new byte[]{(byte)(threadId & 0xFF), (byte)(threadId >> 8 & 0xFF), (byte)(threadId >> 16 & 0xFF)};
            byArray = arr;
        }
        machineId = byArray;
    }

    public int size() {
        return size;
    }

    private MessageDigest md5Encoder() {
        return md5Encoder;
    }

    private byte[] md5(byte[] bytes) {
        return this.md5Encoder().digest(bytes);
    }

    private int maxCounterValue() {
        return maxCounterValue;
    }

    private AtomicInteger increment() {
        return increment;
    }

    private int counter() {
        return (this.increment().getAndIncrement() + this.maxCounterValue()) % this.maxCounterValue();
    }

    public String bytes2hex(byte[] bytes) {
        return Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.byteArrayOps(bytes), (Function1 & Serializable)x$1 -> StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%02X"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToByte((byte)BoxesRunTime.unboxToByte((Object)x$1))})), ClassTag$.MODULE$.apply(String.class))).mkString();
    }

    /*
     * WARNING - void declaration
     */
    public byte[] hex2bytes(String s) {
        void var2_2;
        Predef$.MODULE$.require(s.length() % 2 == 0, (Function0 & Serializable)() -> "Hexadecimal string must contain an even number of characters");
        byte[] bytes = new byte[s.length() / 2];
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), s.length()).by(2).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            bytes$1[i / 2] = (byte)Integer.parseInt(s.substring(i, i + 2), 16);
        });
        return var2_2;
    }

    private byte[] machineId() {
        return machineId;
    }

    public ObjectId apply() {
        return this.generate();
    }

    public ObjectId apply(String id) {
        Predef$.MODULE$.require(id.length() == 24, (Function0 & Serializable)() -> new StringBuilder(18).append("wrong ObjectId: '").append(id).append("'").toString());
        return new ObjectId(this.hex2bytes(id));
    }

    public Try<ObjectId> parse(String str) {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> MODULE$.apply(str));
    }

    public ObjectId generate() {
        return this.fromTime(System.currentTimeMillis(), false);
    }

    public ObjectId fromTime(long timeMillis, boolean fillOnlyTimestamp) {
        int timestamp = (int)(timeMillis / 1000L);
        byte[] id = new byte[12];
        id[0] = (byte)(timestamp >>> 24);
        id[1] = (byte)(timestamp >> 16 & 0xFF);
        id[2] = (byte)(timestamp >> 8 & 0xFF);
        id[3] = (byte)(timestamp & 0xFF);
        if (!fillOnlyTimestamp) {
            id[4] = this.machineId()[0];
            id[5] = this.machineId()[1];
            id[6] = this.machineId()[2];
            int threadId = (int)Thread.currentThread().getId();
            id[7] = (byte)(threadId & 0xFF);
            id[8] = (byte)(threadId >> 8 & 0xFF);
            int c = this.counter();
            id[9] = (byte)(c >> 16 & 0xFF);
            id[10] = (byte)(c >> 8 & 0xFF);
            id[11] = (byte)(c & 0xFF);
        }
        return new ObjectId(id);
    }

    public boolean fromTime$default$2() {
        return true;
    }

    public ObjectId apply(byte[] id) {
        return new ObjectId(id);
    }

    public Option<byte[]> unapply(ObjectId x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)x$0.id());
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ObjectId$.class);
    }

    public static final /* synthetic */ boolean $anonfun$machineId$4(BoxedUnit x$2) {
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$machineId$6(NetworkInterface ha) {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> ha.getHardwareAddress()).isSuccess() && ha.getHardwareAddress() != null && ha.getHardwareAddress().length == 6;
    }

    private ObjectId$() {
    }
}

