/*
 * Decompiled with CFR 0.152.
 */
package smile.json;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.control.Breaks;
import smile.json.JsArray;
import smile.json.JsArray$;
import smile.json.JsBinary;
import smile.json.JsBoolean;
import smile.json.JsCounter;
import smile.json.JsDate;
import smile.json.JsDateTime;
import smile.json.JsDateTime$;
import smile.json.JsDecimal;
import smile.json.JsDecimal$;
import smile.json.JsDouble;
import smile.json.JsDouble$;
import smile.json.JsInt;
import smile.json.JsInt$;
import smile.json.JsLong;
import smile.json.JsLong$;
import smile.json.JsNull$;
import smile.json.JsObject;
import smile.json.JsObject$;
import smile.json.JsObjectId;
import smile.json.JsString;
import smile.json.JsTime;
import smile.json.JsTimestamp;
import smile.json.JsUUID;
import smile.json.JsUUID$;
import smile.json.JsUndefined$;
import smile.json.JsValue;
import smile.json.JsonSerializer$;
import smile.json.ObjectId;
import smile.json.ObjectId$;
import smile.json.package$;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@ScalaSignature(bytes="\u0006\u0005\r}e!B>}\u0001\u0005\r\u0001BCA\u0013\u0001\t\u0005\t\u0015!\u0003\u0002(!9\u0011q\u0007\u0001\u0005\u0002\u0005e\u0002bBA!\u0001\u0011\u0005\u00111\t\u0005\b\u00033\u0002A\u0011AA.\u0011\u001d\tI\u0006\u0001C\u0001\u0003CBq!!\u001a\u0001\t\u0003\t9\u0007C\u0004\u0002B\u0001!I!a\u001c\t\u000f\u0005\u0005\u0003\u0001\"\u0003\u0002\u0014\"9\u0011\u0011\t\u0001\u0005\n\u0005e\u0005bBA!\u0001\u0011%\u0011\u0011\u0016\u0005\b\u0003\u0003\u0002A\u0011BA\\\u0011\u001d\t\t\u0005\u0001C\u0005\u0003\u000bDq!!\u0011\u0001\t\u0013\t\u0019\u000eC\u0004\u0002B\u0001!I!!9\t\u000f\u0005\u0005\u0003\u0001\"\u0003\u0002p\"9\u0011\u0011\t\u0001\u0005\n\u0005u\bbBA!\u0001\u0011%!1\u0002\u0005\b\u0003\u0003\u0002A\u0011\u0002B\r\u0011\u001d\t\t\u0005\u0001C\u0005\u0005OAq!!\u0011\u0001\t\u0013\u0011)\u0004C\u0004\u0002B\u0001!IAa\u0011\t\u000f\tE\u0003\u0001\"\u0003\u0003T!9\u0011q\u0015\u0001\u0005\n\t]\u0003b\u0002B.\u0001\u0011%!Q\f\u0005\b\u0005C\u0002A\u0011\u0002B2\u0011\u001d\u00119\u0007\u0001C\u0005\u0005SBqA!\u001c\u0001\t\u0013\u0011y\u0007C\u0004\u0003t\u0001!IA!\u001e\t\u000f\te\u0004\u0001\"\u0003\u0003|!9!q\u0010\u0001\u0005\n\t\u0005\u0005b\u0002BC\u0001\u0011%!q\u0011\u0005\b\u0005\u0017\u0003A\u0011\u0002BG\u0011\u001d\u0011\t\n\u0001C\u0005\u0005'Cq!!\u001e\u0001\t\u0013\u00119\nC\u0004\u0003\u001c\u0002!IA!(\t\u000f\u0005\u0005\u0003\u0001\"\u0003\u0003\"\"9\u0011\u0011\t\u0001\u0005\n\t=\u0006bBA!\u0001\u0011%!Q\u0018\u0005\b\u00033\u0002A\u0011\u0002Bc\u000f\u001d\u0011Y\r E\u0001\u0005\u001b4aa\u001f?\t\u0002\t=\u0007bBA\u001cS\u0011\u0005!\u0011\u001b\u0005\n\u0005'L#\u0019!C\u0001\u0005+D\u0001Ba9*A\u0003%!q\u001b\u0005\n\u0005KL#\u0019!C\u0001\u0005OD\u0001B!;*A\u0003%\u00111\n\u0005\n\u0005WL#\u0019!C\u0001\u0005OD\u0001B!<*A\u0003%\u00111\n\u0005\n\u0005_L#\u0019!C\u0001\u0005OD\u0001B!=*A\u0003%\u00111\n\u0005\n\u0005gL#\u0019!C\u0001\u0005OD\u0001B!>*A\u0003%\u00111\n\u0005\n\u0005oL#\u0019!C\u0001\u0005OD\u0001B!?*A\u0003%\u00111\n\u0005\n\u0005wL#\u0019!C\u0001\u0005OD\u0001B!@*A\u0003%\u00111\n\u0005\n\u0005\u007fL#\u0019!C\u0001\u0005OD\u0001b!\u0001*A\u0003%\u00111\n\u0005\n\u0007\u0007I#\u0019!C\u0001\u0005OD\u0001b!\u0002*A\u0003%\u00111\n\u0005\n\u0007\u000fI#\u0019!C\u0001\u0005OD\u0001b!\u0003*A\u0003%\u00111\n\u0005\n\u0007\u0017I#\u0019!C\u0001\u0005OD\u0001b!\u0004*A\u0003%\u00111\n\u0005\n\u0007\u001fI#\u0019!C\u0001\u0005OD\u0001b!\u0005*A\u0003%\u00111\n\u0005\n\u0007'I#\u0019!C\u0001\u0005OD\u0001b!\u0006*A\u0003%\u00111\n\u0005\n\u0007/I#\u0019!C\u0001\u0005OD\u0001b!\u0007*A\u0003%\u00111\n\u0005\n\u00077I#\u0019!C\u0001\u0005OD\u0001b!\b*A\u0003%\u00111\n\u0005\n\u0007?I#\u0019!C\u0001\u0005OD\u0001b!\t*A\u0003%\u00111\n\u0005\n\u0007GI#\u0019!C\u0001\u0005OD\u0001b!\n*A\u0003%\u00111\n\u0005\n\u0007OI#\u0019!C\u0001\u0005OD\u0001b!\u000b*A\u0003%\u00111\n\u0005\n\u0007WI#\u0019!C\u0001\u0005OD\u0001b!\f*A\u0003%\u00111\n\u0005\n\u0007_I#\u0019!C\u0001\u0005OD\u0001b!\r*A\u0003%\u00111\n\u0005\n\u0007gI#\u0019!C\u0001\u0005OD\u0001b!\u000e*A\u0003%\u00111\n\u0005\n\u0007oI#\u0019!C\u0001\u0005OD\u0001b!\u000f*A\u0003%\u00111\n\u0005\n\u0007wI#\u0019!C\u0001\u0005OD\u0001b!\u0010*A\u0003%\u00111\n\u0005\n\u0007\u007fI#\u0019!C\u0001\u0005OD\u0001b!\u0011*A\u0003%\u00111\n\u0005\n\u0007\u0007J#\u0019!C\u0001\u0005OD\u0001b!\u0012*A\u0003%\u00111\n\u0005\n\u0007\u000fJ#\u0019!C\u0001\u0005OD\u0001b!\u0013*A\u0003%\u00111\n\u0005\n\u0007\u0017J#\u0019!C\u0001\u0005OD\u0001b!\u0014*A\u0003%\u00111\n\u0005\n\u0007\u001fJ#\u0019!C\u0001\u0005OD\u0001b!\u0015*A\u0003%\u00111\n\u0005\n\u0007'J#\u0019!C\u0001\u0005OD\u0001b!\u0016*A\u0003%\u00111\n\u0005\n\u0007/J#\u0019!C\u0001\u0005OD\u0001b!\u0017*A\u0003%\u00111\n\u0005\n\u00077J#\u0019!C\u0001\u0005OD\u0001b!\u0018*A\u0003%\u00111\n\u0005\n\u0007?J#\u0019!C\u0001\u0005OD\u0001b!\u0019*A\u0003%\u00111\n\u0005\n\u0007GJ#\u0019!C\u0001\u0005OD\u0001b!\u001a*A\u0003%\u00111\n\u0005\n\u0007OJ#\u0019!C\u0001\u0005OD\u0001b!\u001b*A\u0003%\u00111\n\u0005\n\u0007WJ#\u0019!C\u0001\u0005OD\u0001b!\u001c*A\u0003%\u00111\n\u0005\n\u0007_J#\u0019!C\u0001\u0005OD\u0001b!\u001d*A\u0003%\u00111\n\u0005\n\u0007gJ#\u0019!C\u0001\u0005OD\u0001b!\u001e*A\u0003%\u00111\n\u0005\n\u0007oJ#\u0019!C\u0001\u0007sB\u0001ba\u001f*A\u0003%\u0011Q\t\u0005\n\u0007{J#\u0019!C\u0001\u0007sB\u0001ba *A\u0003%\u0011Q\t\u0005\b\u0007\u0003KC1ABB\u0011%\u00199)KI\u0001\n\u0003\u0019II\u0001\bKg>t7+\u001a:jC2L'0\u001a:\u000b\u0005ut\u0018\u0001\u00026t_:T\u0011a`\u0001\u0006g6LG.Z\u0002\u0001'\u0015\u0001\u0011QAA\t!\u0011\t9!!\u0004\u000e\u0005\u0005%!BAA\u0006\u0003\u0015\u00198-\u00197b\u0013\u0011\ty!!\u0003\u0003\r\u0005s\u0017PU3g!\u0011\t\u0019\"!\t\u000e\u0005\u0005U!\u0002BA\f\u00033\tAb]2bY\u0006dwnZ4j]\u001eTA!a\u0007\u0002\u001e\u0005AA/\u001f9fg\u00064WM\u0003\u0002\u0002 \u0005\u00191m\\7\n\t\u0005\r\u0012Q\u0003\u0002\f\u0019\u0006T\u0018\u0010T8hO&tw-\u0001\u0004ck\u001a4WM\u001d\t\u0005\u0003S\t\u0019$\u0004\u0002\u0002,)!\u0011QFA\u0018\u0003\rq\u0017n\u001c\u0006\u0003\u0003c\tAA[1wC&!\u0011QGA\u0016\u0005)\u0011\u0015\u0010^3Ck\u001a4WM]\u0001\u0007y%t\u0017\u000e\u001e \u0015\t\u0005m\u0012q\b\t\u0004\u0003{\u0001Q\"\u0001?\t\u0013\u0005\u0015\"\u0001%AA\u0002\u0005\u001d\u0012!C:fe&\fG.\u001b>f)\u0011\t)%!\u0015\u0011\r\u0005\u001d\u0011qIA&\u0013\u0011\tI%!\u0003\u0003\u000b\u0005\u0013(/Y=\u0011\t\u0005\u001d\u0011QJ\u0005\u0005\u0003\u001f\nIA\u0001\u0003CsR,\u0007BB?\u0004\u0001\u0004\t\u0019\u0006\u0005\u0003\u0002>\u0005U\u0013bAA,y\n9!j\u001d,bYV,\u0017a\u00033fg\u0016\u0014\u0018.\u00197ju\u0016$B!a\u0015\u0002^!9\u0011q\f\u0003A\u0002\u0005\u0015\u0013!\u00022zi\u0016\u001cH\u0003BA*\u0003GBq!!\n\u0006\u0001\u0004\t9#A\u0003dY\u0016\f'/\u0006\u0002\u0002jA!\u0011qAA6\u0013\u0011\ti'!\u0003\u0003\tUs\u0017\u000e\u001e\u000b\u0007\u0003S\n\t(a\u001d\t\u000f\u0005\u0015r\u00011\u0001\u0002(!9\u0011QO\u0004A\u0002\u0005]\u0014AB:ue&tw\r\u0005\u0004\u0002\b\u0005e\u0014QP\u0005\u0005\u0003w\nIA\u0001\u0004PaRLwN\u001c\t\u0005\u0003\u007f\niI\u0004\u0003\u0002\u0002\u0006%\u0005\u0003BAB\u0003\u0013i!!!\"\u000b\t\u0005\u001d\u0015\u0011A\u0001\u0007yI|w\u000e\u001e \n\t\u0005-\u0015\u0011B\u0001\u0007!J,G-\u001a4\n\t\u0005=\u0015\u0011\u0013\u0002\u0007'R\u0014\u0018N\\4\u000b\t\u0005-\u0015\u0011\u0002\u000b\u0007\u0003S\n)*a&\t\u000f\u0005\u0015\u0002\u00021\u0001\u0002(!9\u0011Q\u000f\u0005A\u0002\u0005uD\u0003CA5\u00037\u000bi*!*\t\u000f\u0005\u0015\u0012\u00021\u0001\u0002(!1Q0\u0003a\u0001\u0003?\u0003B!!\u0010\u0002\"&\u0019\u00111\u0015?\u0003\u0013)\u001b(i\\8mK\u0006t\u0007bBAT\u0013\u0001\u0007\u0011qO\u0001\u0006K:\fW.\u001a\u000b\t\u0003S\nY+!,\u00026\"9\u0011Q\u0005\u0006A\u0002\u0005\u001d\u0002BB?\u000b\u0001\u0004\ty\u000b\u0005\u0003\u0002>\u0005E\u0016bAAZy\n)!j]%oi\"9\u0011q\u0015\u0006A\u0002\u0005]D\u0003CA5\u0003s\u000bY,a1\t\u000f\u0005\u00152\u00021\u0001\u0002(!1Qp\u0003a\u0001\u0003{\u0003B!!\u0010\u0002@&\u0019\u0011\u0011\u0019?\u0003\r)\u001bHj\u001c8h\u0011\u001d\t9k\u0003a\u0001\u0003o\"\u0002\"!\u001b\u0002H\u0006%\u0017\u0011\u001b\u0005\b\u0003Ka\u0001\u0019AA\u0014\u0011\u0019iH\u00021\u0001\u0002LB!\u0011QHAg\u0013\r\ty\r \u0002\t\u0015N$u.\u001e2mK\"9\u0011q\u0015\u0007A\u0002\u0005]D\u0003CA5\u0003+\f9.a8\t\u000f\u0005\u0015R\u00021\u0001\u0002(!1Q0\u0004a\u0001\u00033\u0004B!!\u0010\u0002\\&\u0019\u0011Q\u001c?\u0003\u0013)\u001bH)Z2j[\u0006d\u0007bBAT\u001b\u0001\u0007\u0011q\u000f\u000b\t\u0003S\n\u0019/!:\u0002n\"9\u0011Q\u0005\bA\u0002\u0005\u001d\u0002BB?\u000f\u0001\u0004\t9\u000f\u0005\u0003\u0002>\u0005%\u0018bAAvy\nA!j]*ue&tw\rC\u0004\u0002(:\u0001\r!a\u001e\u0015\u0011\u0005%\u0014\u0011_Az\u0003wDq!!\n\u0010\u0001\u0004\t9\u0003\u0003\u0004~\u001f\u0001\u0007\u0011Q\u001f\t\u0005\u0003{\t90C\u0002\u0002zr\u0014aAS:ECR,\u0007bBAT\u001f\u0001\u0007\u0011q\u000f\u000b\t\u0003S\nyP!\u0001\u0003\n!9\u0011Q\u0005\tA\u0002\u0005\u001d\u0002BB?\u0011\u0001\u0004\u0011\u0019\u0001\u0005\u0003\u0002>\t\u0015\u0011b\u0001B\u0004y\n1!j\u001d+j[\u0016Dq!a*\u0011\u0001\u0004\t9\b\u0006\u0005\u0002j\t5!q\u0002B\f\u0011\u001d\t)#\u0005a\u0001\u0003OAa!`\tA\u0002\tE\u0001\u0003BA\u001f\u0005'I1A!\u0006}\u0005)Q5\u000fR1uKRKW.\u001a\u0005\b\u0003O\u000b\u0002\u0019AA<)!\tIGa\u0007\u0003\u001e\t\u0015\u0002bBA\u0013%\u0001\u0007\u0011q\u0005\u0005\u0007{J\u0001\rAa\b\u0011\t\u0005u\"\u0011E\u0005\u0004\u0005Ga(a\u0003&t)&lWm\u001d;b[BDq!a*\u0013\u0001\u0004\t9\b\u0006\u0005\u0002j\t%\"1\u0006B\u001a\u0011\u001d\t)c\u0005a\u0001\u0003OAa!`\nA\u0002\t5\u0002\u0003BA\u001f\u0005_I1A!\r}\u0005)Q5o\u00142kK\u000e$\u0018\n\u001a\u0005\b\u0003O\u001b\u0002\u0019AA<)!\tIGa\u000e\u0003:\t\u0005\u0003bBA\u0013)\u0001\u0007\u0011q\u0005\u0005\u0007{R\u0001\rAa\u000f\u0011\t\u0005u\"QH\u0005\u0004\u0005\u007fa(A\u0002&t+VKE\tC\u0004\u0002(R\u0001\r!a\u001e\u0015\u0011\u0005%$Q\tB$\u0005\u001fBq!!\n\u0016\u0001\u0004\t9\u0003\u0003\u0004~+\u0001\u0007!\u0011\n\t\u0005\u0003{\u0011Y%C\u0002\u0003Nq\u0014\u0001BS:CS:\f'/\u001f\u0005\b\u0003O+\u0002\u0019AA<\u0003\u001d\u00197\u000f\u001e:j]\u001e$B!! \u0003V!9\u0011Q\u0005\fA\u0002\u0005\u001dB\u0003BA?\u00053Bq!!\n\u0018\u0001\u0004\t9#A\u0004c_>dW-\u00198\u0015\t\u0005}%q\f\u0005\b\u0003KA\u0002\u0019AA\u0014\u0003\rIg\u000e\u001e\u000b\u0005\u0003_\u0013)\u0007C\u0004\u0002&e\u0001\r!a\n\u0002\t1|gn\u001a\u000b\u0005\u0003{\u0013Y\u0007C\u0004\u0002&i\u0001\r!a\n\u0002\r\u0011|WO\u00197f)\u0011\tYM!\u001d\t\u000f\u0005\u00152\u00041\u0001\u0002(\u00059A-Z2j[\u0006dG\u0003BAm\u0005oBq!!\n\u001d\u0001\u0004\t9#\u0001\u0003eCR,G\u0003BA{\u0005{Bq!!\n\u001e\u0001\u0004\t9#\u0001\u0003uS6,G\u0003\u0002B\u0002\u0005\u0007Cq!!\n\u001f\u0001\u0004\t9#\u0001\u0005eCR,G/[7f)\u0011\u0011\tB!#\t\u000f\u0005\u0015r\u00041\u0001\u0002(\u0005IA/[7fgR\fW\u000e\u001d\u000b\u0005\u0005?\u0011y\tC\u0004\u0002&\u0001\u0002\r!a\n\u0002\u0011=\u0014'.Z2u\u0013\u0012$B!a\u0015\u0003\u0016\"9\u0011QE\u0011A\u0002\u0005\u001dB\u0003BAt\u00053Cq!!\n#\u0001\u0004\t9#\u0001\u0004cS:\f'/\u001f\u000b\u0005\u0003'\u0012y\nC\u0004\u0002&\r\u0002\r!a\n\u0015\u0011\u0005%$1\u0015BS\u0005[Cq!!\n%\u0001\u0004\t9\u0003\u0003\u0004~I\u0001\u0007!q\u0015\t\u0005\u0003{\u0011I+C\u0002\u0003,r\u0014\u0001BS:PE*,7\r\u001e\u0005\b\u0003O#\u0003\u0019AA<)!\tIG!-\u00034\nm\u0006bBA\u0013K\u0001\u0007\u0011q\u0005\u0005\u0007{\u0016\u0002\rA!.\u0011\t\u0005u\"qW\u0005\u0004\u0005sc(a\u0002&t\u0003J\u0014\u0018-\u001f\u0005\b\u0003O+\u0003\u0019AA<)!\tIGa0\u0003B\n\r\u0007bBA\u0013M\u0001\u0007\u0011q\u0005\u0005\u0007{\u001a\u0002\r!a\u0015\t\u000f\u0005\u001df\u00051\u0001\u0002xQ1!q\u0015Bd\u0005\u0013Dq!!\n(\u0001\u0004\t9\u0003\u0003\u0004~O\u0001\u0007!qU\u0001\u000f\u0015N|gnU3sS\u0006d\u0017N_3s!\r\ti$K\n\u0004S\u0005\u0015AC\u0001Bg\u0003\u0011)FK\u0012\u001d\u0016\u0005\t]\u0007\u0003\u0002Bm\u0005?l!Aa7\u000b\t\tu\u00171F\u0001\bG\"\f'o]3u\u0013\u0011\u0011\tOa7\u0003\u000f\rC\u0017M]:fi\u0006)Q\u000b\u0016$9A\u0005yQI\u0014#`\u001f\u001a{FiT\"V\u001b\u0016sE+\u0006\u0002\u0002L\u0005\u0001RI\u0014#`\u001f\u001a{FiT\"V\u001b\u0016sE\u000bI\u0001\u000e\u000b:#ul\u0014$`'R\u0013\u0016JT$\u0002\u001d\u0015sEiX(G?N#&+\u0013(HA\u0005YA+\u0017)F?\u0012{UK\u0011'F\u00031!\u0016\fU#`\t>+&\tT#!\u0003-!\u0016\fU#`'R\u0013\u0016JT$\u0002\u0019QK\u0006+R0T)JKej\u0012\u0011\u0002\u001bQK\u0006+R0E\u001f\u000e+V*\u0012(U\u00039!\u0016\fU#`\t>\u001bU+T#O)\u0002\n!\u0002V-Q\u000b~\u000b%KU!Z\u0003-!\u0016\fU#`\u0003J\u0013\u0016)\u0017\u0011\u0002\u0017QK\u0006+R0C\u0013:\u000b%+W\u0001\r)f\u0003Vi\u0018\"J\u001d\u0006\u0013\u0016\fI\u0001\u000f)f\u0003ViX+O\t\u00163\u0015JT#E\u0003=!\u0016\fU#`+:#UIR%O\u000b\u0012\u0003\u0013!\u0004+Z!\u0016{vJ\u0011&F\u0007RKE)\u0001\bU3B+ul\u0014\"K\u000b\u000e#\u0016\n\u0012\u0011\u0002\u0019QK\u0006+R0C\u001f>cU)\u0011(\u0002\u001bQK\u0006+R0C\u001f>cU)\u0011(!\u00039!\u0016\fU#`)&kUi\u0015+B\u001bB\u000bq\u0002V-Q\u000b~#\u0016*T#T)\u0006k\u0005\u000bI\u0001\n)f\u0003Vi\u0018(V\u00192\u000b!\u0002V-Q\u000b~sU\u000b\u0014'!\u0003)!\u0016\fU#`%\u0016;U\tW\u0001\f)f\u0003Vi\u0018*F\u000f\u0016C\u0006%\u0001\bU3B+u\f\u0012\"Q\u001f&sE+\u0012*\u0002\u001fQK\u0006+R0E\u0005B{\u0015J\u0014+F%\u0002\nq\u0002V-Q\u000b~S\u0015IV!T\u0007JK\u0005\u000bV\u0001\u0011)f\u0003Vi\u0018&B-\u0006\u001b6IU%Q)\u0002\n1\u0002V-Q\u000b~\u001b\u0016,\u0014\"P\u0019\u0006aA+\u0017)F?NKVJQ(MA\u0005QB+\u0017)F?*\u000be+Q*D%&\u0003FkX,J)\"{6kQ(Q\u000b\u0006YB+\u0017)F?*\u000be+Q*D%&\u0003FkX,J)\"{6kQ(Q\u000b\u0002\n!\u0002V-Q\u000b~Ke\nV\u001a3\u0003-!\u0016\fU#`\u0013:#6G\r\u0011\u0002-QK\u0006+R0N\u001f:;u\n\u0012\"`)&kUi\u0015+B\u001bB\u000bq\u0003V-Q\u000b~kuJT$P\t\n{F+S'F'R\u000bU\n\u0015\u0011\u0002\u0015QK\u0006+R0J\u001dR3D'A\u0006U3B+u,\u0013(UmQ\u0002\u0013a\u0004+Z!\u0016{F)R\"J\u001b\u0006c\u0015G\r\u001d\u0002!QK\u0006+R0E\u000b\u000eKU*\u0011'2ea\u0002\u0013!\u0003+Z!\u0016{F)\u0011+F\u0003)!\u0016\fU#`\t\u0006#V\tI\u0001\n)f\u0003Vi\u0018+J\u001b\u0016\u000b!\u0002V-Q\u000b~#\u0016*T#!\u00035!\u0016\fU#`\t\u0006#V\tV%N\u000b\u0006qA+\u0017)F?\u0012\u000bE+\u0012+J\u001b\u0016\u0003\u0013a\u0004+Z!\u0016{&)S$E\u000b\u000eKU*\u0011'\u0002!QK\u0006+R0C\u0013\u001e#UiQ%N\u00032\u0003\u0013a\u0003+Z!\u0016{V*\u0013(L\u000bf\u000bA\u0002V-Q\u000b~k\u0015JT&F3\u0002\n1\u0002V-Q\u000b~k\u0015\tW&F3\u0006aA+\u0017)F?6\u000b\u0005lS#ZA\u00051\")\u0013(B%f{6+\u0016\"U3B+ulR#O\u000bJK5)A\fC\u0013:\u000b%+W0T+\n#\u0016\fU#`\u000f\u0016sUIU%DA\u00059\")\u0013(B%f{6+\u0016\"U3B+uLR+O\u0007RKuJT\u0001\u0019\u0005&s\u0015IU-`'V\u0013E+\u0017)F?\u001a+fj\u0011+J\u001f:\u0003\u0013!\u0007\"J\u001d\u0006\u0013\u0016lX*V\u0005RK\u0006+R0C\u0013:\u000b%+W0P\u0019\u0012\u000b!DQ%O\u0003JKvlU+C)f\u0003Vi\u0018\"J\u001d\u0006\u0013\u0016lX(M\t\u0002\nqCQ%O\u0003JKvlU+C)f\u0003ViX+V\u0013\u0012{v\n\u0014#\u00021\tKe*\u0011*Z?N+&\tV-Q\u000b~+V+\u0013#`\u001f2#\u0005%A\nC\u0013:\u000b%+W0T+\n#\u0016\fU#`+VKE)\u0001\u000bC\u0013:\u000b%+W0T+\n#\u0016\fU#`+VKE\tI\u0001\u0013\u0005&s\u0015IU-`'V\u0013E+\u0017)F?6#U'A\nC\u0013:\u000b%+W0T+\n#\u0016\fU#`\u001b\u0012+\u0004%A\u000eC\u0013:\u000b%+W0T+\n#\u0016\fU#`+N+%k\u0018#F\r&sU\tR\u0001\u001d\u0005&s\u0015IU-`'V\u0013E+\u0017)F?V\u001bVIU0E\u000b\u001aKe*\u0012#!\u0003\u0011!&+V#\u0002\u000bQ\u0013V+\u0012\u0011\u0002\u000b\u0019\u000bEjU#\u0002\r\u0019\u000bEjU#!\u0003%)h\u000eZ3gS:,G-\u0006\u0002\u0002F\u0005QQO\u001c3fM&tW\r\u001a\u0011\u0002\t9,H\u000e\\\u0001\u0006]VdG\u000eI\u0001\u0015Ef$XMQ;gM\u0016\u0014('\u0011:sCf\u0014\u0015\u0010^3\u0015\t\u0005\u00153Q\u0011\u0005\b\u0003KI\b\u0019AA\u0014\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%cU\u001111\u0012\u0016\u0005\u0003O\u0019ii\u000b\u0002\u0004\u0010B!1\u0011SBN\u001b\t\u0019\u0019J\u0003\u0003\u0004\u0016\u000e]\u0015!C;oG\",7m[3e\u0015\u0011\u0019I*!\u0003\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0004\u001e\u000eM%!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0002")
public class JsonSerializer
implements LazyLogging {
    private final ByteBuffer buffer;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    public static ByteBuffer $lessinit$greater$default$1() {
        return JsonSerializer$.MODULE$.$lessinit$greater$default$1();
    }

    public static byte[] byteBuffer2ArrayByte(ByteBuffer byteBuffer) {
        return JsonSerializer$.MODULE$.byteBuffer2ArrayByte(byteBuffer);
    }

    public static byte[] null() {
        return JsonSerializer$.MODULE$.null();
    }

    public static byte[] undefined() {
        return JsonSerializer$.MODULE$.undefined();
    }

    public static byte FALSE() {
        return JsonSerializer$.MODULE$.FALSE();
    }

    public static byte TRUE() {
        return JsonSerializer$.MODULE$.TRUE();
    }

    public static byte BINARY_SUBTYPE_USER_DEFINED() {
        return JsonSerializer$.MODULE$.BINARY_SUBTYPE_USER_DEFINED();
    }

    public static byte BINARY_SUBTYPE_MD5() {
        return JsonSerializer$.MODULE$.BINARY_SUBTYPE_MD5();
    }

    public static byte BINARY_SUBTYPE_UUID() {
        return JsonSerializer$.MODULE$.BINARY_SUBTYPE_UUID();
    }

    public static byte BINARY_SUBTYPE_UUID_OLD() {
        return JsonSerializer$.MODULE$.BINARY_SUBTYPE_UUID_OLD();
    }

    public static byte BINARY_SUBTYPE_BINARY_OLD() {
        return JsonSerializer$.MODULE$.BINARY_SUBTYPE_BINARY_OLD();
    }

    public static byte BINARY_SUBTYPE_FUNCTION() {
        return JsonSerializer$.MODULE$.BINARY_SUBTYPE_FUNCTION();
    }

    public static byte BINARY_SUBTYPE_GENERIC() {
        return JsonSerializer$.MODULE$.BINARY_SUBTYPE_GENERIC();
    }

    public static byte TYPE_MAXKEY() {
        return JsonSerializer$.MODULE$.TYPE_MAXKEY();
    }

    public static byte TYPE_MINKEY() {
        return JsonSerializer$.MODULE$.TYPE_MINKEY();
    }

    public static byte TYPE_BIGDECIMAL() {
        return JsonSerializer$.MODULE$.TYPE_BIGDECIMAL();
    }

    public static byte TYPE_DATETIME() {
        return JsonSerializer$.MODULE$.TYPE_DATETIME();
    }

    public static byte TYPE_TIME() {
        return JsonSerializer$.MODULE$.TYPE_TIME();
    }

    public static byte TYPE_DATE() {
        return JsonSerializer$.MODULE$.TYPE_DATE();
    }

    public static byte TYPE_DECIMAL128() {
        return JsonSerializer$.MODULE$.TYPE_DECIMAL128();
    }

    public static byte TYPE_INT64() {
        return JsonSerializer$.MODULE$.TYPE_INT64();
    }

    public static byte TYPE_MONGODB_TIMESTAMP() {
        return JsonSerializer$.MODULE$.TYPE_MONGODB_TIMESTAMP();
    }

    public static byte TYPE_INT32() {
        return JsonSerializer$.MODULE$.TYPE_INT32();
    }

    public static byte TYPE_JAVASCRIPT_WITH_SCOPE() {
        return JsonSerializer$.MODULE$.TYPE_JAVASCRIPT_WITH_SCOPE();
    }

    public static byte TYPE_SYMBOL() {
        return JsonSerializer$.MODULE$.TYPE_SYMBOL();
    }

    public static byte TYPE_JAVASCRIPT() {
        return JsonSerializer$.MODULE$.TYPE_JAVASCRIPT();
    }

    public static byte TYPE_DBPOINTER() {
        return JsonSerializer$.MODULE$.TYPE_DBPOINTER();
    }

    public static byte TYPE_REGEX() {
        return JsonSerializer$.MODULE$.TYPE_REGEX();
    }

    public static byte TYPE_NULL() {
        return JsonSerializer$.MODULE$.TYPE_NULL();
    }

    public static byte TYPE_TIMESTAMP() {
        return JsonSerializer$.MODULE$.TYPE_TIMESTAMP();
    }

    public static byte TYPE_BOOLEAN() {
        return JsonSerializer$.MODULE$.TYPE_BOOLEAN();
    }

    public static byte TYPE_OBJECTID() {
        return JsonSerializer$.MODULE$.TYPE_OBJECTID();
    }

    public static byte TYPE_UNDEFINED() {
        return JsonSerializer$.MODULE$.TYPE_UNDEFINED();
    }

    public static byte TYPE_BINARY() {
        return JsonSerializer$.MODULE$.TYPE_BINARY();
    }

    public static byte TYPE_ARRAY() {
        return JsonSerializer$.MODULE$.TYPE_ARRAY();
    }

    public static byte TYPE_DOCUMENT() {
        return JsonSerializer$.MODULE$.TYPE_DOCUMENT();
    }

    public static byte TYPE_STRING() {
        return JsonSerializer$.MODULE$.TYPE_STRING();
    }

    public static byte TYPE_DOUBLE() {
        return JsonSerializer$.MODULE$.TYPE_DOUBLE();
    }

    public static byte END_OF_STRING() {
        return JsonSerializer$.MODULE$.END_OF_STRING();
    }

    public static byte END_OF_DOCUMENT() {
        return JsonSerializer$.MODULE$.END_OF_DOCUMENT();
    }

    public static Charset UTF8() {
        return JsonSerializer$.MODULE$.UTF8();
    }

    private Logger logger$lzycompute() {
        JsonSerializer jsonSerializer = this;
        synchronized (jsonSerializer) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    public byte[] serialize(JsValue json) {
        this.buffer.clear();
        this.serialize(this.buffer, json, (Option<String>)None$.MODULE$);
        return JsonSerializer$.MODULE$.byteBuffer2ArrayByte(this.buffer);
    }

    public JsValue deserialize(byte[] bytes) {
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        return this.deserialize(buffer);
    }

    public JsValue deserialize(ByteBuffer buffer) {
        JsValue jsValue;
        byte by = buffer.get();
        if (JsonSerializer$.MODULE$.TYPE_BOOLEAN() == by) {
            jsValue = this.boolean(buffer);
        } else if (JsonSerializer$.MODULE$.TYPE_INT32() == by) {
            jsValue = this.int(buffer);
        } else if (JsonSerializer$.MODULE$.TYPE_INT64() == by) {
            jsValue = this.long(buffer);
        } else if (JsonSerializer$.MODULE$.TYPE_DOUBLE() == by) {
            jsValue = this.double(buffer);
        } else if (JsonSerializer$.MODULE$.TYPE_BIGDECIMAL() == by) {
            jsValue = this.decimal(buffer);
        } else if (JsonSerializer$.MODULE$.TYPE_DATE() == by) {
            jsValue = this.date(buffer);
        } else if (JsonSerializer$.MODULE$.TYPE_TIME() == by) {
            jsValue = this.time(buffer);
        } else if (JsonSerializer$.MODULE$.TYPE_DATETIME() == by) {
            jsValue = this.datetime(buffer);
        } else if (JsonSerializer$.MODULE$.TYPE_TIMESTAMP() == by) {
            jsValue = this.timestamp(buffer);
        } else if (JsonSerializer$.MODULE$.TYPE_STRING() == by) {
            jsValue = this.string(buffer);
        } else if (JsonSerializer$.MODULE$.TYPE_BINARY() == by) {
            jsValue = this.binary(buffer);
        } else if (JsonSerializer$.MODULE$.TYPE_OBJECTID() == by) {
            jsValue = this.objectId(buffer);
        } else if (JsonSerializer$.MODULE$.TYPE_NULL() == by) {
            jsValue = JsNull$.MODULE$;
        } else if (JsonSerializer$.MODULE$.TYPE_UNDEFINED() == by) {
            jsValue = JsUndefined$.MODULE$;
        } else if (JsonSerializer$.MODULE$.TYPE_DOCUMENT() == by) {
            JsObject doc = JsObject$.MODULE$.apply((Seq<Tuple2<String, JsValue>>)Nil$.MODULE$);
            jsValue = this.deserialize(buffer, doc);
        } else if (JsonSerializer$.MODULE$.TYPE_ARRAY() == by) {
            JsObject doc = JsObject$.MODULE$.apply((Seq<Tuple2<String, JsValue>>)Nil$.MODULE$);
            this.deserialize(buffer, doc);
            Seq elements = (Seq)((IterableOps)doc.fields().map((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String k = (String)tuple2._1();
                JsValue v = (JsValue)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(k))), (Object)v);
                return tuple22;
            }).toSeq().sortBy((Function1 & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1._1$mcI$sp()), (Ordering)Ordering.Int$.MODULE$)).map((Function1 & Serializable)x$2 -> (JsValue)x$2._2());
            jsValue = JsArray$.MODULE$.apply((Seq<JsValue>)elements);
        } else {
            throw new IllegalStateException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Unsupported BSON type: %02X"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToByte((byte)by)})));
        }
        return jsValue;
    }

    public void clear() {
        this.buffer.clear();
    }

    private void serialize(ByteBuffer buffer, Option<String> string) {
        block0: {
            if (!string.isDefined()) break block0;
            this.serialize(buffer, (String)string.get());
        }
    }

    private void serialize(ByteBuffer buffer, String string) {
        buffer.put(string.getBytes(JsonSerializer$.MODULE$.UTF8()));
        buffer.put(JsonSerializer$.MODULE$.END_OF_STRING());
    }

    private void serialize(ByteBuffer buffer, JsBoolean json, Option<String> ename) {
        buffer.put(JsonSerializer$.MODULE$.TYPE_BOOLEAN());
        this.serialize(buffer, ename);
        buffer.put(json.value() ? JsonSerializer$.MODULE$.TRUE() : JsonSerializer$.MODULE$.FALSE());
    }

    private void serialize(ByteBuffer buffer, JsInt json, Option<String> ename) {
        buffer.put(JsonSerializer$.MODULE$.TYPE_INT32());
        this.serialize(buffer, ename);
        buffer.putInt(json.value());
    }

    private void serialize(ByteBuffer buffer, JsLong json, Option<String> ename) {
        buffer.put(JsonSerializer$.MODULE$.TYPE_INT64());
        this.serialize(buffer, ename);
        buffer.putLong(json.value());
    }

    private void serialize(ByteBuffer buffer, JsDouble json, Option<String> ename) {
        buffer.put(JsonSerializer$.MODULE$.TYPE_DOUBLE());
        this.serialize(buffer, ename);
        buffer.putDouble(json.value());
    }

    private void serialize(ByteBuffer buffer, JsDecimal json, Option<String> ename) {
        buffer.put(JsonSerializer$.MODULE$.TYPE_BIGDECIMAL());
        this.serialize(buffer, ename);
        byte[] bytes = json.value().toPlainString().getBytes(JsonSerializer$.MODULE$.UTF8());
        buffer.putInt(bytes.length);
        buffer.put(bytes);
    }

    private void serialize(ByteBuffer buffer, JsString json, Option<String> ename) {
        buffer.put(JsonSerializer$.MODULE$.TYPE_STRING());
        this.serialize(buffer, ename);
        byte[] bytes = json.value().getBytes(JsonSerializer$.MODULE$.UTF8());
        buffer.putInt(bytes.length);
        buffer.put(bytes);
    }

    private void serialize(ByteBuffer buffer, JsDate json, Option<String> ename) {
        buffer.put(JsonSerializer$.MODULE$.TYPE_DATE());
        this.serialize(buffer, ename);
        LocalDate value = json.value();
        int date = value.getYear() * 10000 + value.getMonthValue() * 100 + value.getDayOfMonth();
        buffer.putInt(date);
    }

    private void serialize(ByteBuffer buffer, JsTime json, Option<String> ename) {
        buffer.put(JsonSerializer$.MODULE$.TYPE_TIME());
        this.serialize(buffer, ename);
        LocalTime value = json.value();
        int time = value.getHour() * 10000 + value.getMinute() * 100 + value.getSecond();
        buffer.putInt(time);
    }

    private void serialize(ByteBuffer buffer, JsDateTime json, Option<String> ename) {
        buffer.put(JsonSerializer$.MODULE$.TYPE_DATETIME());
        this.serialize(buffer, ename);
        LocalDateTime value = json.value();
        int date = value.getYear() * 10000 + value.getMonthValue() * 100 + value.getDayOfMonth();
        int time = value.getHour() * 10000 + value.getMinute() * 100 + value.getSecond();
        buffer.putInt(date);
        buffer.putInt(time);
    }

    private void serialize(ByteBuffer buffer, JsTimestamp json, Option<String> ename) {
        buffer.put(JsonSerializer$.MODULE$.TYPE_TIMESTAMP());
        this.serialize(buffer, ename);
        buffer.putLong(json.value().getTime());
        buffer.putInt(json.value().getNanos());
    }

    private void serialize(ByteBuffer buffer, JsObjectId json, Option<String> ename) {
        buffer.put(JsonSerializer$.MODULE$.TYPE_OBJECTID());
        this.serialize(buffer, ename);
        buffer.put(json.value().id());
    }

    private void serialize(ByteBuffer buffer, JsUUID json, Option<String> ename) {
        buffer.put(JsonSerializer$.MODULE$.TYPE_BINARY());
        this.serialize(buffer, ename);
        buffer.putInt(16);
        buffer.put(JsonSerializer$.MODULE$.BINARY_SUBTYPE_UUID());
        buffer.putLong(json.value().getMostSignificantBits());
        buffer.putLong(json.value().getLeastSignificantBits());
    }

    private void serialize(ByteBuffer buffer, JsBinary json, Option<String> ename) {
        buffer.put(JsonSerializer$.MODULE$.TYPE_BINARY());
        this.serialize(buffer, ename);
        buffer.putInt(ArrayOps$.MODULE$.size$extension(Predef$.MODULE$.byteArrayOps(json.value())));
        buffer.put(JsonSerializer$.MODULE$.BINARY_SUBTYPE_GENERIC());
        buffer.put(json.value());
    }

    private String cstring(ByteBuffer buffer) {
        ArrayBuffer str = new ArrayBuffer(64);
        byte b = buffer.get();
        while (b != JsonSerializer$.MODULE$.END_OF_STRING()) {
            str.$plus$eq((Object)BoxesRunTime.boxToByte((byte)b));
            b = buffer.get();
        }
        return new String((byte[])str.toArray((ClassTag)ClassTag$.MODULE$.Byte()));
    }

    private String ename(ByteBuffer buffer) {
        return this.cstring(buffer);
    }

    private JsBoolean boolean(ByteBuffer buffer) {
        byte b = buffer.get();
        return b == 0 ? package$.MODULE$.JsFalse() : package$.MODULE$.JsTrue();
    }

    private JsInt int(ByteBuffer buffer) {
        int x = buffer.getInt();
        return x == 0 ? JsInt$.MODULE$.zero() : new JsInt(x);
    }

    private JsLong long(ByteBuffer buffer) {
        long x = buffer.getLong();
        return x == 0L ? JsLong$.MODULE$.zero() : new JsLong(x);
    }

    private JsDouble double(ByteBuffer buffer) {
        double x = buffer.getDouble();
        return x == 0.0 ? JsDouble$.MODULE$.zero() : new JsDouble(x);
    }

    private JsDecimal decimal(ByteBuffer buffer) {
        int length = buffer.getInt();
        byte[] dst = new byte[length];
        buffer.get(dst);
        return JsDecimal$.MODULE$.apply(new String(dst, JsonSerializer$.MODULE$.UTF8()));
    }

    private JsDate date(ByteBuffer buffer) {
        int value = buffer.getInt();
        int year = value / 10000;
        int month = value % 10000 / 100;
        int day = value % 100;
        LocalDate date = LocalDate.of(year, month, day);
        return new JsDate(date);
    }

    private JsTime time(ByteBuffer buffer) {
        int value = buffer.getInt();
        int hour = value / 10000;
        int minute = value % 10000 / 100;
        int second = value % 100;
        LocalTime time = LocalTime.of(hour, minute, second);
        return new JsTime(time);
    }

    private JsDateTime datetime(ByteBuffer buffer) {
        int value = buffer.getInt();
        int year = value / 10000;
        int month = value % 10000 / 100;
        int day = value % 100;
        LocalDate date = LocalDate.of(year, month, day);
        int value2 = buffer.getInt();
        int hour = value2 / 10000;
        int minute = value2 % 10000 / 100;
        int second = value2 % 100;
        LocalTime time = LocalTime.of(hour, minute, second);
        return JsDateTime$.MODULE$.apply(date, time);
    }

    private JsTimestamp timestamp(ByteBuffer buffer) {
        long milliseconds = buffer.getLong();
        int nanos = buffer.getInt();
        Timestamp timestamp = new Timestamp(milliseconds);
        timestamp.setNanos(nanos);
        return new JsTimestamp(timestamp);
    }

    private JsValue objectId(ByteBuffer buffer) {
        byte[] id = new byte[ObjectId$.MODULE$.size()];
        buffer.get(id);
        return new JsObjectId(new ObjectId(id));
    }

    private JsString string(ByteBuffer buffer) {
        int length = buffer.getInt();
        byte[] dst = new byte[length];
        buffer.get(dst);
        return new JsString(new String(dst, JsonSerializer$.MODULE$.UTF8()));
    }

    private JsValue binary(ByteBuffer buffer) {
        Product product;
        int length = buffer.getInt();
        byte subtype = buffer.get();
        if (subtype == JsonSerializer$.MODULE$.BINARY_SUBTYPE_UUID()) {
            product = JsUUID$.MODULE$.apply(buffer.getLong(), buffer.getLong());
        } else {
            byte[] dst = new byte[length];
            buffer.get(dst);
            product = new JsBinary(dst);
        }
        return product;
    }

    private void serialize(ByteBuffer buffer, JsObject json, Option<String> ename) {
        buffer.put(JsonSerializer$.MODULE$.TYPE_DOCUMENT());
        this.serialize(buffer, ename);
        int start = buffer.position();
        buffer.putInt(0);
        ((IterableOnceOps)json.fields().toSeq().sortBy((Function1 & Serializable)x$3 -> (String)x$3._1(), (Ordering)Ordering.String$.MODULE$)).foreach((Function1 & Serializable)x0$1 -> {
            JsonSerializer.$anonfun$serialize$2(this, buffer, x0$1);
            return BoxedUnit.UNIT;
        });
        buffer.put(JsonSerializer$.MODULE$.END_OF_DOCUMENT());
        buffer.putInt(start, buffer.position() - start);
    }

    private void serialize(ByteBuffer buffer, JsArray json, Option<String> ename) {
        buffer.put(JsonSerializer$.MODULE$.TYPE_ARRAY());
        this.serialize(buffer, ename);
        int start = buffer.position();
        buffer.putInt(0);
        ((IterableOnceOps)json.elements().zipWithIndex()).foreach((Function1 & Serializable)x0$1 -> {
            JsonSerializer.$anonfun$serialize$3(this, buffer, x0$1);
            return BoxedUnit.UNIT;
        });
        buffer.put(JsonSerializer$.MODULE$.END_OF_DOCUMENT());
        buffer.putInt(start, buffer.position() - start);
    }

    private void serialize(ByteBuffer buffer, JsValue json, Option<String> ename) {
        JsValue jsValue = json;
        if (jsValue instanceof JsBoolean) {
            JsBoolean jsBoolean = (JsBoolean)jsValue;
            this.serialize(buffer, jsBoolean, ename);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (jsValue instanceof JsInt) {
            JsInt jsInt = (JsInt)jsValue;
            this.serialize(buffer, jsInt, ename);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (jsValue instanceof JsLong) {
            JsLong jsLong = (JsLong)jsValue;
            this.serialize(buffer, jsLong, ename);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (jsValue instanceof JsDouble) {
            JsDouble jsDouble = (JsDouble)jsValue;
            this.serialize(buffer, jsDouble, ename);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (jsValue instanceof JsDecimal) {
            JsDecimal jsDecimal = (JsDecimal)jsValue;
            this.serialize(buffer, jsDecimal, ename);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (jsValue instanceof JsString) {
            JsString jsString = (JsString)jsValue;
            this.serialize(buffer, jsString, ename);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (jsValue instanceof JsDate) {
            JsDate jsDate = (JsDate)jsValue;
            this.serialize(buffer, jsDate, ename);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (jsValue instanceof JsTime) {
            JsTime jsTime = (JsTime)jsValue;
            this.serialize(buffer, jsTime, ename);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (jsValue instanceof JsDateTime) {
            JsDateTime jsDateTime = (JsDateTime)jsValue;
            this.serialize(buffer, jsDateTime, ename);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (jsValue instanceof JsTimestamp) {
            JsTimestamp jsTimestamp = (JsTimestamp)jsValue;
            this.serialize(buffer, jsTimestamp, ename);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (jsValue instanceof JsUUID) {
            JsUUID jsUUID = (JsUUID)jsValue;
            this.serialize(buffer, jsUUID, ename);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (jsValue instanceof JsObjectId) {
            JsObjectId jsObjectId = (JsObjectId)jsValue;
            this.serialize(buffer, jsObjectId, ename);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (jsValue instanceof JsBinary) {
            JsBinary jsBinary = (JsBinary)jsValue;
            this.serialize(buffer, jsBinary, ename);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (jsValue instanceof JsObject) {
            JsObject jsObject = (JsObject)jsValue;
            this.serialize(buffer, jsObject, ename);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (jsValue instanceof JsArray) {
            JsArray jsArray = (JsArray)jsValue;
            this.serialize(buffer, jsArray, ename);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (JsNull$.MODULE$.equals(jsValue)) {
            buffer.put(JsonSerializer$.MODULE$.TYPE_NULL());
            this.serialize(buffer, ename);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (JsUndefined$.MODULE$.equals(jsValue)) {
            buffer.put(JsonSerializer$.MODULE$.TYPE_UNDEFINED());
            this.serialize(buffer, ename);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            if (jsValue instanceof JsCounter) {
                throw new IllegalArgumentException("BSON doesn't support JsCounter");
            }
            throw new MatchError((Object)jsValue);
        }
    }

    private JsObject deserialize(ByteBuffer buffer, JsObject json) {
        BoxedUnit boxedUnit;
        int start = buffer.position();
        int size = buffer.getInt();
        Breaks loop = new Breaks();
        loop.breakable((Function0)(JFunction0.mcV.sp & Serializable)() -> {
            while (true) {
                JsValue jsValue;
                byte by = buffer.get();
                if (JsonSerializer$.MODULE$.END_OF_DOCUMENT() == by) {
                    throw loop.break();
                }
                if (JsonSerializer$.MODULE$.TYPE_BOOLEAN() == by) {
                    jsValue = json.update(this.ename(buffer), (JsValue)this.boolean(buffer));
                } else if (JsonSerializer$.MODULE$.TYPE_INT32() == by) {
                    jsValue = json.update(this.ename(buffer), (JsValue)this.int(buffer));
                } else if (JsonSerializer$.MODULE$.TYPE_INT64() == by) {
                    jsValue = json.update(this.ename(buffer), (JsValue)this.long(buffer));
                } else if (JsonSerializer$.MODULE$.TYPE_DOUBLE() == by) {
                    jsValue = json.update(this.ename(buffer), (JsValue)this.double(buffer));
                } else if (JsonSerializer$.MODULE$.TYPE_BIGDECIMAL() == by) {
                    jsValue = json.update(this.ename(buffer), (JsValue)this.decimal(buffer));
                } else if (JsonSerializer$.MODULE$.TYPE_DATE() == by) {
                    jsValue = json.update(this.ename(buffer), (JsValue)this.date(buffer));
                } else if (JsonSerializer$.MODULE$.TYPE_TIME() == by) {
                    jsValue = json.update(this.ename(buffer), (JsValue)this.time(buffer));
                } else if (JsonSerializer$.MODULE$.TYPE_DATETIME() == by) {
                    jsValue = json.update(this.ename(buffer), (JsValue)this.datetime(buffer));
                } else if (JsonSerializer$.MODULE$.TYPE_TIMESTAMP() == by) {
                    jsValue = json.update(this.ename(buffer), (JsValue)this.timestamp(buffer));
                } else if (JsonSerializer$.MODULE$.TYPE_STRING() == by) {
                    jsValue = json.update(this.ename(buffer), (JsValue)this.string(buffer));
                } else if (JsonSerializer$.MODULE$.TYPE_OBJECTID() == by) {
                    jsValue = json.update(this.ename(buffer), this.objectId(buffer));
                } else if (JsonSerializer$.MODULE$.TYPE_BINARY() == by) {
                    jsValue = json.update(this.ename(buffer), this.binary(buffer));
                } else if (JsonSerializer$.MODULE$.TYPE_NULL() == by) {
                    jsValue = json.update(this.ename(buffer), (JsValue)JsNull$.MODULE$);
                } else if (JsonSerializer$.MODULE$.TYPE_UNDEFINED() == by) {
                    jsValue = json.update(this.ename(buffer), (JsValue)JsUndefined$.MODULE$);
                } else if (JsonSerializer$.MODULE$.TYPE_DOCUMENT() == by) {
                    JsObject doc = JsObject$.MODULE$.apply((Seq<Tuple2<String, JsValue>>)Nil$.MODULE$);
                    jsValue = json.update(this.ename(buffer), (JsValue)this.deserialize(buffer, doc));
                } else if (JsonSerializer$.MODULE$.TYPE_ARRAY() == by) {
                    JsObject doc = JsObject$.MODULE$.apply((Seq<Tuple2<String, JsValue>>)Nil$.MODULE$);
                    String field = this.ename(buffer);
                    this.deserialize(buffer, doc);
                    jsValue = json.update(field, (JsValue)JsArray$.MODULE$.apply((Seq<JsValue>)((Seq)((IterableOps)doc.fields().map((Function1 & Serializable)x0$1 -> {
                        Tuple2 tuple2 = x0$1;
                        if (tuple2 == null) {
                            throw new MatchError((Object)tuple2);
                        }
                        String k = (String)tuple2._1();
                        JsValue v = (JsValue)tuple2._2();
                        Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(k))), (Object)v);
                        return tuple22;
                    }).toSeq().sortBy((Function1 & Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4._1$mcI$sp()), (Ordering)Ordering.Int$.MODULE$)).map((Function1 & Serializable)x$5 -> (JsValue)x$5._2()))));
                } else {
                    throw new IllegalStateException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Unsupported BSON type: %02X"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToByte((byte)by)})));
                }
            }
        });
        if (buffer.position() - start != size) {
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn("BSON size {} but deserialize finishes at {}, starts at {}", new Object[]{BoxesRunTime.boxToInteger((int)size), BoxesRunTime.boxToInteger((int)buffer.position()), BoxesRunTime.boxToInteger((int)start)});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return json;
    }

    public static final /* synthetic */ void $anonfun$serialize$2(JsonSerializer $this, ByteBuffer buffer$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String field = (String)tuple2._1();
        JsValue value = (JsValue)tuple2._2();
        $this.serialize(buffer$1, value, (Option<String>)new Some((Object)field));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$serialize$3(JsonSerializer $this, ByteBuffer buffer$2, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        JsValue value = (JsValue)tuple2._1();
        int index = tuple2._2$mcI$sp();
        $this.serialize(buffer$2, value, (Option<String>)new Some((Object)((Object)BoxesRunTime.boxToInteger((int)index)).toString()));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public JsonSerializer(ByteBuffer buffer) {
        this.buffer = buffer;
        LazyLogging.$init$((LazyLogging)this);
    }
}

