/*
 * #%L
 * FaxToMail :: Web
 * $Id: configuration.js 107 2014-05-30 08:55:55Z echatellier $
 * $HeadURL: https://svn.codelutin.com/faxtomail/trunk/faxtomail-ui-web/src/main/webapp/js/configuration.js $
 * %%
 * Copyright (C) 2014 Franciaflex, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

var UserFolderModule = angular.module('UserFolderModule', ['FaxToMail', 'ui.select2.sortable']);

/**
 * Global configuration controller.
 */
UserFolderModule.controller('UserFolderController', ['$scope', '$http', 'UserFolderData',
  function($scope, $http, UserFolderData) {
    //{Array} mail folders
    $scope.mailFolders = UserFolderData.mailFolders;
    // {Array} Liste des utilisateurs ldap
    $scope.users = UserFolderData.users;
    //{Map} Topia id : mailFolders
    $scope.userFolders = UserFolderData.userFolders;
    //{Array} Group list
    $scope.groups = UserFolderData.groups;

    // method privée recursive pour retourner l'ensemble des dossiers
    var recursiveAddMailFolder = function(result, mailFolders) {
      if (mailFolders) {
        angular.forEach(mailFolders, function(mailFolder) {
          result.push(mailFolder);
          recursiveAddMailFolder(result, mailFolder.children);
        });
      }
    };

    // Retourne l'ensemble de l'arbre des dossiers "à plat"
    $scope.flatMailFolders = function() {
      var flatMailFolders = [];
      recursiveAddMailFolder(flatMailFolders, $scope.mailFolders);
      return flatMailFolders;
    };
    
    // fonction retournant l'ensemble des options disponibles
    $scope.getObjectsData = function(term, result) {
      var resultArray = [];
      angular.forEach($scope.mailFolders, function(mailFolder) {
        // select 2 require an id field
        mailFolder.id = mailFolder.topiaId;
        // select 2 can use 'name' for display, so it's ok
        resultArray.push(mailFolder);
      });
      result(resultArray);
    };
}]);
