/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.faxtomail.web.action.admin;

import com.franciaflex.faxtomail.persistence.entities.FaxToMailUser;
import com.franciaflex.faxtomail.persistence.entities.MailFolder;
import com.franciaflex.faxtomail.services.service.ConfigurationService;
import com.franciaflex.faxtomail.services.service.MailFolderService;
import com.franciaflex.faxtomail.web.FaxToMailActionSupport;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.InterceptorRef;
import org.apache.struts2.convention.annotation.InterceptorRefs;
import org.apache.struts2.convention.annotation.Result;

@InterceptorRefs(value={@InterceptorRef(value="loginInterceptor"), @InterceptorRef(value="faxToMailStack")})
public class UserFolderAction
extends FaxToMailActionSupport {
    private static final Log log = LogFactory.getLog(UserFolderAction.class);
    protected ConfigurationService configurationService;
    protected MailFolderService mailFolderService;
    protected List<MailFolder> mailFolders;
    protected List<FaxToMailUser> users;
    protected Map<String, Collection<MailFolder>> userFolders;

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    public void setMailFolderService(MailFolderService mailFolderService) {
        this.mailFolderService = mailFolderService;
    }

    @Action(value="user-folder-input")
    public String input() throws Exception {
        this.mailFolders = this.mailFolderService.getAllMailFolders();
        this.users = this.configurationService.getUserManagedUsers(this.getSession().getAuthenticatedFaxToMailUser());
        this.userFolders = new HashMap();
        for (FaxToMailUser user : this.users) {
            this.userFolders.put(user.getTopiaId(), CollectionUtils.emptyIfNull((Collection)user.getAffectedFolders()));
        }
        return "input";
    }

    @Action(results={@Result(type="redirectAction", params={"actionName", "user-folder-input"})})
    public String execute() throws Exception {
        this.configurationService.saveUserFolders(this.userFolders);
        return "success";
    }

    public List<MailFolder> getMailFolders() {
        return this.mailFolders;
    }

    public List<FaxToMailUser> getUsers() {
        return this.users;
    }

    public Map<String, Collection<MailFolder>> getUserFolders() {
        return this.userFolders;
    }

    public void setUserFoldersJson(String json) {
        Type type = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.userFolders = (Map)this.getGson().fromJson(json, type);
    }
}

