/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.faxtomail.web;

import com.franciaflex.faxtomail.FaxToMailApplicationContext;
import com.franciaflex.faxtomail.FaxToMailConfiguration;
import com.franciaflex.faxtomail.persistence.entities.FaxToMailTopiaPersistenceContext;
import com.franciaflex.faxtomail.persistence.entities.FaxToMailUser;
import com.franciaflex.faxtomail.services.FaxToMailService;
import com.franciaflex.faxtomail.services.FaxToMailServiceContext;
import com.franciaflex.faxtomail.services.service.LdapService;
import com.franciaflex.faxtomail.web.FaxToMailActionSupport;
import com.franciaflex.faxtomail.web.FaxToMailSession;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.ActionProxy;
import com.opensymphony.xwork2.interceptor.Interceptor;
import java.beans.PropertyDescriptor;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.beans.BeanUtil;

public class FaxToMailInterceptor
implements Interceptor {
    private static final Log log = LogFactory.getLog(FaxToMailInterceptor.class);
    public static final String SESSION_LAST_LOCATION = "lastLocation";

    public void init() {
        if (log.isInfoEnabled()) {
            log.info((Object)("init " + this));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String intercept(ActionInvocation invocation) throws Exception {
        Object action = invocation.getAction();
        if (action instanceof FaxToMailActionSupport) {
            FaxToMailActionSupport faxToMailAction = (FaxToMailActionSupport)action;
            FaxToMailServiceContext serviceContext = this.newServiceContext(invocation);
            FaxToMailSession faxToMailSession = this.getFaxToMailSession(invocation);
            this.populateUser(faxToMailSession, serviceContext);
            if (CollectionUtils.isNotEmpty((Collection)faxToMailSession.getMessages())) {
                for (String message : faxToMailSession.getMessages()) {
                    faxToMailAction.addActionMessage(message);
                }
                faxToMailSession.getMessages().clear();
            }
            if (CollectionUtils.isNotEmpty((Collection)faxToMailSession.getErrorMessages())) {
                for (String message : faxToMailSession.getErrorMessages()) {
                    faxToMailAction.addActionError(message);
                }
                faxToMailSession.getErrorMessages().clear();
            }
            Set descriptors = BeanUtil.getDescriptors(action.getClass(), (Predicate)BeanUtil.IS_WRITE_DESCRIPTOR);
            for (PropertyDescriptor propertyDescriptor : descriptors) {
                Class<?> propertyType = propertyDescriptor.getPropertyType();
                FaxToMailService toInject = null;
                if (FaxToMailService.class.isAssignableFrom(propertyType)) {
                    Class<?> serviceClass = propertyType;
                    toInject = serviceContext.newService(serviceClass);
                } else if (FaxToMailSession.class.isAssignableFrom(propertyType)) {
                    toInject = faxToMailSession;
                } else if (FaxToMailConfiguration.class.isAssignableFrom(propertyType)) {
                    this.getFaxToMailApplicationContext(invocation);
                    toInject = FaxToMailApplicationContext.getApplicationConfig();
                }
                if (toInject == null) continue;
                if (log.isTraceEnabled()) {
                    log.trace((Object)("injecting " + toInject + " in action " + action));
                }
                propertyDescriptor.getWriteMethod().invoke(action, toInject);
            }
            try {
                String string = invocation.invoke();
                return string;
            }
            finally {
                serviceContext.getPersistenceContext().close();
            }
        }
        this.saveLastAction(invocation);
        return invocation.invoke();
    }

    protected void populateUser(FaxToMailSession faxToMailSession, FaxToMailServiceContext serviceContext) {
        if (StringUtils.isNotBlank((CharSequence)faxToMailSession.getAuthenticatedUserId())) {
            LdapService ldapService = (LdapService)serviceContext.newService(LdapService.class);
            FaxToMailUser user = ldapService.getUserBean(faxToMailSession.getAuthenticatedUserId());
            faxToMailSession.setAuthenticatedFaxToMailUser(user);
        }
    }

    protected void saveLastAction(ActionInvocation invocation) {
        Map session = invocation.getInvocationContext().getSession();
        ActionProxy proxy = invocation.getProxy();
        String lastLocation = proxy.getNamespace() + "/" + proxy.getActionName() + "!" + proxy.getMethod() + "?";
        Map parameters = invocation.getInvocationContext().getParameters();
        for (String key : parameters.keySet()) {
            Object[] value = (Object[])parameters.get(key);
            lastLocation = lastLocation + key + "=" + value[0] + "&";
        }
        session.put(SESSION_LAST_LOCATION, lastLocation);
    }

    protected FaxToMailSession getFaxToMailSession(ActionInvocation invocation) {
        FaxToMailSession session = (FaxToMailSession)invocation.getInvocationContext().getSession().get("faxToMailSession");
        if (session == null) {
            session = new FaxToMailSession();
            invocation.getInvocationContext().getSession().put("faxToMailSession", session);
        }
        return session;
    }

    protected FaxToMailApplicationContext getFaxToMailApplicationContext(ActionInvocation invocation) {
        FaxToMailApplicationContext applicationContext = (FaxToMailApplicationContext)invocation.getInvocationContext().getApplication().get("faxToMailApplicationContext");
        Preconditions.checkNotNull((Object)applicationContext, (Object)"application context must be initialized before calling an action");
        return applicationContext;
    }

    protected FaxToMailServiceContext newServiceContext(ActionInvocation invocation) {
        FaxToMailApplicationContext extranetEncAhiApplicationContext = this.getFaxToMailApplicationContext(invocation);
        FaxToMailTopiaPersistenceContext persistenceContext = extranetEncAhiApplicationContext.newPersistenceContext();
        FaxToMailServiceContext serviceContext = extranetEncAhiApplicationContext.newServiceContext(persistenceContext);
        return serviceContext;
    }

    public void destroy() {
        if (log.isInfoEnabled()) {
            log.info((Object)("destroy " + this));
        }
    }
}

