package com.franciaflex.faxtomail.ui.swing.content.demande.replies;

/*
 * #%L
 * FaxToMail :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2014 - 2015 Mac-Groupe, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.franciaflex.faxtomail.persistence.entities.Reply;
import com.franciaflex.faxtomail.ui.swing.content.demande.DemandeUIModel;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static jaxx.runtime.JAXXUtil.getStringValue;
import static org.nuiton.i18n.I18n.t;

public class DemandReplyItem extends JPanel implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_EDITABLE = "editable";
    public static final String PROPERTY_REPLY = "reply";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_OPEN_FORWARD_BUTTON_VISIBLE = "openForwardButton.visible";
    public static final String BINDING_REPLY_DATE_LABEL_TEXT = "replyDateLabel.text";
    public static final String BINDING_REPLY_SUBJECT_LABEL_TEXT = "replySubjectLabel.text";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK1Uz28TRxSeLLETJ/xOm9JC1S0cSPgxbmlvQZQ6wSKR20IcJIQvjHfHyaDZnenMLFkrAvEn8CfQey+VeuOEeui5h16q/gsI9dBr1Teza2/sbOQcsOT1eua9733vm3nfz29RRSv0+ROSplglsWERxRvfPnz4Q/cJDcwa1YFi0giFss+Uh7wOmg+H69qgS52WTa/n6fVVEUkR03hf9koLzWnT51TvUGoM+nQ0I9C63h5ur6QyUQPUIaky1Ff/vPNehi9+8hBKJbCrQSv+pKyik+kW8lho0Fmo9JTUOYm3gYZi8TbwPWHXVjnR+nsS0R/RczTTQlVJFIAZdPHoLTsMl59Kg+YUlbx/j8SUG7QRiAj3FIkDRnqcprhHUiMiwjhOGNa7wAQHIjYAjEMakTik2OYzqvGa+79p0dYNjaR0NaoGzdKQGdLl1KAztgds+8INITglcRFWcUQM+vpwDpIqzTRUDygGCszYuq5iATOzAyw4VQbdfy/NwL8H63czzKLKSUd2jRjaIl2r3FnbWZqjbrhFG1obZpxxGe3EXePh/kejQTMGVOkSIP/BCN4WLDeIGkMUksZNoXaJChuJMdAKWhhJy1Zt+CfDrFM2y2lW7H6Whyh0fuSywhjgYgyKezrVgdNKYNmgc52Dk7MJW9nMnBubGQvodv9bXPjz9d+/NgeDMgu1PywN3TfncIGlAvrKnjt0kk1JYhivf0fkSgfGjXJQ15nAhRJi7XwbyEG97DLadHyX6B2AqMz89ea3xcd/HENeE81xQcImsfHrqGZ2FKggeJjKb247Rsd3Z+F52nIDLhFJWZREm2J3VSR2IL0bX6SgwIUSBYY0urXf/11o/3J7oIIHrD4+NLxQovIIVVnMWUydYeReUGoQ81LTJBTFzJe5AAIfWGzANDYZN1TZWQUD6YqGSPMr/6UNOW5DxjYuu+fVMk2qXaFCO4j1Pb/hXjM1+zhQFCbnTiRNP9tYunHN/+qab5/L/rM0sZh1i5IXH7EpOaG0Z9C0oSmcwcqev01NPrxLyzDlgVBQeQlW3QjAGry2rU/a5eVl/6p/0b8O32dQsgcTdd2JBc2AhXEWlFEb84JJ9KaG9M47evuJZO6wdIgGBy3kCFLUenCPc/ut9AjX8HsiO5l7hIH7hYP1spIDQ5pU6BiEPmWauTKn93ym7+Smb5sBLeHkmYjXrd+iWQOmrCMGEsxb/C0mt5wgVwqHDvcbMM6ycS8zO2yYLNXngCEeQZ8RZtMWYZzV5QmsbM5hlMbd9giXo8pJX0AwOnkzhIPzuywOwc1vHYCfss85QPwfRdbVATQJAAA=";
    private static final Log log = LogFactory.getLog(DemandReplyItem.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected Boolean editable;
    protected DemandRepliesUIHandler handler;
    protected JButton openForwardButton;
    protected JButton openReplyButton;
    protected Reply reply;
    protected JLabel replyDateLabel;
    protected DemandReplyItem replyPanel = this;
    protected JLabel replySubjectLabel;
    protected JToolBar toolbar;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public DemandReplyItem(DemandRepliesUIHandler handler) {
        setContextValue(handler);
            $initialize();
    }

    public DemandReplyItem(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public DemandReplyItem(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public DemandReplyItem() {
        $initialize();
    }

    public DemandReplyItem(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public DemandReplyItem(boolean param0) {
        super(param0);
        $initialize();
    }

    public DemandReplyItem(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public DemandReplyItem(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public DemandReplyItem(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__openForwardButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.openForward(this);
    }

    public void doActionPerformed__on__openReplyButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.openReply(this);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public Boolean getEditable() {
        return editable;
    }

    public DemandRepliesUIHandler getHandler() {
        return handler;
    }

    public JButton getOpenForwardButton() {
        return openForwardButton;
    }

    public JButton getOpenReplyButton() {
        return openReplyButton;
    }

    public Reply getReply() {
        return reply;
    }

    public JLabel getReplyDateLabel() {
        return replyDateLabel;
    }

    public JLabel getReplySubjectLabel() {
        return replySubjectLabel;
    }

    public JToolBar getToolbar() {
        return toolbar;
    }

    public Boolean isEditable() {
        return editable !=null && editable;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setEditable(Boolean editable) {
        Boolean oldValue = this.editable;
        this.editable = editable;
        firePropertyChange(PROPERTY_EDITABLE, oldValue, editable);
    }

    public void setReply(Reply reply) {
        Reply oldValue = this.reply;
        this.reply = reply;
        firePropertyChange(PROPERTY_REPLY, oldValue, reply);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToReplyPanel() {
        if (!allComponentsCreated) {
            return;
        }
        add(replyDateLabel, BorderLayout.WEST);
        add(replySubjectLabel, BorderLayout.CENTER);
        add(toolbar, BorderLayout.EAST);
    }

    protected void addChildrenToToolbar() {
        if (!allComponentsCreated) {
            return;
        }
        toolbar.add(openForwardButton);
        toolbar.add(openReplyButton);
    }

    protected void createEditable() {
        $objectMap.put("editable", editable = true);
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = getContextValue(DemandRepliesUIHandler.class));
    }

    protected void createOpenForwardButton() {
        $objectMap.put("openForwardButton", openForwardButton = new JButton());
        
        openForwardButton.setName("openForwardButton");
        openForwardButton.setToolTipText(t("faxtomail.demandReplies.action.forward.tip"));
        openForwardButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__openForwardButton"));
    }

    protected void createOpenReplyButton() {
        $objectMap.put("openReplyButton", openReplyButton = new JButton());
        
        openReplyButton.setName("openReplyButton");
        openReplyButton.setToolTipText(t("faxtomail.demandReplies.action.open.tip"));
        openReplyButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__openReplyButton"));
    }

    protected void createReply() {
        $objectMap.put("reply", reply = null);
    }

    protected void createReplyDateLabel() {
        $objectMap.put("replyDateLabel", replyDateLabel = new JLabel());
        
        replyDateLabel.setName("replyDateLabel");
        if (replyDateLabel.getFont() != null) {
            replyDateLabel.setFont(replyDateLabel.getFont().deriveFont(replyDateLabel.getFont().getStyle() | Font.ITALIC));
        }
    }

    protected void createReplySubjectLabel() {
        $objectMap.put("replySubjectLabel", replySubjectLabel = new JLabel());
        
        replySubjectLabel.setName("replySubjectLabel");
    }

    protected void createToolbar() {
        $objectMap.put("toolbar", toolbar = new JToolBar());
        
        toolbar.setName("toolbar");
        toolbar.setFloatable(false);
        toolbar.setBorderPainted(false);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToReplyPanel();
        addChildrenToToolbar();
        
        // apply 3 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 4 property setters
        setBorder( BorderFactory.createEmptyBorder(2, 3, 2, 3) );
        openForwardButton.setIcon(SwingUtil.createActionIcon("transmit"));
        openReplyButton.setIcon(SwingUtil.createActionIcon("open"));
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("replyPanel", replyPanel);
        createEditable();
        createReply();
        createHandler();
        createReplyDateLabel();
        createReplySubjectLabel();
        createToolbar();
        createOpenForwardButton();
        createOpenReplyButton();
        // inline creation of replyPanel
        setName("replyPanel");
        setLayout(new BorderLayout());
        
        // registers 3 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 3 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_REPLY_DATE_LABEL_TEXT, true ,"reply") {
        
            @Override
            public void processDataBinding() {
                if (getReply() != null) {
                    replyDateLabel.setText(t( getHandler().decorate(getReply().getSentDate()) + " - " ));
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_REPLY_SUBJECT_LABEL_TEXT, true ,"reply") {
        
            @Override
            public void processDataBinding() {
                if (getReply() != null) {
                    replySubjectLabel.setText(t( getReply().getSubject() ));
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_OPEN_FORWARD_BUTTON_VISIBLE, true ,"editable") {
        
            @Override
            public void processDataBinding() {
                openForwardButton.setVisible( isEditable() );
            }
        });
    }

}