/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.faxtomail;

import com.franciaflex.faxtomail.FaxToMailConfigurationOption;
import com.google.common.base.Charsets;
import com.google.common.collect.Maps;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.swing.KeyStroke;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.config.ApplicationConfig;
import org.nuiton.config.ApplicationConfigHelper;
import org.nuiton.config.ArgumentsParserException;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.ApplicationConfiguration;
import org.nuiton.jaxx.application.ApplicationIOUtil;
import org.nuiton.jaxx.application.ApplicationTechnicalException;
import org.nuiton.util.Version;

public class FaxToMailConfiguration
extends ApplicationConfiguration {
    private static final Log log = LogFactory.getLog(FaxToMailConfiguration.class);
    private static FaxToMailConfiguration instance;
    protected final String[] optionKeyToNotSave;
    protected File configFile;

    public static FaxToMailConfiguration getInstance() {
        return instance;
    }

    public static void setInstance(FaxToMailConfiguration instance) {
        FaxToMailConfiguration.instance = instance;
    }

    public FaxToMailConfiguration(ApplicationConfig applicationConfig) {
        super(applicationConfig);
        this.optionKeyToNotSave = null;
    }

    public FaxToMailConfiguration(String file, String ... args) {
        super(new ApplicationConfig());
        this.applicationConfig.setEncoding(Charsets.UTF_8.name());
        Set providers = ApplicationConfigHelper.getProviders(null, null, null, (boolean)true);
        ApplicationConfigHelper.loadAllDefaultOption((ApplicationConfig)this.applicationConfig, (Set)providers);
        Set optionToSkip = ApplicationConfigHelper.getTransientOptionKeys((Set)providers);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Option that won't be saved: " + optionToSkip));
        }
        this.optionKeyToNotSave = optionToSkip.toArray(new String[optionToSkip.size()]);
        this.applicationConfig.setConfigFileName(file);
        try {
            this.applicationConfig.parse(args);
        }
        catch (ArgumentsParserException e) {
            throw new ApplicationTechnicalException(I18n.t((String)"faxtomail.config.parse.error", (Object[])new Object[0]), (Throwable)e);
        }
        File faxToMailBasedir = this.applicationConfig.getOptionAsFile(FaxToMailConfigurationOption.BASEDIR.getKey());
        if (faxToMailBasedir == null) {
            faxToMailBasedir = new File("");
        }
        if (!faxToMailBasedir.isAbsolute()) {
            faxToMailBasedir = new File(faxToMailBasedir.getAbsolutePath());
        }
        if (faxToMailBasedir.getName().equals("..")) {
            faxToMailBasedir = faxToMailBasedir.getParentFile().getParentFile();
        }
        if (faxToMailBasedir.getName().equals(".")) {
            faxToMailBasedir = faxToMailBasedir.getParentFile();
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Application basedir: " + faxToMailBasedir));
        }
        this.applicationConfig.setOption(FaxToMailConfigurationOption.BASEDIR.getKey(), faxToMailBasedir.getAbsolutePath());
    }

    public void prepareDirectories() {
        File dataDirectory = this.getDataDirectory();
        ApplicationIOUtil.forceMkdir((File)dataDirectory, (String)I18n.t((String)"faxtomail.service.mkDir.error", (Object[])new Object[]{dataDirectory}));
        File tmpDirectory = this.getTmpDirectory();
        if (tmpDirectory.exists()) {
            ApplicationIOUtil.deleteDirectory((File)tmpDirectory, (String)I18n.t((String)"faxtomail.service.config.deleteTempDirectory.error", (Object[])new Object[]{tmpDirectory}));
        }
        ApplicationIOUtil.forceMkdir((File)tmpDirectory, (String)I18n.t((String)"faxtomail.service.mkDir.error", (Object[])new Object[]{tmpDirectory}));
    }

    public File getConfigFile() {
        if (this.configFile == null) {
            File dir = this.getBasedir();
            if (dir == null || !dir.exists() || !this.isFullLaunchMode()) {
                dir = new File(this.applicationConfig.getUserConfigDirectory());
            }
            this.configFile = new File(dir, this.applicationConfig.getConfigFileName());
        }
        return this.configFile;
    }

    public void save() {
        File file = this.getConfigFile();
        if (log.isInfoEnabled()) {
            log.info((Object)("Save configuration at: " + file));
        }
        try {
            this.applicationConfig.save(file, false, this.optionKeyToNotSave);
        }
        catch (IOException e) {
            throw new ApplicationTechnicalException(I18n.t((String)"faxtomail.config.save.error", (Object[])new Object[]{file}), (Throwable)e);
        }
    }

    public String toString() {
        return ReflectionToStringBuilder.toString((Object)((Object)this));
    }

    public void setCsvSeparator(char c) {
        this.applicationConfig.setOption(FaxToMailConfigurationOption.CSV_SEPARATOR.getKey(), c + "");
    }

    public boolean isDevMode() {
        boolean isDevMode = this.applicationConfig.getOptionAsBoolean(FaxToMailConfigurationOption.DEV_MODE.getKey());
        return isDevMode;
    }

    public Map<String, String> getTopiaProperties() {
        HashMap jpaParameters = Maps.newHashMap();
        Properties hibernateProperties = this.applicationConfig.getOptionStartsWith("hibernate");
        jpaParameters.putAll(hibernateProperties);
        return jpaParameters;
    }

    public String getSmtpHost() {
        return this.applicationConfig.getOption(FaxToMailConfigurationOption.SMTP_HOST.getKey());
    }

    public int getSmtpPort() {
        return this.applicationConfig.getOptionAsInt(FaxToMailConfigurationOption.SMTP_PORT.getKey());
    }

    public String getSmtpUser() {
        return this.applicationConfig.getOption(FaxToMailConfigurationOption.SMTP_USER.getKey());
    }

    public String getSmtpPassword() {
        return this.applicationConfig.getOption(FaxToMailConfigurationOption.SMTP_PASSWORD.getKey());
    }

    public boolean getSmtpUseSsl() {
        return this.applicationConfig.getOptionAsBoolean(FaxToMailConfigurationOption.SMTP_SSL.getKey());
    }

    public String getLdapHost() {
        return this.applicationConfig.getOption(FaxToMailConfigurationOption.LDAP_HOST.getKey());
    }

    public int getLdapPort() {
        return this.applicationConfig.getOptionAsInt(FaxToMailConfigurationOption.LDAP_PORT.getKey());
    }

    public String getLdapUser() {
        return this.applicationConfig.getOption(FaxToMailConfigurationOption.LDAP_USER.getKey());
    }

    public String getLdapPassword() {
        return this.applicationConfig.getOption(FaxToMailConfigurationOption.LDAP_PASSWORD.getKey());
    }

    public String getInstanceUrl() {
        return this.applicationConfig.getOption(FaxToMailConfigurationOption.INSTANCE_URL.getKey());
    }

    public String getInstanceDisclaimer() {
        return this.applicationConfig.getOption(FaxToMailConfigurationOption.INSTANCE_DISCLAIMER.getKey());
    }

    public File getStorageFile() {
        return this.applicationConfig.getOptionAsFile(FaxToMailConfigurationOption.STORAGE_FILE.getKey());
    }

    public boolean isLogConfigurationProvided() {
        boolean logConfigurationProvided = StringUtils.isNotBlank((CharSequence)this.applicationConfig.getOption(FaxToMailConfigurationOption.LOG_CONFIGURATION_FILE.getKey()));
        return logConfigurationProvided;
    }

    public File getLogConfigurationFile() {
        return this.applicationConfig.getOptionAsFile(FaxToMailConfigurationOption.LOG_CONFIGURATION_FILE.getKey());
    }

    public String getApplicationName() {
        return "FaxToMail";
    }

    public Version getVersion() {
        return this.applicationConfig.getOptionAsVersion(FaxToMailConfigurationOption.VERSION.getKey());
    }

    public URL getSiteUrl() {
        return this.applicationConfig.getOptionAsURL(FaxToMailConfigurationOption.SITE_URL.getKey());
    }

    public String getOrganizationName() {
        return this.applicationConfig.getOption(FaxToMailConfigurationOption.ORGANIZATION_NAME.getKey());
    }

    public int getInceptionYear() {
        return this.applicationConfig.getOptionAsInt(FaxToMailConfigurationOption.INCEPTION_YEAR.getKey());
    }

    public File getBasedir() {
        File result = this.applicationConfig.getOptionAsFile(FaxToMailConfigurationOption.BASEDIR.getKey());
        return result;
    }

    public File getDemoDirectory() {
        File result = this.applicationConfig.getOptionAsFile(FaxToMailConfigurationOption.DEMO_DIRECTORY.getKey());
        return result;
    }

    public File getDataDirectory() {
        File result = this.applicationConfig.getOptionAsFile(FaxToMailConfigurationOption.DATA_DIRECTORY.getKey());
        return result;
    }

    public File getEdiDirectory() {
        File result = this.applicationConfig.getOptionAsFile(FaxToMailConfigurationOption.EDI_DIRECTORY.getKey());
        return result;
    }

    public File getTmpDirectory() {
        File result = this.applicationConfig.getOptionAsFile(FaxToMailConfigurationOption.TMP_DIRECTORY.getKey());
        return result;
    }

    public File newTempFile(String basename) {
        return new File(this.getTmpDirectory(), basename + "_" + System.nanoTime());
    }

    public char getCsvSeparator() {
        return this.applicationConfig.getOption(FaxToMailConfigurationOption.CSV_SEPARATOR.getKey()).charAt(0);
    }

    public boolean isFullLaunchMode() {
        return "full".equals(this.getFaxToMailLaunchMode());
    }

    public String getFaxToMailLaunchMode() {
        return this.applicationConfig.getOption(FaxToMailConfigurationOption.FAXTOMAIL_LAUNCH_MODE.getKey());
    }

    public File getUIConfigFile() {
        return this.applicationConfig.getOptionAsFile(FaxToMailConfigurationOption.UI_CONFIG_FILE.getKey());
    }

    public File getStartActionFile() {
        return this.applicationConfig.getOptionAsFile(FaxToMailConfigurationOption.START_ACTION_FILE.getKey());
    }

    public KeyStroke getShortCut(String actionName) {
        KeyStroke result = this.applicationConfig.getOptionAsKeyStroke("faxtomail.ui." + actionName);
        return result;
    }

    public boolean isAutoPopupNumberEditor() {
        return this.applicationConfig.getOptionAsBoolean(FaxToMailConfigurationOption.AUTO_POPUP_NUMBER_EDITOR.getKey());
    }

    public boolean isShowNumberEditorButton() {
        return this.applicationConfig.getOptionAsBoolean(FaxToMailConfigurationOption.SHOW_NUMBER_EDITOR_BUTTON.getKey());
    }

    public Color getColorBlockingLayer() {
        return this.applicationConfig.getOptionAsColor(FaxToMailConfigurationOption.COLOR_BLOCKING_LAYER.getKey());
    }

    public Color getColorAlternateRow() {
        return this.applicationConfig.getOptionAsColor(FaxToMailConfigurationOption.COLOR_ALTERNATE_ROW.getKey());
    }

    public Color getColorSelectedRow() {
        return this.applicationConfig.getOptionAsColor(FaxToMailConfigurationOption.COLOR_SELECTED_ROW.getKey());
    }

    public KeyStroke getShortcutClosePopup() {
        return this.applicationConfig.getOptionAsKeyStroke(FaxToMailConfigurationOption.SHORTCUT_CLOSE_POPUP.getKey());
    }

    public String getDateFormat() {
        return this.applicationConfig.getOption(FaxToMailConfigurationOption.DATE_FORMAT.getKey());
    }

    public File getNewTmpDirectory(String name) {
        return new File(this.getTmpDirectory(), name + "_" + System.nanoTime());
    }

    public File getI18nDirectory() {
        return this.applicationConfig.getOptionAsFile(FaxToMailConfigurationOption.FAXTOMAIL_I18N_DIRECTORY.getKey());
    }

    public Locale getI18nLocale() {
        return this.applicationConfig.getOptionAsLocale(FaxToMailConfigurationOption.FAXTOMAIL_I18N_LOCALE.getKey());
    }

    public void setI18nLocale(Locale locale) {
        this.applicationConfig.setOption(FaxToMailConfigurationOption.FAXTOMAIL_I18N_LOCALE.getKey(), locale.toString());
    }
}

