/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.faxtomail.ui.swing.actions;

import com.franciaflex.faxtomail.persistence.entities.Email;
import com.franciaflex.faxtomail.services.service.EmailService;
import com.franciaflex.faxtomail.ui.swing.actions.AbstractFaxToMailAction;
import com.franciaflex.faxtomail.ui.swing.content.demande.DemandeUIModel;
import com.franciaflex.faxtomail.ui.swing.content.reply.ReplyFormUI;
import com.franciaflex.faxtomail.ui.swing.content.reply.ReplyFormUIHandler;
import com.franciaflex.faxtomail.ui.swing.content.reply.ReplyFormUIModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class ReplyAction
extends AbstractFaxToMailAction<ReplyFormUIModel, ReplyFormUI, ReplyFormUIHandler> {
    private static final Log log = LogFactory.getLog(ReplyAction.class);
    private EmailService emailService;

    public ReplyAction(ReplyFormUIHandler handler) {
        super(handler, false);
        this.setActionDescription(I18n.t((String)"faxtomail.action.reply.tip", (Object[])new Object[0]));
    }

    @Override
    public void doAction() throws Exception {
        log.info((Object)"do reply");
        ReplyFormUIModel model = (ReplyFormUIModel)this.getModel();
        this.emailService = this.getContext().getEmailService();
        DemandeUIModel originalDemand = ((ReplyFormUIModel)this.getModel()).getOriginalDemand();
        Email email = this.emailService.reply(model.getFrom(), model.getTo(), model.getSubject(), model.getMessage(), model.getAttachments(), originalDemand.getTopiaId(), this.getContext().getCurrentUser());
        originalDemand.fromEntity(email);
    }

    public void postSuccessAction() {
        super.postSuccessAction();
        ((ReplyFormUIHandler)this.handler).closeFrame();
    }
}

