package com.franciaflex.faxtomail.ui.swing.content.demande.replies;

/*
 * #%L
 * FaxToMail :: UI
 * $Id: DemandRepliesUIHandler.java 82 2014-05-20 14:25:32Z echatellier $
 * $HeadURL: http://svn.codelutin.com/faxtomail/tags/faxtomail-0.1/faxtomail-ui-swing/src/main/java/com/franciaflex/faxtomail/ui/swing/content/demande/replies/DemandRepliesUIHandler.java $
 * %%
 * Copyright (C) 2014 Franciaflex, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import static org.nuiton.i18n.I18n.t;

import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;

import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Part;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.swing.AbstractCellEditor;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

import jaxx.runtime.validator.swing.SwingValidator;

import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.HighlighterFactory;

import com.franciaflex.faxtomail.persistence.entities.AttachmentFile;
import com.franciaflex.faxtomail.persistence.entities.AttachmentFileImpl;
import com.franciaflex.faxtomail.persistence.entities.Email;
import com.franciaflex.faxtomail.persistence.entities.Reply;
import com.franciaflex.faxtomail.ui.swing.content.demande.DemandeUIModel;
import com.franciaflex.faxtomail.ui.swing.content.reply.ReplyFormUI;
import com.franciaflex.faxtomail.ui.swing.content.reply.ReplyFormUIModel;
import com.franciaflex.faxtomail.ui.swing.util.AbstractToolbarPopupHandler;
import com.google.common.collect.Iterables;

/**
 * @author Kevin Morin (Code Lutin)
 * @since x.x
 */
public class DemandRepliesUIHandler extends AbstractToolbarPopupHandler<DemandeUIModel, DemandRepliesUI> {

    private final static Log log = LogFactory.getLog(DemandRepliesUIHandler.class);

//    @Override
//    public void beforeInit(DemandRepliesUI ui) {
//        super.beforeInit(ui);
//
//        DemandeUIModel currentEmail = getContext().getCurrentEmail();
//        this.ui.setContextValue(currentEmail);
//    }

    @Override
    public void afterInit(DemandRepliesUI ui) {
        super.afterInit(ui);

        initTable(ui.getReplies());

        final PropertyChangeListener listener = new PropertyChangeListener() {
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                updateTable();
            }
        };
        getUI().addPropertyChangeListener(DemandRepliesUI.PROPERTY_MODEL, new PropertyChangeListener() {
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                DemandeUIModel oldModel = (DemandeUIModel) evt.getOldValue();
                if (oldModel != null) {
                    oldModel.removePropertyChangeListener(Email.PROPERTY_REPLIES, listener);
                }
                DemandeUIModel newModel = (DemandeUIModel) evt.getNewValue();
                if (newModel != null) {
                    newModel.addPropertyChangeListener(Email.PROPERTY_REPLIES, listener);
                }
                updateTable();
            }
        });
    }

    protected void updateTable() {
        AbstractTableModel tableModel = (AbstractTableModel) getUI().getReplies().getModel();
        tableModel.fireTableDataChanged();
    }

    protected void initTable(JXTable table) {

        TableModel demandRepliesTableModel = new AbstractTableModel() {
            @Override
            public int getRowCount() {
                DemandeUIModel model = getModel();
                return model == null ? 0 : model.sizeReplies();
            }

            @Override
            public int getColumnCount() {
                return 1;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                DemandeUIModel model = getModel();
                return model == null ? null : Iterables.get(model.getReplies(), rowIndex);
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return true;
            }
        };

        demandRepliesTableModel.addTableModelListener(new TableModelListener() {
            @Override
            public void tableChanged(TableModelEvent e) {
                getUI().pack();
            }
        });

        TableColumnModel columnModel = new DefaultTableColumnModel();
        TableColumn column = new TableColumn();
        column.setCellRenderer(new DemandReplyItemRenderer());
        column.setCellEditor(new DemandReplyItemEditor());
        columnModel.addColumn(column);

        table.setModel(demandRepliesTableModel);
        table.setColumnModel(columnModel);
        table.addHighlighter(HighlighterFactory.createAlternateStriping());
    }

    @Override
    public void onCloseUI() {
    }

    @Override
    public SwingValidator<DemandeUIModel> getValidator() {
        return null;
    }

    @Override
    protected JComponent getComponentToFocus() {
        return null;
    }

    public void openReply(Reply reply) {
        closeEditor();

        try {
            ReplyFormUI dialogContent = new ReplyFormUI(ui);
            Message message = new MimeMessage(null, new ByteArrayInputStream(reply.getEmailSource().getBytes()));
            ReplyFormUIModel replyModel = dialogContent.getModel();
            replyModel.setReadonly(true);
            replyModel.setSubject(message.getSubject());
            replyModel.setTo(message.getAllRecipients()[0].toString());
            replyModel.setFrom(message.getFrom()[0].toString());

            if (message.isMimeType("multipart/*")) {
                decomposeMultipartEmail(message, replyModel, reply.getTopiaId());

            } else {
                String content = IOUtils.toString(message.getInputStream());
                replyModel.setMessage(content);
            }

            openFrame(dialogContent, t("faxtomail.reply.title", getModel().getSubject()), new Dimension(800, 600));

        } catch (Exception e) {
            getContext().getErrorHelper().showErrorDialog(t("faxtomail.demandReplies.error"));
        }

//        FaxToMailUIContext context = getContext();
//        context.setCurrentEmails(demande);
//        context.getActionEngine().runAction(new ShowDemandeAction(context.getMainUI().getHandler()));
    }

    /**
     * Decompose a multipart part.
     * - sets the email content if the part contains a text bodypart
     * - adds attachments to the email
     *
     * @param part the part to decompose
     * @throws Exception
     */
    protected void decomposeMultipartEmail(Part part, ReplyFormUIModel reply, String topiaId) throws Exception {
        DataSource dataSource = part.getDataHandler().getDataSource();
        MimeMultipart mimeMultipart = new MimeMultipart(dataSource);
        int multiPartCount = mimeMultipart.getCount();

        for (int j = 0; j < multiPartCount; j++) {
            BodyPart bp = mimeMultipart.getBodyPart(j);

            // if it is a text part, the,n this is the email content
            String disposition = bp.getDisposition();
            if (bp.isMimeType("text/*") &&  !Part.ATTACHMENT.equals(disposition)) {
                String content = IOUtils.toString(bp.getInputStream());
                reply.setMessage(content);

                // if it is multipart part, decompose it
            } else if (bp.isMimeType("multipart/*")) {
                decomposeMultipartEmail(bp, reply, topiaId);

                // else, this is an attachment
            } else {
                String fileName = bp.getFileName();
                if (fileName == null) {
                    fileName = bp.getHeader("Content-ID")[0];
                    // remove the guillemets between the id
                    fileName = fileName.replaceFirst("^<(.*)>$", "$1");
                }
                log.debug("FileName : " + fileName);

                /*File dir = new File(FileUtils.getTempDirectory(), topiaId);
                if (!dir.exists()) {
                    dir.mkdir();
                }
                File file = new File(dir, fileName);*/

                ByteArrayOutputStream fos = new ByteArrayOutputStream();

                DataHandler dh = bp.getDataHandler();
                dh.writeTo(fos);

                // copy content into an empty attachment
                AttachmentFile attachment = new AttachmentFileImpl();
                attachment.setContent(fos.toByteArray());
                reply.addAttachment(attachment);
            }
        }
    }

    protected class DemandReplyItemRenderer extends DemandReplyItem
                                            implements TableCellRenderer {

        public DemandReplyItemRenderer() {
            super(DemandRepliesUIHandler.this);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value,
                                                       boolean isSelected, boolean hasFocus, int row, int column) {
            Reply reply = (Reply) value;
            setReply(reply);
            return this;
        }
    }

    protected class DemandReplyItemEditor extends AbstractCellEditor implements TableCellEditor {

        protected DemandReplyItem demandReplyItem;

        public DemandReplyItemEditor() {
            demandReplyItem = new DemandReplyItem(DemandRepliesUIHandler.this);
        }

        public Component getTableCellEditorComponent(JTable table, Object value,
                                                     boolean isSelected, int row, int column) {
            Reply reply = (Reply) value;
            demandReplyItem.setReply(reply);

            return demandReplyItem;
        }

        @Override
        public Object getCellEditorValue() {
            return demandReplyItem.getReply();
        }

        public boolean stopCellEditing() {
            return super.stopCellEditing();
        }

        protected void fireEditingStopped() {
            super.fireEditingStopped();
        }
    }
}
