/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdk;

import com.box.sdk.BoxAPIConnection;
import com.box.sdk.BoxAPIException;
import com.box.sdk.BoxCollaboration;
import com.box.sdk.BoxCollection;
import com.box.sdk.BoxComment;
import com.box.sdk.BoxDevicePin;
import com.box.sdk.BoxEvent;
import com.box.sdk.BoxFile;
import com.box.sdk.BoxFileRequest;
import com.box.sdk.BoxFileUploadSession;
import com.box.sdk.BoxFileVersionLegalHold;
import com.box.sdk.BoxFileVersionRetention;
import com.box.sdk.BoxFolder;
import com.box.sdk.BoxFolderLock;
import com.box.sdk.BoxGroup;
import com.box.sdk.BoxGroupMembership;
import com.box.sdk.BoxJSONObject;
import com.box.sdk.BoxLegalHoldAssignment;
import com.box.sdk.BoxLegalHoldPolicy;
import com.box.sdk.BoxResourceType;
import com.box.sdk.BoxRetentionPolicy;
import com.box.sdk.BoxRetentionPolicyAssignment;
import com.box.sdk.BoxStoragePolicy;
import com.box.sdk.BoxStoragePolicyAssignment;
import com.box.sdk.BoxTask;
import com.box.sdk.BoxTaskAssignment;
import com.box.sdk.BoxUser;
import com.box.sdk.BoxWebHook;
import com.box.sdk.BoxWebLink;
import com.eclipsesource.json.JsonObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class BoxResource {
    private static final Map<String, Class<? extends BoxResource>> RESOURCE_CLASS_BY_TYPE = BoxResource.initResourceClassByType();
    private final BoxAPIConnection api;
    private final String id;

    public BoxResource(BoxAPIConnection api, String id) {
        this.api = api;
        this.id = id;
    }

    private static Map<String, Class<? extends BoxResource>> initResourceClassByType() {
        ConcurrentHashMap<String, Class<BoxFileRequest>> result = new ConcurrentHashMap<String, Class<BoxFileRequest>>();
        result.put(BoxResource.getResourceType(BoxFolder.class), BoxFolder.class);
        result.put(BoxResource.getResourceType(BoxFile.class), BoxFile.class);
        result.put(BoxResource.getResourceType(BoxComment.class), BoxComment.class);
        result.put(BoxResource.getResourceType(BoxCollaboration.class), BoxCollaboration.class);
        result.put(BoxResource.getResourceType(BoxTask.class), BoxTask.class);
        result.put(BoxResource.getResourceType(BoxTaskAssignment.class), BoxTaskAssignment.class);
        result.put(BoxResource.getResourceType(BoxUser.class), BoxUser.class);
        result.put(BoxResource.getResourceType(BoxGroup.class), BoxGroup.class);
        result.put(BoxResource.getResourceType(BoxGroupMembership.class), BoxGroupMembership.class);
        result.put(BoxResource.getResourceType(BoxEvent.class), BoxEvent.class);
        result.put(BoxResource.getResourceType(BoxWebHook.class), BoxWebHook.class);
        result.put(BoxResource.getResourceType(BoxCollection.class), BoxCollection.class);
        result.put(BoxResource.getResourceType(BoxDevicePin.class), BoxDevicePin.class);
        result.put(BoxResource.getResourceType(BoxRetentionPolicy.class), BoxRetentionPolicy.class);
        result.put(BoxResource.getResourceType(BoxRetentionPolicyAssignment.class), BoxRetentionPolicyAssignment.class);
        result.put(BoxResource.getResourceType(BoxFileVersionRetention.class), BoxFileVersionRetention.class);
        result.put(BoxResource.getResourceType(BoxLegalHoldPolicy.class), BoxLegalHoldPolicy.class);
        result.put(BoxResource.getResourceType(BoxLegalHoldAssignment.class), BoxLegalHoldAssignment.class);
        result.put(BoxResource.getResourceType(BoxFileVersionLegalHold.class), BoxFileVersionLegalHold.class);
        result.put(BoxResource.getResourceType(BoxFileUploadSession.class), BoxFileUploadSession.class);
        result.put(BoxResource.getResourceType(BoxWebLink.class), BoxWebLink.class);
        result.put(BoxResource.getResourceType(BoxStoragePolicy.class), BoxStoragePolicy.class);
        result.put(BoxResource.getResourceType(BoxStoragePolicyAssignment.class), BoxStoragePolicyAssignment.class);
        result.put(BoxResource.getResourceType(BoxFolderLock.class), BoxFolderLock.class);
        result.put(BoxResource.getResourceType(BoxFileRequest.class), BoxFileRequest.class);
        return Collections.unmodifiableMap(result);
    }

    public static String getResourceType(Class<? extends BoxResource> clazz) {
        BoxResourceType resource = clazz.getAnnotation(BoxResourceType.class);
        if (resource == null) {
            throw new IllegalArgumentException("Provided BoxResource type does not have @BoxResourceType annotation.");
        }
        return resource.value();
    }

    static Info parseInfo(BoxAPIConnection api, JsonObject jsonObject) {
        String type = jsonObject.get("type").asString();
        String id = jsonObject.get("id").asString();
        try {
            Class<? extends BoxResource> resourceClass = RESOURCE_CLASS_BY_TYPE.get(type);
            Constructor<? extends BoxResource> resourceConstructor = resourceClass.getConstructor(BoxAPIConnection.class, String.class);
            Class<?> infoClass = resourceClass.getClassLoader().loadClass(resourceClass.getCanonicalName() + "$Info");
            Constructor<?> infoConstructor = infoClass.getDeclaredConstructor(resourceClass, JsonObject.class);
            BoxResource resource = resourceConstructor.newInstance(api, id);
            return (Info)infoConstructor.newInstance(resource, jsonObject);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            throw new BoxAPIException("Can not create BoxResource.Info instance:", e);
        }
        catch (InvocationTargetException e) {
            throw new BoxAPIException("Can not create BoxResource.Info instance:", e);
        }
        catch (InstantiationException e) {
            throw new BoxAPIException("Can not create BoxResource.Info instance:", e);
        }
    }

    public BoxAPIConnection getAPI() {
        return this.api;
    }

    public String getID() {
        return this.id;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (this.getClass().equals(other.getClass())) {
            BoxResource otherResource = (BoxResource)other;
            return this.getID().equals(otherResource.getID());
        }
        return false;
    }

    public int hashCode() {
        return this.getID().hashCode();
    }

    public abstract class Info
    extends BoxJSONObject {
        public Info() {
        }

        public Info(String json) {
            super(json);
        }

        Info(JsonObject jsonObject) {
            super(jsonObject);
        }

        public String getID() {
            return BoxResource.this.getID();
        }

        public abstract BoxResource getResource();
    }
}

